/*
 * Decompiled with CFR 0.152.
 */
package net.christophschubert.cp.testcontainers;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;
import org.testcontainers.utility.DockerImageName;

public class LdapContainer
extends GenericContainer<LdapContainer> {
    static final DockerImageName baseImageName = DockerImageName.parse((String)"osixia/openldap");
    static final String defaultTag = "1.3.0";
    static final String ldifBootstrapPath = "/container/service/slapd/assets/config/bootstrap/ldif/custom/custom.ldif";

    public LdapContainer() {
        this(Set.of("alice", "barney", "sr-user"));
    }

    public LdapContainer(Set<String> usernames) {
        this(usernames.stream().collect(Collectors.toMap(s -> s, s -> s + "-secret")));
    }

    public LdapContainer(Map<String, String> ldapUsers) {
        super((Future)((ImageFromDockerfile)new ImageFromDockerfile().withFileFromString("custom.ldif", LdapContainer.formatLdif(ldapUsers))).withDockerfileFromBuilder(db -> ((DockerfileBuilder)((DockerfileBuilder)db.from(baseImageName.getUnversionedPart() + ":1.3.0")).copy("custom.ldif", ldifBootstrapPath)).build()));
        this._configure();
    }

    public LdapContainer(String pathToLdif) {
        super(baseImageName.withTag(defaultTag));
        this.withFileSystemBind(pathToLdif, ldifBootstrapPath);
        this._configure();
    }

    private void _configure() {
        this.withNetworkAliases(new String[]{"ldap"});
        this.withEnv("LDAP_ORGANISATION", "Confluent");
        this.withEnv("LDAP_DOMAIN", "confluent.io");
        this.withCommand("--copy-service --loglevel debug");
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*slapd starting.*", (int)2));
    }

    static String formatLdif(Map<String, String> ldapUsers) {
        String header = "dn: ou=users,dc=confluent,dc=io\nobjectClass: organizationalUnit\nou: Users\n\ndn: ou=groups,dc=confluent,dc=io\nobjectClass: organizationalUnit\nou: Groups\n\n";
        StringBuilder builder = new StringBuilder("dn: ou=users,dc=confluent,dc=io\nobjectClass: organizationalUnit\nou: Users\n\ndn: ou=groups,dc=confluent,dc=io\nobjectClass: organizationalUnit\nou: Groups\n\n");
        List<String> groups = List.of("Kafka Developers", "ProjectA", "ProjectB");
        int startGidNumber = 5000;
        for (int i = 0; i < groups.size(); ++i) {
            builder.append(LdapContainer.formatGroupEntry(groups.get(i), 5000 + i));
        }
        int uidNumber = 10000;
        for (Map.Entry<String, String> entry : ldapUsers.entrySet()) {
            builder.append(LdapContainer.formatUserEntry(entry.getKey(), entry.getValue(), uidNumber++));
        }
        return builder.toString();
    }

    static String formatGroupEntry(String groupName, int gidNumber) {
        String template = "dn: cn=%s,ou=groups,{{ LDAP_BASE_DN }}\nobjectClass: top\nobjectClass: posixGroup\ncn: %s\ngidNumber: %d\n\n";
        return String.format("dn: cn=%s,ou=groups,{{ LDAP_BASE_DN }}\nobjectClass: top\nobjectClass: posixGroup\ncn: %s\ngidNumber: %d\n\n", groupName, groupName, gidNumber);
    }

    static String formatUserEntry(String username, String password, int uidNumber) {
        String template = "dn: cn=%s,ou=users,{{ LDAP_BASE_DN }}\nobjectClass: inetOrgPerson\nobjectClass: posixAccount\nuid: %s\ncn: %s\nsn: Snow\nuidNumber: %d\ngidNumber: 5000\nuserPassword: %s\nhomeDirectory: /home/%s\n\n";
        return String.format("dn: cn=%s,ou=users,{{ LDAP_BASE_DN }}\nobjectClass: inetOrgPerson\nobjectClass: posixAccount\nuid: %s\ncn: %s\nsn: Snow\nuidNumber: %d\ngidNumber: 5000\nuserPassword: %s\nhomeDirectory: /home/%s\n\n", username, username, username, uidNumber, password, username);
    }
}

