/*
 * Decompiled with CFR 0.152.
 */
package net.christophschubert.cp.testcontainers;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.christophschubert.cp.testcontainers.ConfluentServerConnectContainer;
import net.christophschubert.cp.testcontainers.ConfluentServerContainer;
import net.christophschubert.cp.testcontainers.KafkaConnectContainer;
import net.christophschubert.cp.testcontainers.KafkaContainerTools;
import net.christophschubert.cp.testcontainers.KsqlDBContainer;
import net.christophschubert.cp.testcontainers.LdapContainer;
import net.christophschubert.cp.testcontainers.RestProxyContainer;
import net.christophschubert.cp.testcontainers.SchemaRegistryContainer;
import net.christophschubert.cp.testcontainers.ZooKeeperContainer;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.lifecycle.Startables;
import org.testcontainers.utility.DockerImageName;

public class CPTestContainerFactory {
    String repository = "confluentinc";
    String tag = "7.0.1";
    final Network network;

    public CPTestContainerFactory(Network network) {
        Objects.requireNonNull(network);
        this.network = network;
    }

    public CPTestContainerFactory() {
        this(Network.newNetwork());
    }

    public String getTag() {
        return this.tag;
    }

    public CPTestContainerFactory withTag(String tag) {
        this.tag = tag;
        return this;
    }

    public LdapContainer createLdap(Set<String> userNames) {
        return (LdapContainer)new LdapContainer(userNames).withNetwork(this.network);
    }

    public LdapContainer createLdap() {
        return (LdapContainer)new LdapContainer().withNetwork(this.network);
    }

    public KafkaContainer createKafka() {
        return (KafkaContainer)new KafkaContainer(this.imageName("cp-kafka")).withNetwork(this.network);
    }

    public ConfluentServerContainer createConfluentServer() {
        return (ConfluentServerContainer)new ConfluentServerContainer(this.repository, this.tag).withNetwork(this.network);
    }

    public SchemaRegistryContainer createSchemaRegistry(KafkaContainer bootstrap) {
        return new SchemaRegistryContainer(this.imageName("cp-schema-registry"), bootstrap, this.network);
    }

    public KafkaConnectContainer createKafkaConnect(KafkaContainer bootstrap) {
        return new KafkaConnectContainer(this.imageName("cp-kafka-connect"), bootstrap, this.network);
    }

    public ConfluentServerConnectContainer createConfluentServerConnect(ConfluentServerContainer bootstrap) {
        return new ConfluentServerConnectContainer(this.imageName("cp-server-connect"), bootstrap, this.network);
    }

    public ConfluentServerConnectContainer createConfluentServerConnect(Collection<String> confluentHubComponents, ConfluentServerContainer bootstrap) {
        String baseImageName = this.repository + "/cp-server-connect-base:" + this.tag;
        ImageFromDockerfile image = KafkaConnectContainer.customImage(confluentHubComponents, baseImageName);
        return (ConfluentServerConnectContainer)new ConfluentServerConnectContainer(image, bootstrap, this.network).withEnv("CONNECT_PLUGIN_PATH", "/usr/share/confluent-hub-components");
    }

    public KafkaConnectContainer createReplicator(KafkaContainer bootstrap) {
        return new KafkaConnectContainer(this.imageName("cp-enterprise-replicator"), bootstrap, this.network);
    }

    public KafkaConnectContainer createCustomConnector(String hubComponent, KafkaContainer bootstrap) {
        return this.createCustomConnector(Collections.singleton(hubComponent), bootstrap);
    }

    public KafkaConnectContainer createCustomConnector(Set<String> hubComponents, KafkaContainer bootstrap) {
        String baseImageName = this.repository + "/cp-kafka-connect-base:" + this.tag;
        ImageFromDockerfile image = KafkaConnectContainer.customImage(hubComponents, baseImageName);
        return (KafkaConnectContainer)new KafkaConnectContainer(image, bootstrap, this.network).withEnv("CONNECT_PLUGIN_PATH", "/usr/share/confluent-hub-components");
    }

    public RestProxyContainer createRestProxy(KafkaContainer bootstrap) {
        return new RestProxyContainer(this.imageName("cp-kafka-rest"), bootstrap, this.network);
    }

    public KsqlDBContainer createKsqlDB(KafkaContainer bootstrap) {
        return new KsqlDBContainer(this.imageName("cp-ksqldb-server"), bootstrap, this.network);
    }

    public KsqlDBContainer createKsqDB(KafkaContainer bootstrap, String tag) {
        DockerImageName imageName = DockerImageName.parse((String)String.format("%s/ksqldb-server:%s", this.repository, tag));
        return new KsqlDBContainer(imageName, bootstrap, this.network);
    }

    DockerImageName imageName(String componentName) {
        return DockerImageName.parse((String)String.format("%s/%s:%s", this.repository, componentName, this.tag));
    }

    static String pToE(String componentPrefix, String propertyName) {
        return componentPrefix + "_" + propertyName.replace('.', '_').toUpperCase();
    }

    static String pToEKafka(String propertyName) {
        return CPTestContainerFactory.pToE("KAFKA", propertyName);
    }

    String generateRandom(int length) {
        return new Random().ints(length, 97, 123).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public ClusterSpec<KafkaContainer> createKafkaCluster(int numBrokers) {
        if (numBrokers < 1) {
            throw new IllegalArgumentException(String.format("numBrokers should be non-negative (was %d)", numBrokers));
        }
        ZooKeeperContainer zk = (ZooKeeperContainer)new ZooKeeperContainer(this.repository, this.tag).withNetwork(this.network);
        zk.start();
        int rf = Math.min(3, numBrokers);
        String clusterPrefix = this.generateRandom(7);
        List kafkas = IntStream.rangeClosed(1, numBrokers).mapToObj(id -> (KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)this.createKafka().withNetwork(this.network)).dependsOn(new Startable[]{zk})).withExternalZookeeper(zk.getInternalConnect()).withEnv("KAFKA_BROKER_ID", "" + id)).withNetworkAliases(new String[]{clusterPrefix + "-kafka-" + id})).map(kafkaContainer -> KafkaContainerTools.adjustReplicationFactors(kafkaContainer, rf)).collect(Collectors.toList());
        return new ClusterSpec<KafkaContainer>(List.of(zk), kafkas);
    }

    public ClusterSpec<ConfluentServerContainer> createConfluentServerCluster(int numServers) {
        if (numServers < 1) {
            throw new IllegalArgumentException(String.format("numBrokers should be non-negative (was %d)", numServers));
        }
        ZooKeeperContainer zk = (ZooKeeperContainer)new ZooKeeperContainer(this.repository, this.tag).withNetwork(this.network);
        zk.start();
        int rf = Math.min(3, numServers);
        String clusterPrefix = this.generateRandom(7);
        List servers = IntStream.rangeClosed(1, numServers).mapToObj(id -> (ConfluentServerContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)this.createConfluentServer().withNetwork(this.network)).dependsOn(new Startable[]{zk})).withExternalZookeeper(zk.getInternalConnect()).withEnv("KAFKA_BROKER_ID", "" + id)).withNetworkAliases(new String[]{clusterPrefix + "cp-server-" + id})).map(kafkaContainer -> KafkaContainerTools.adjustReplicationFactors(kafkaContainer, rf)).collect(Collectors.toList());
        return new ClusterSpec<ConfluentServerContainer>(List.of(zk), servers);
    }

    public static class ClusterSpec<C extends KafkaContainer> {
        public final List<ZooKeeperContainer> zks;
        public final List<C> kafkas;

        public ClusterSpec(List<ZooKeeperContainer> zks, List<C> kafkas) {
            this.zks = zks;
            this.kafkas = kafkas;
        }

        public void startAll() {
            try {
                Startables.deepStart(this.kafkas).get();
            }
            catch (InterruptedException | ExecutionException e) {
                String msg = String.format("Error starting up %s", this.kafkas);
                throw new RuntimeException(msg, e.getCause());
            }
        }

        public String getInternalBootstrap() {
            return null;
        }

        public String getBootstrap() {
            return this.kafkas.stream().map(c -> "localhost:" + c.getMappedPort(9093)).collect(Collectors.joining(","));
        }
    }
}

