/*
 * Decompiled with CFR 0.152.
 */
package com.tejpratapsingh.pdfcreator.views.basic;

import android.content.Context;
import android.graphics.Typeface;
import android.text.SpannableString;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.tejpratapsingh.pdfcreator.views.basic.PDFView;
import java.io.Serializable;

public class PDFTextView
extends PDFView
implements Serializable {
    private static final float TEXT_SIZE_HEADER = 32.0f;
    private static final float TEXT_SIZE_H1 = 24.0f;
    private static final float TEXT_SIZE_H2 = 20.0f;
    private static final float TEXT_SIZE_H3 = 16.0f;
    private static final float TEXT_SIZE_P = 12.0f;
    private static final float TEXT_SIZE_SMALL = 10.0f;
    private SpannableString text = new SpannableString((CharSequence)"");

    public PDFTextView(Context context, PDF_TEXT_SIZE size) {
        super(context);
        TextView textView = new TextView(context);
        LinearLayout.LayoutParams childLayoutParams = new LinearLayout.LayoutParams(-1, -2, 0.0f);
        textView.setLayoutParams((ViewGroup.LayoutParams)childLayoutParams);
        textView.setTextColor(-16777216);
        textView.setTextSize(0, size.getFontSize());
        super.setView((View)textView);
    }

    @Override
    protected PDFView addView(PDFView viewToAdd) throws IllegalStateException {
        throw new IllegalStateException("Cannot add subview to TextView");
    }

    public PDFTextView setText(SpannableString text) {
        this.text = text;
        this.getView().setText((CharSequence)text);
        return this;
    }

    public PDFTextView setText(String text) {
        this.text = new SpannableString((CharSequence)text);
        this.getView().setText((CharSequence)text);
        return this;
    }

    public SpannableString getText() {
        return this.text;
    }

    @Override
    public PDFTextView setLayout(LinearLayout.LayoutParams layoutParams) {
        super.setLayout(layoutParams);
        return this;
    }

    public PDFTextView setTextColor(int color2) {
        this.getView().setTextColor(color2);
        return this;
    }

    public PDFTextView setTextTypeface(Typeface typeface) {
        this.getView().setTypeface(typeface);
        return this;
    }

    public TextView getView() {
        return (TextView)super.getView();
    }

    public static enum PDF_TEXT_SIZE {
        HEADER(32.0f),
        H1(24.0f),
        H2(20.0f),
        H3(16.0f),
        P(12.0f),
        SMALL(10.0f);

        private float fontSize;

        public float getFontSize() {
            return this.fontSize;
        }

        private PDF_TEXT_SIZE(float action) {
            this.fontSize = action;
        }
    }
}

