/*
 * Decompiled with CFR 0.152.
 */
package com.github.tehras.loadingskeleton;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.facebook.shimmer.ShimmerFrameLayout;
import com.github.tehras.loadingskeleton.animators.DefaultLoadingSkeletonAnimator;
import com.github.tehras.loadingskeleton.helpers.LoadingSkeletonAnimator;
import com.github.tehras.loadingskeleton.helpers.LoadingSkeletonViewConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0017B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u0014\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0006\u0010\u0015\u001a\u00020\u0010J\u0006\u0010\u0016\u001a\u00020\u0010R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/github/tehras/loadingskeleton/LoadingSkeleton;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "(Landroid/content/Context;)V", "defStyleAttrs", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "builder", "Lcom/github/tehras/loadingskeleton/LoadingSkeleton$Builder;", "containerViewId", "attach", "performWarningCheck", "", "populateView", "v", "Landroid/view/ViewGroup;", "revertView", "start", "stop", "Builder", "loading-skeleton_release"})
public final class LoadingSkeleton
extends FrameLayout {
    private final int containerViewId = 10001;
    private Builder builder;

    private final LoadingSkeleton attach(Builder builder) {
        this.builder = builder;
        return this;
    }

    private final void performWarningCheck() {
        if (this.builder == null) {
            Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Please use LoadingSkeleton.Builder().attach() in order to use the loading effects");
        }
    }

    public final void stop() {
        this.performWarningCheck();
        if (this.getChildCount() != 1) {
            throw (Throwable)new RuntimeException("View must have 1 child");
        }
        View view = this.getChildAt(0);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ViewGroup container = (ViewGroup)view;
        if (container.getId() != this.containerViewId) {
            return;
        }
        View child = container.getChildAt(0);
        if (!(container instanceof ViewGroup)) {
            throw (Throwable)new Exception("Layout must be a ViewGroup");
        }
        this.revertView(container, this.builder);
        container.removeView(child);
        this.removeView((View)container);
        this.addView(child);
    }

    public final void start() {
        block4: {
            Builder builder;
            this.performWarningCheck();
            Builder builder2 = this.builder;
            if (builder2 == null) break block4;
            Builder it = builder = builder2;
            if (this.getChildCount() != 1) {
                throw (Throwable)new RuntimeException("View must have 1 child");
            }
            View layout = this.getChildAt(0);
            if (layout.getId() == this.containerViewId) {
                return;
            }
            this.removeView(layout);
            if (!(layout instanceof ViewGroup)) {
                throw (Throwable)new Exception("Layout must be a ViewGroup");
            }
            this.populateView((ViewGroup)layout, it);
            LoadingSkeletonAnimator loadingSkeletonAnimator = it.getSkeletonAnimator$loading_skeleton_release();
            ViewGroup container = (loadingSkeletonAnimator != null ? loadingSkeletonAnimator.getShimmer() : true) ? (ViewGroup)new ShimmerFrameLayout(this.getContext()) : (ViewGroup)new FrameLayout(this.getContext());
            container.setId(this.containerViewId);
            container.addView(layout);
            if (container instanceof ShimmerFrameLayout) {
                ((ShimmerFrameLayout)container).startShimmerAnimation();
            }
            this.addView((View)container);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void populateView(ViewGroup v, Builder builder) {
        block3: {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            ViewGroup viewGroup;
            ViewGroup viewGroup2 = v;
            if (viewGroup2 == null) break block3;
            ViewGroup it = viewGroup = viewGroup2;
            Iterable iterable = (Iterable)new IntRange(0, v.getChildCount());
            Iterator iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it2;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                View view = v.getChildAt((int)it2);
                collection.add(view);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                View it3 = (View)element$iv;
                if (it3 instanceof ViewGroup) {
                    this.populateView((ViewGroup)it3, builder);
                    continue;
                }
                if (!(it3 instanceof View)) continue;
                LoadingSkeletonViewConverter loadingSkeletonViewConverter = builder.getSkeletonViewConverter$loading_skeleton_release();
                if (loadingSkeletonViewConverter == null) continue;
                loadingSkeletonViewConverter.convertView(it3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void revertView(ViewGroup v, Builder builder) {
        block5: {
            Unit unit;
            Builder builder2;
            Builder builder3 = builder;
            if (builder3 == null) break block5;
            Builder builder4 = builder2 = builder3;
            ViewGroup viewGroup = v;
            if (viewGroup != null) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                ViewGroup viewGroup2;
                ViewGroup it = viewGroup2 = viewGroup;
                Iterable iterable = (Iterable)new IntRange(0, v.getChildCount());
                Iterator iterator = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                Iterator iterator2 = $receiver$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it2;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection = destination$iv$iv;
                    View view = v.getChildAt((int)it2);
                    collection.add(view);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (Object element$iv : $receiver$iv) {
                    View it3 = (View)element$iv;
                    if (it3 instanceof ViewGroup) {
                        this.revertView((ViewGroup)it3, builder4);
                        continue;
                    }
                    if (!(it3 instanceof View)) continue;
                    LoadingSkeletonViewConverter loadingSkeletonViewConverter = builder4.getSkeletonViewConverter$loading_skeleton_release();
                    if (loadingSkeletonViewConverter == null) continue;
                    loadingSkeletonViewConverter.revertView(it3);
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
    }

    private LoadingSkeleton(Context context, AttributeSet attrs, int defStyleAttrs) {
        super(context, attrs, defStyleAttrs);
        this.containerViewId = 10001;
    }

    public LoadingSkeleton(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    public LoadingSkeleton(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, null);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\nR(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR(\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\u0003\u001a\u0004\u0018\u00010\n@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/github/tehras/loadingskeleton/LoadingSkeleton$Builder;", "", "()V", "<set-?>", "Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonAnimator;", "skeletonAnimator", "getSkeletonAnimator$loading_skeleton_release", "()Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonAnimator;", "setSkeletonAnimator", "(Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonAnimator;)V", "Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewConverter;", "skeletonViewConverter", "getSkeletonViewConverter$loading_skeleton_release", "()Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewConverter;", "setSkeletonViewConverter", "(Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewConverter;)V", "attach", "Lcom/github/tehras/loadingskeleton/LoadingSkeleton;", "view", "loading-skeleton_release"})
    public static final class Builder {
        @Nullable
        private LoadingSkeletonAnimator skeletonAnimator;
        @Nullable
        private LoadingSkeletonViewConverter skeletonViewConverter;

        @Nullable
        public final LoadingSkeletonAnimator getSkeletonAnimator$loading_skeleton_release() {
            return this.skeletonAnimator;
        }

        private final void setSkeletonAnimator(LoadingSkeletonAnimator loadingSkeletonAnimator) {
            this.skeletonAnimator = loadingSkeletonAnimator;
        }

        @Nullable
        public final LoadingSkeletonViewConverter getSkeletonViewConverter$loading_skeleton_release() {
            return this.skeletonViewConverter;
        }

        private final void setSkeletonViewConverter(LoadingSkeletonViewConverter loadingSkeletonViewConverter) {
            this.skeletonViewConverter = loadingSkeletonViewConverter;
        }

        @NotNull
        public final Builder skeletonAnimator(@NotNull LoadingSkeletonAnimator skeletonAnimator) {
            Intrinsics.checkParameterIsNotNull((Object)skeletonAnimator, (String)"skeletonAnimator");
            this.skeletonAnimator = skeletonAnimator;
            return this;
        }

        @NotNull
        public final Builder skeletonViewConverter(@NotNull LoadingSkeletonViewConverter skeletonViewConverter) {
            Intrinsics.checkParameterIsNotNull((Object)skeletonViewConverter, (String)"skeletonViewConverter");
            this.skeletonViewConverter = skeletonViewConverter;
            return this;
        }

        @NotNull
        public final LoadingSkeleton attach(@NotNull LoadingSkeleton view) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)view), (String)"view");
            if (this.skeletonAnimator == null) {
                this.skeletonAnimator = DefaultLoadingSkeletonAnimator.INSTANCE.generate();
            }
            if (this.skeletonViewConverter == null) {
                this.skeletonViewConverter = new LoadingSkeletonViewConverter.Builder().build();
            }
            return view.attach(this);
        }
    }
}

