/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.schabi.newpipe.extractor.exceptions.ParsingException;

public class Parser {
    private Parser() {
    }

    public static String matchGroup1(String pattern, String input) throws RegexException {
        return Parser.matchGroup(pattern, input, 1);
    }

    public static String matchGroup(String pattern, String input, int group) throws RegexException {
        Pattern pat = Pattern.compile(pattern);
        Matcher mat = pat.matcher(input);
        boolean foundMatch = mat.find();
        if (foundMatch) {
            return mat.group(group);
        }
        if (input.length() > 1024) {
            throw new RegexException("failed to find pattern \"" + pattern);
        }
        throw new RegexException("failed to find pattern \"" + pattern + " inside of " + input + "\"");
    }

    public static boolean isMatch(String pattern, String input) {
        try {
            Parser.matchGroup1(pattern, input);
            return true;
        }
        catch (RegexException e) {
            return false;
        }
    }

    public static Map<String, String> compatParseMap(String input) throws UnsupportedEncodingException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String arg : input.split("&")) {
            String[] splitArg = arg.split("=");
            if (splitArg.length > 1) {
                map.put(splitArg[0], URLDecoder.decode(splitArg[1], "UTF-8"));
                continue;
            }
            map.put(splitArg[0], "");
        }
        return map;
    }

    public static class RegexException
    extends ParsingException {
        public RegexException(String message) {
            super(message);
        }
    }
}

