/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.stream;

import java.io.IOException;
import java.util.List;
import org.schabi.newpipe.extractor.Extractor;
import org.schabi.newpipe.extractor.StreamingService;
import org.schabi.newpipe.extractor.UrlIdHandler;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.exceptions.ParsingException;
import org.schabi.newpipe.extractor.stream.AudioStream;
import org.schabi.newpipe.extractor.stream.StreamInfoItem;
import org.schabi.newpipe.extractor.stream.StreamInfoItemCollector;
import org.schabi.newpipe.extractor.stream.StreamType;
import org.schabi.newpipe.extractor.stream.VideoStream;

public abstract class StreamExtractor
extends Extractor {
    public StreamExtractor(StreamingService service, String url) throws IOException, ExtractionException {
        super(service, url);
        this.fetchPage();
    }

    @Override
    protected UrlIdHandler getUrlIdHandler() throws ParsingException {
        return this.getService().getStreamUrlIdHandler();
    }

    public abstract String getUploadDate() throws ParsingException;

    public abstract String getThumbnailUrl() throws ParsingException;

    public abstract String getDescription() throws ParsingException;

    public abstract int getAgeLimit() throws ParsingException;

    public abstract long getLength() throws ParsingException;

    public abstract long getTimeStamp() throws ParsingException;

    public abstract long getViewCount() throws ParsingException;

    public abstract long getLikeCount() throws ParsingException;

    public abstract long getDislikeCount() throws ParsingException;

    public abstract String getUploaderUrl() throws ParsingException;

    public abstract String getUploaderName() throws ParsingException;

    public abstract String getUploaderAvatarUrl() throws ParsingException;

    public abstract String getDashMpdUrl() throws ParsingException;

    public abstract List<AudioStream> getAudioStreams() throws IOException, ExtractionException;

    public abstract List<VideoStream> getVideoStreams() throws IOException, ExtractionException;

    public abstract List<VideoStream> getVideoOnlyStreams() throws IOException, ExtractionException;

    public abstract StreamType getStreamType() throws ParsingException;

    public abstract StreamInfoItem getNextVideo() throws IOException, ExtractionException;

    public abstract StreamInfoItemCollector getRelatedVideos() throws IOException, ExtractionException;

    public abstract String getErrorMessage();
}

