/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.services.youtube;

import java.io.IOException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.schabi.newpipe.extractor.Downloader;
import org.schabi.newpipe.extractor.ListExtractor;
import org.schabi.newpipe.extractor.NewPipe;
import org.schabi.newpipe.extractor.StreamingService;
import org.schabi.newpipe.extractor.UrlIdHandler;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.exceptions.ParsingException;
import org.schabi.newpipe.extractor.kiosk.KioskExtractor;
import org.schabi.newpipe.extractor.services.youtube.YoutubeStreamInfoItemExtractor;
import org.schabi.newpipe.extractor.services.youtube.YoutubeTrendingUrlIdHandler;
import org.schabi.newpipe.extractor.stream.StreamInfoItemCollector;

public class YoutubeTrendingExtractor
extends KioskExtractor {
    private Document doc;

    public YoutubeTrendingExtractor(StreamingService service, String url, String nextStreamsUrl, String kioskId) throws IOException, ExtractionException {
        super(service, url, nextStreamsUrl, kioskId);
    }

    @Override
    public void fetchPage() throws IOException, ExtractionException {
        Downloader downloader = NewPipe.getDownloader();
        String contentCountry = this.getContentCountry();
        String url = this.getCleanUrl();
        if (contentCountry != null && !contentCountry.isEmpty()) {
            url = url + "?gl=" + contentCountry;
        }
        String pageContent = downloader.download(url);
        this.doc = Jsoup.parse((String)pageContent, (String)url);
    }

    @Override
    public UrlIdHandler getUrlIdHandler() {
        return new YoutubeTrendingUrlIdHandler();
    }

    @Override
    public ListExtractor.NextItemsResult getNextStreams() {
        return null;
    }

    @Override
    public String getName() throws ParsingException {
        try {
            Element a = this.doc.select("a[href*=\"/feed/trending\"]").first();
            Element span = a.select("span[class*=\"display-name\"]").first();
            Element nameSpan = span.select("span").first();
            return nameSpan.text();
        }
        catch (Exception e) {
            throw new ParsingException("Could not get Trending name", e);
        }
    }

    @Override
    public StreamInfoItemCollector getStreams() throws ParsingException {
        StreamInfoItemCollector collector = new StreamInfoItemCollector(this.getServiceId());
        Element ul = this.doc.select("ul[class*=\"expanded-shelf-content-list\"]").first();
        for (final Element li : ul.children()) {
            final Element el = li.select("div[class*=\"yt-lockup-dismissable\"]").first();
            collector.commit(new YoutubeStreamInfoItemExtractor(li){

                @Override
                public String getUrl() throws ParsingException {
                    try {
                        Element dl = el.select("h3").first().select("a").first();
                        return dl.attr("abs:href");
                    }
                    catch (Exception e) {
                        throw new ParsingException("Could not get web page url for the video", e);
                    }
                }

                @Override
                public String getName() throws ParsingException {
                    try {
                        Element dl = el.select("h3").first().select("a").first();
                        return dl.text();
                    }
                    catch (Exception e) {
                        throw new ParsingException("Could not get web page url for the video", e);
                    }
                }

                @Override
                public String getUploaderName() throws ParsingException {
                    try {
                        Element uploaderEl = el.select("div[class*=\"yt-lockup-byline \"]").first();
                        return uploaderEl.select("a").text();
                    }
                    catch (Exception e) {
                        throw new ParsingException("Could not get Uploader name");
                    }
                }

                @Override
                public String getThumbnailUrl() throws ParsingException {
                    try {
                        Element te = li.select("span[class=\"yt-thumb-simple\"]").first().select("img").first();
                        String url = te.attr("abs:src");
                        if (url.contains(".gif")) {
                            url = te.attr("abs:data-thumb");
                        }
                        return url;
                    }
                    catch (Exception e) {
                        throw new ParsingException("Could not get thumbnail url", e);
                    }
                }
            });
        }
        return collector;
    }
}

