/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.services.youtube;

import org.jsoup.nodes.Element;
import org.schabi.newpipe.extractor.exceptions.ParsingException;
import org.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.schabi.newpipe.extractor.stream.StreamInfoItemExtractor;
import org.schabi.newpipe.extractor.stream.StreamType;
import org.schabi.newpipe.extractor.utils.Utils;

public class YoutubeStreamInfoItemExtractor
implements StreamInfoItemExtractor {
    private final Element item;

    public YoutubeStreamInfoItemExtractor(Element item) {
        this.item = item;
    }

    @Override
    public StreamType getStreamType() throws ParsingException {
        if (YoutubeStreamInfoItemExtractor.isLiveStream(this.item)) {
            return StreamType.LIVE_STREAM;
        }
        return StreamType.VIDEO_STREAM;
    }

    @Override
    public boolean isAd() throws ParsingException {
        return !this.item.select("span[class*=\"icon-not-available\"]").isEmpty() || !this.item.select("span[class*=\"yt-badge-ad\"]").isEmpty();
    }

    @Override
    public String getUrl() throws ParsingException {
        try {
            Element el = this.item.select("div[class*=\"yt-lockup-video\"").first();
            Element dl = el.select("h3").first().select("a").first();
            return dl.attr("abs:href");
        }
        catch (Exception e) {
            throw new ParsingException("Could not get web page url for the video", e);
        }
    }

    @Override
    public String getName() throws ParsingException {
        try {
            Element el = this.item.select("div[class*=\"yt-lockup-video\"").first();
            Element dl = el.select("h3").first().select("a").first();
            return dl.text();
        }
        catch (Exception e) {
            throw new ParsingException("Could not get title", e);
        }
    }

    @Override
    public long getDuration() throws ParsingException {
        try {
            if (this.getStreamType() == StreamType.LIVE_STREAM) {
                return -1L;
            }
            Element duration = this.item.select("span[class*=\"video-time\"]").first();
            return duration == null ? 0L : YoutubeParsingHelper.parseDurationString(duration.text());
        }
        catch (Exception e) {
            throw new ParsingException("Could not get Duration: " + this.getUrl(), e);
        }
    }

    @Override
    public String getUploaderName() throws ParsingException {
        try {
            return this.item.select("div[class=\"yt-lockup-byline\"]").first().select("a").first().text();
        }
        catch (Exception e) {
            throw new ParsingException("Could not get uploader", e);
        }
    }

    @Override
    public String getUploadDate() throws ParsingException {
        try {
            Element meta = this.item.select("div[class=\"yt-lockup-meta\"]").first();
            if (meta == null) {
                return "";
            }
            return meta.select("li").first().text();
        }
        catch (Exception e) {
            throw new ParsingException("Could not get upload date", e);
        }
    }

    @Override
    public long getViewCount() throws ParsingException {
        String input;
        try {
            if (this.getStreamType() == StreamType.LIVE_STREAM) {
                return -1L;
            }
            Element meta = this.item.select("div[class=\"yt-lockup-meta\"]").first();
            if (meta == null) {
                return -1L;
            }
            input = ((Element)meta.select("li").get(1)).text();
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParsingException("Could not parse yt-lockup-meta although available: " + this.getUrl(), e);
        }
        try {
            return Long.parseLong(Utils.removeNonDigitCharacters(input));
        }
        catch (NumberFormatException e) {
            if (!input.isEmpty()) {
                return 0L;
            }
            throw new ParsingException("Could not handle input: " + input, e);
        }
    }

    @Override
    public String getThumbnailUrl() throws ParsingException {
        try {
            Element te = this.item.select("div[class=\"yt-thumb video-thumb\"]").first().select("img").first();
            String url = te.attr("abs:src");
            if (url.contains(".gif")) {
                url = te.attr("abs:data-thumb");
            }
            return url;
        }
        catch (Exception e) {
            throw new ParsingException("Could not get thumbnail url", e);
        }
    }

    protected static boolean isLiveStream(Element item) {
        return !item.select("span[class*=\"yt-badge-live\"]").isEmpty() || !item.select("span[class*=\"video-time-overlay-live\"]").isEmpty();
    }
}

