/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.services.youtube;

import com.grack.nanojson.JsonObject;
import com.grack.nanojson.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.schabi.newpipe.extractor.Downloader;
import org.schabi.newpipe.extractor.NewPipe;
import org.schabi.newpipe.extractor.StreamingService;
import org.schabi.newpipe.extractor.exceptions.ContentNotAvailableException;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.exceptions.ParsingException;
import org.schabi.newpipe.extractor.exceptions.ReCaptchaException;
import org.schabi.newpipe.extractor.services.youtube.ItagItem;
import org.schabi.newpipe.extractor.services.youtube.YoutubeStreamInfoItemExtractor;
import org.schabi.newpipe.extractor.stream.AudioStream;
import org.schabi.newpipe.extractor.stream.Stream;
import org.schabi.newpipe.extractor.stream.StreamExtractor;
import org.schabi.newpipe.extractor.stream.StreamInfoItem;
import org.schabi.newpipe.extractor.stream.StreamInfoItemCollector;
import org.schabi.newpipe.extractor.stream.StreamInfoItemExtractor;
import org.schabi.newpipe.extractor.stream.StreamType;
import org.schabi.newpipe.extractor.stream.VideoStream;
import org.schabi.newpipe.extractor.utils.Parser;
import org.schabi.newpipe.extractor.utils.Utils;

public class YoutubeStreamExtractor
extends StreamExtractor {
    private static final String TAG = YoutubeStreamExtractor.class.getSimpleName();
    private Document doc;
    private JsonObject playerArgs;
    private Map<String, String> videoInfoPage;
    private boolean isAgeRestricted;
    private static final String URL_ENCODED_FMT_STREAM_MAP = "url_encoded_fmt_stream_map";
    private static final String ADAPTIVE_FMTS = "adaptive_fmts";
    private static final String HTTPS = "https:";
    private static final String CONTENT = "content";
    private static final String DECRYPTION_FUNC_NAME = "decrypt";
    private static final String GET_VIDEO_INFO_URL = "https://www.youtube.com/get_video_info?video_id=%s&el=info&ps=default&eurl=&gl=US&hl=en";
    private static volatile String decryptionCode = "";

    public YoutubeStreamExtractor(StreamingService service, String url) throws IOException, ExtractionException {
        super(service, url);
    }

    @Override
    public String getId() throws ParsingException {
        try {
            return this.getUrlIdHandler().getId(this.getCleanUrl());
        }
        catch (Exception e) {
            throw new ParsingException("Could not get stream id");
        }
    }

    @Override
    public String getName() throws ParsingException {
        try {
            return this.playerArgs.getString("title");
        }
        catch (Exception exception) {
            try {
                return this.videoInfoPage.get("title");
            }
            catch (Exception exception2) {
                try {
                    return this.doc.select("meta[name=title]").attr(CONTENT);
                }
                catch (Exception e) {
                    throw new ParsingException("Could not get the title", e);
                }
            }
        }
    }

    @Override
    public String getUploadDate() throws ParsingException {
        try {
            return this.doc.select("meta[itemprop=datePublished]").attr(CONTENT);
        }
        catch (Exception e) {
            throw new ParsingException("Could not get upload date", e);
        }
    }

    @Override
    public String getThumbnailUrl() throws ParsingException {
        try {
            return this.doc.select("link[itemprop=\"thumbnailUrl\"]").first().attr("abs:href");
        }
        catch (Exception exception) {
            try {
                if (this.playerArgs.isString("thumbnail_url")) {
                    return this.playerArgs.getString("thumbnail_url");
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                return this.videoInfoPage.get("thumbnail_url");
            }
            catch (Exception e) {
                throw new ParsingException("Could not get thumbnail url", e);
            }
        }
    }

    @Override
    public String getDescription() throws ParsingException {
        try {
            return this.doc.select("p[id=\"eow-description\"]").first().html();
        }
        catch (Exception e) {
            throw new ParsingException("Could not get the description", e);
        }
    }

    @Override
    public int getAgeLimit() throws ParsingException {
        if (!this.isAgeRestricted) {
            return 0;
        }
        try {
            return Integer.valueOf(this.doc.select("meta[property=\"og:restrictions:age\"]").attr(CONTENT).replace("+", ""));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get age restriction");
        }
    }

    @Override
    public long getLength() throws ParsingException {
        try {
            long returnValue = Long.parseLong(this.playerArgs.get((Object)"length_seconds") + "");
            if (returnValue >= 0L) {
                return returnValue;
            }
        }
        catch (Exception returnValue) {
            // empty catch block
        }
        try {
            return Long.parseLong(this.videoInfoPage.get("length_seconds"));
        }
        catch (Exception returnValue) {
            try {
                return Long.parseLong(this.doc.select("div[class~=\"ytp-progress-bar\"][role=\"slider\"]").first().attr("aria-valuemax"));
            }
            catch (Exception e) {
                throw new ParsingException("Could not get video length", e);
            }
        }
    }

    @Override
    public long getTimeStamp() throws ParsingException {
        String timeStamp;
        try {
            timeStamp = org.schabi.newpipe.extractor.utils.Parser.matchGroup1("((#|&|\\?)t=\\d{0,3}h?\\d{0,3}m?\\d{1,3}s?)", this.getOriginalUrl());
        }
        catch (Parser.RegexException e) {
            return -2L;
        }
        if (!timeStamp.isEmpty()) {
            try {
                String hoursString;
                String minutesString;
                String secondsString;
                block7: {
                    secondsString = "";
                    minutesString = "";
                    hoursString = "";
                    try {
                        secondsString = org.schabi.newpipe.extractor.utils.Parser.matchGroup1("(\\d{1,3})s", timeStamp);
                        minutesString = org.schabi.newpipe.extractor.utils.Parser.matchGroup1("(\\d{1,3})m", timeStamp);
                        hoursString = org.schabi.newpipe.extractor.utils.Parser.matchGroup1("(\\d{1,3})h", timeStamp);
                    }
                    catch (Exception e) {
                        if (!secondsString.isEmpty() || !minutesString.isEmpty() || !hoursString.isEmpty()) break block7;
                        secondsString = org.schabi.newpipe.extractor.utils.Parser.matchGroup1("t=(\\d+)", timeStamp);
                    }
                }
                int seconds = secondsString.isEmpty() ? 0 : Integer.parseInt(secondsString);
                int minutes = minutesString.isEmpty() ? 0 : Integer.parseInt(minutesString);
                int hours = hoursString.isEmpty() ? 0 : Integer.parseInt(hoursString);
                return seconds + 60 * minutes + 3600 * hours;
            }
            catch (ParsingException e) {
                throw new ParsingException("Could not get timestamp.", e);
            }
        }
        return 0L;
    }

    @Override
    public long getViewCount() throws ParsingException {
        try {
            return Long.parseLong(this.doc.select("meta[itemprop=interactionCount]").attr(CONTENT));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get number of views", e);
        }
    }

    @Override
    public long getLikeCount() throws ParsingException {
        String likesString = "";
        try {
            Element button = this.doc.select("button.like-button-renderer-like-button").first();
            try {
                likesString = button.select("span.yt-uix-button-content").first().text();
            }
            catch (NullPointerException e) {
                return -1L;
            }
            return Integer.parseInt(Utils.removeNonDigitCharacters(likesString));
        }
        catch (NumberFormatException nfe) {
            throw new ParsingException("Could not parse \"" + likesString + "\" as an Integer", nfe);
        }
        catch (Exception e) {
            throw new ParsingException("Could not get like count", e);
        }
    }

    @Override
    public long getDislikeCount() throws ParsingException {
        String dislikesString = "";
        try {
            Element button = this.doc.select("button.like-button-renderer-dislike-button").first();
            try {
                dislikesString = button.select("span.yt-uix-button-content").first().text();
            }
            catch (NullPointerException e) {
                return -1L;
            }
            return Integer.parseInt(Utils.removeNonDigitCharacters(dislikesString));
        }
        catch (NumberFormatException nfe) {
            throw new ParsingException("Could not parse \"" + dislikesString + "\" as an Integer", nfe);
        }
        catch (Exception e) {
            throw new ParsingException("Could not get dislike count", e);
        }
    }

    @Override
    public String getUploaderUrl() throws ParsingException {
        try {
            return this.doc.select("div[class=\"yt-user-info\"]").first().children().select("a").first().attr("abs:href");
        }
        catch (Exception e) {
            throw new ParsingException("Could not get channel link", e);
        }
    }

    @Override
    public String getUploaderName() throws ParsingException {
        try {
            return this.playerArgs.getString("author");
        }
        catch (Exception exception) {
            try {
                return this.videoInfoPage.get("author");
            }
            catch (Exception exception2) {
                try {
                    return this.doc.select("div.yt-user-info").first().text();
                }
                catch (Exception e) {
                    throw new ParsingException("Could not get uploader name", e);
                }
            }
        }
    }

    @Override
    public String getUploaderAvatarUrl() throws ParsingException {
        try {
            return this.doc.select("a[class*=\"yt-user-photo\"]").first().select("img").first().attr("abs:data-thumb");
        }
        catch (Exception e) {
            throw new ParsingException("Could not get uploader thumbnail URL.", e);
        }
    }

    @Override
    public String getDashMpdUrl() throws ParsingException {
        try {
            String dashManifestUrl;
            if (this.videoInfoPage != null && this.videoInfoPage.containsKey("dashmpd")) {
                dashManifestUrl = this.videoInfoPage.get("dashmpd");
            } else if (this.playerArgs.isString("dashmpd")) {
                dashManifestUrl = this.playerArgs.getString("dashmpd", "");
            } else {
                return "";
            }
            if (!dashManifestUrl.contains("/signature/")) {
                String encryptedSig = org.schabi.newpipe.extractor.utils.Parser.matchGroup1("/s/([a-fA-F0-9\\.]+)", dashManifestUrl);
                String decryptedSig = this.decryptSignature(encryptedSig, decryptionCode);
                dashManifestUrl = dashManifestUrl.replace("/s/" + encryptedSig, "/signature/" + decryptedSig);
            }
            return dashManifestUrl;
        }
        catch (Exception e) {
            throw new ParsingException("Could not get dash manifest url", e);
        }
    }

    @Override
    public List<AudioStream> getAudioStreams() throws IOException, ExtractionException {
        ArrayList<AudioStream> audioStreams = new ArrayList<AudioStream>();
        try {
            for (Map.Entry<String, ItagItem> entry : this.getItags(ADAPTIVE_FMTS, ItagItem.ItagType.AUDIO).entrySet()) {
                ItagItem itag = entry.getValue();
                AudioStream audioStream = new AudioStream(entry.getKey(), itag.mediaFormatId, itag.avgBitrate);
                if (Stream.containSimilarStream(audioStream, audioStreams)) continue;
                audioStreams.add(audioStream);
            }
        }
        catch (Exception e) {
            throw new ParsingException("Could not get audio streams", e);
        }
        return audioStreams;
    }

    @Override
    public List<VideoStream> getVideoStreams() throws IOException, ExtractionException {
        ArrayList<VideoStream> videoStreams = new ArrayList<VideoStream>();
        try {
            for (Map.Entry<String, ItagItem> entry : this.getItags(URL_ENCODED_FMT_STREAM_MAP, ItagItem.ItagType.VIDEO).entrySet()) {
                ItagItem itag = entry.getValue();
                VideoStream videoStream = new VideoStream(entry.getKey(), itag.mediaFormatId, itag.resolutionString);
                if (Stream.containSimilarStream(videoStream, videoStreams)) continue;
                videoStreams.add(videoStream);
            }
        }
        catch (Exception e) {
            throw new ParsingException("Could not get video streams", e);
        }
        return videoStreams;
    }

    @Override
    public List<VideoStream> getVideoOnlyStreams() throws IOException, ExtractionException {
        ArrayList<VideoStream> videoOnlyStreams = new ArrayList<VideoStream>();
        try {
            for (Map.Entry<String, ItagItem> entry : this.getItags(ADAPTIVE_FMTS, ItagItem.ItagType.VIDEO_ONLY).entrySet()) {
                ItagItem itag = entry.getValue();
                VideoStream videoStream = new VideoStream(entry.getKey(), itag.mediaFormatId, itag.resolutionString, true);
                if (Stream.containSimilarStream(videoStream, videoOnlyStreams)) continue;
                videoOnlyStreams.add(videoStream);
            }
        }
        catch (Exception e) {
            throw new ParsingException("Could not get video only streams", e);
        }
        return videoOnlyStreams;
    }

    @Override
    public StreamType getStreamType() throws ParsingException {
        return StreamType.VIDEO_STREAM;
    }

    @Override
    public StreamInfoItem getNextVideo() throws IOException, ExtractionException {
        try {
            StreamInfoItemCollector collector = new StreamInfoItemCollector(this.getServiceId());
            collector.commit(this.extractVideoPreviewInfo(this.doc.select("div[class=\"watch-sidebar-section\"]").first().select("li").first()));
            return (StreamInfoItem)collector.getItemList().get(0);
        }
        catch (Exception e) {
            throw new ParsingException("Could not get next video", e);
        }
    }

    @Override
    public StreamInfoItemCollector getRelatedVideos() throws IOException, ExtractionException {
        try {
            StreamInfoItemCollector collector = new StreamInfoItemCollector(this.getServiceId());
            Element ul = this.doc.select("ul[id=\"watch-related\"]").first();
            if (ul != null) {
                for (Element li : ul.children()) {
                    if (li.select("a[class*=\"content-link\"]").first() == null) continue;
                    collector.commit(this.extractVideoPreviewInfo(li));
                }
            }
            return collector;
        }
        catch (Exception e) {
            throw new ParsingException("Could not get related videos", e);
        }
    }

    @Override
    public String getErrorMessage() {
        StringBuilder errorReason;
        String errorMessage = this.doc.select("h1[id=\"unavailable-message\"]").first().text();
        if (errorMessage == null || errorMessage.isEmpty()) {
            errorReason = null;
        } else if (errorMessage.contains("GEMA")) {
            errorReason = new StringBuilder("GEMA");
        } else {
            errorReason = new StringBuilder(errorMessage);
            errorReason.append("  ");
            errorReason.append(this.doc.select("[id=\"unavailable-submessage\"]").first().text());
        }
        return errorReason != null ? errorReason.toString() : null;
    }

    @Override
    public void fetchPage() throws IOException, ExtractionException {
        String playerUrl;
        Downloader dl = NewPipe.getDownloader();
        String pageContent = dl.download(this.getCleanUrl());
        this.doc = Jsoup.parse((String)pageContent, (String)this.getCleanUrl());
        if (pageContent.contains("<meta property=\"og:restrictions:age")) {
            String infoPageResponse = dl.download(String.format(GET_VIDEO_INFO_URL, this.getId()));
            this.videoInfoPage = org.schabi.newpipe.extractor.utils.Parser.compatParseMap(infoPageResponse);
            playerUrl = this.getPlayerUrlFromRestrictedVideo();
            this.isAgeRestricted = true;
        } else {
            JsonObject ytPlayerConfig = this.getPlayerConfig(pageContent);
            this.playerArgs = this.getPlayerArgs(ytPlayerConfig);
            playerUrl = this.getPlayerUrl(ytPlayerConfig);
            this.isAgeRestricted = false;
        }
        if (decryptionCode.isEmpty()) {
            decryptionCode = this.loadDecryptionCode(playerUrl);
        }
    }

    private JsonObject getPlayerConfig(String pageContent) throws ParsingException {
        try {
            String ytPlayerConfigRaw = org.schabi.newpipe.extractor.utils.Parser.matchGroup1("ytplayer.config\\s*=\\s*(\\{.*?\\});", pageContent);
            return (JsonObject)JsonParser.object().from(ytPlayerConfigRaw);
        }
        catch (Parser.RegexException e) {
            String errorReason;
            switch (errorReason = this.getErrorMessage()) {
                case "GEMA": {
                    throw new GemaException(errorReason);
                }
                case "": {
                    throw new ContentNotAvailableException("Content not available: player config empty", e);
                }
            }
            throw new ContentNotAvailableException("Content not available", e);
        }
        catch (Exception e) {
            throw new ParsingException("Could not parse yt player config", e);
        }
    }

    private JsonObject getPlayerArgs(JsonObject playerConfig) throws ParsingException {
        JsonObject playerArgs;
        boolean isLiveStream = false;
        try {
            playerArgs = playerConfig.getObject("args");
            if (playerArgs.has("ps") && playerArgs.get((Object)"ps").toString().equals("live") || playerArgs.get((Object)URL_ENCODED_FMT_STREAM_MAP).toString().isEmpty()) {
                isLiveStream = true;
            }
        }
        catch (Exception e) {
            throw new ParsingException("Could not parse yt player config", e);
        }
        if (isLiveStream) {
            throw new LiveStreamException("This is a Live stream. Can't use those right now.");
        }
        return playerArgs;
    }

    private String getPlayerUrl(JsonObject playerConfig) throws ParsingException {
        try {
            JsonObject ytAssets = playerConfig.getObject("assets");
            String playerUrl = ytAssets.getString("js");
            if (playerUrl.startsWith("//")) {
                playerUrl = HTTPS + playerUrl;
            }
            return playerUrl;
        }
        catch (Exception e) {
            throw new ParsingException("Could not load decryption code for the Youtube service.", e);
        }
    }

    private String getPlayerUrlFromRestrictedVideo() throws ParsingException, ReCaptchaException {
        try {
            Downloader downloader = NewPipe.getDownloader();
            String playerUrl = "";
            String embedUrl = "https://www.youtube.com/embed/" + this.getId();
            String embedPageContent = downloader.download(embedUrl);
            Pattern assetsPattern = Pattern.compile("\"assets\":.+?\"js\":\\s*(\"[^\"]+\")");
            Matcher patternMatcher = assetsPattern.matcher(embedPageContent);
            while (patternMatcher.find()) {
                playerUrl = patternMatcher.group(1);
            }
            if ((playerUrl = playerUrl.replace("\\", "").replace("\"", "")).startsWith("//")) {
                playerUrl = HTTPS + playerUrl;
            }
            return playerUrl;
        }
        catch (IOException e) {
            throw new ParsingException("Could load decryption code form restricted video for the Youtube service.", e);
        }
        catch (ReCaptchaException e) {
            throw new ReCaptchaException("reCaptcha Challenge requested");
        }
    }

    private String loadDecryptionCode(String playerUrl) throws DecryptException {
        String decryptionCode;
        String callerFunc = "function decrypt(a){return %%(a);}";
        try {
            Downloader downloader = NewPipe.getDownloader();
            if (!playerUrl.contains("https://youtube.com")) {
                playerUrl = "https://youtube.com" + playerUrl;
            }
            String playerCode = downloader.download(playerUrl);
            String decryptionFuncName = org.schabi.newpipe.extractor.utils.Parser.matchGroup("([\"\\'])signature\\1\\s*,\\s*([a-zA-Z0-9$]+)\\(", playerCode, 2);
            String functionPattern = "(" + decryptionFuncName.replace("$", "\\$") + "=function\\([a-zA-Z0-9_]+\\)\\{.+?\\})";
            String decryptionFunc = "var " + org.schabi.newpipe.extractor.utils.Parser.matchGroup1(functionPattern, playerCode) + ";";
            String helperObjectName = org.schabi.newpipe.extractor.utils.Parser.matchGroup1(";([A-Za-z0-9_\\$]{2})\\...\\(", decryptionFunc);
            String helperPattern = "(var " + helperObjectName.replace("$", "\\$") + "=\\{.+?\\}\\};)";
            String helperObject = org.schabi.newpipe.extractor.utils.Parser.matchGroup1(helperPattern, playerCode);
            callerFunc = callerFunc.replace("%%", decryptionFuncName);
            decryptionCode = helperObject + decryptionFunc + callerFunc;
        }
        catch (IOException ioe) {
            throw new DecryptException("Could not load decrypt function", ioe);
        }
        catch (Exception e) {
            throw new DecryptException("Could not parse decrypt function ", e);
        }
        return decryptionCode;
    }

    private String decryptSignature(String encryptedSig, String decryptionCode) throws DecryptException {
        Context context = Context.enter();
        context.setOptimizationLevel(-1);
        Object result = null;
        try {
            ScriptableObject scope = context.initStandardObjects();
            context.evaluateString((Scriptable)scope, decryptionCode, "decryptionCode", 1, null);
            Function decryptionFunc = (Function)scope.get(DECRYPTION_FUNC_NAME, (Scriptable)scope);
            result = decryptionFunc.call(context, (Scriptable)scope, (Scriptable)scope, new Object[]{encryptedSig});
        }
        catch (Exception e) {
            throw new DecryptException("could not get decrypt signature", e);
        }
        finally {
            Context.exit();
        }
        return result == null ? "" : result.toString();
    }

    private Map<String, ItagItem> getItags(String encodedUrlMapKey, ItagItem.ItagType itagTypeWanted) throws ParsingException {
        LinkedHashMap<String, ItagItem> urlAndItags = new LinkedHashMap<String, ItagItem>();
        String encodedUrlMap = "";
        if (this.playerArgs != null && this.playerArgs.isString(encodedUrlMapKey)) {
            encodedUrlMap = this.playerArgs.getString(encodedUrlMapKey, "");
        } else if (this.videoInfoPage != null && this.videoInfoPage.containsKey(encodedUrlMapKey)) {
            encodedUrlMap = this.videoInfoPage.get(encodedUrlMapKey);
        }
        for (String url_data_str : encodedUrlMap.split(",")) {
            try {
                Map<String, String> tags = org.schabi.newpipe.extractor.utils.Parser.compatParseMap(Parser.unescapeEntities((String)url_data_str, (boolean)true));
                int itag = Integer.parseInt(tags.get("itag"));
                if (!ItagItem.isSupported(itag)) continue;
                ItagItem itagItem = ItagItem.getItag(itag);
                if (itagItem.itagType != itagTypeWanted) continue;
                String streamUrl = tags.get("url");
                if (tags.get("s") != null) {
                    streamUrl = streamUrl + "&signature=" + this.decryptSignature(tags.get("s"), decryptionCode);
                }
                urlAndItags.put(streamUrl, itagItem);
            }
            catch (DecryptException e) {
                throw e;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return urlAndItags;
    }

    private StreamInfoItemExtractor extractVideoPreviewInfo(final Element li) {
        return new YoutubeStreamInfoItemExtractor(li){

            @Override
            public String getUrl() throws ParsingException {
                return li.select("a.content-link").first().attr("abs:href");
            }

            @Override
            public String getName() throws ParsingException {
                return li.select("span.title").first().text();
            }

            @Override
            public String getUploaderName() throws ParsingException {
                return li.select("span[class*=\"attribution\"").first().select("span").first().text();
            }

            @Override
            public String getUploadDate() throws ParsingException {
                return "";
            }

            @Override
            public long getViewCount() throws ParsingException {
                try {
                    if (this.getStreamType() == StreamType.LIVE_STREAM) {
                        return -1L;
                    }
                    return Long.parseLong(Utils.removeNonDigitCharacters(li.select("span.view-count").first().text()));
                }
                catch (Exception e) {
                    return 0L;
                }
            }

            @Override
            public String getThumbnailUrl() throws ParsingException {
                Element img = li.select("img").first();
                String thumbnailUrl = img.attr("abs:src");
                if (thumbnailUrl.contains(".gif")) {
                    thumbnailUrl = img.attr("data-thumb");
                }
                if (thumbnailUrl.startsWith("//")) {
                    thumbnailUrl = YoutubeStreamExtractor.HTTPS + thumbnailUrl;
                }
                return thumbnailUrl;
            }
        };
    }

    public class LiveStreamException
    extends ContentNotAvailableException {
        LiveStreamException(String message) {
            super(message);
        }
    }

    public class GemaException
    extends ContentNotAvailableException {
        GemaException(String message) {
            super(message);
        }
    }

    public class DecryptException
    extends ParsingException {
        DecryptException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

