/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.services.youtube;

import org.schabi.newpipe.extractor.MediaFormat;
import org.schabi.newpipe.extractor.exceptions.ParsingException;

public class ItagItem {
    private static final ItagItem[] ITAG_LIST = new ItagItem[]{new ItagItem(17, ItagType.VIDEO, MediaFormat.v3GPP, "144p"), new ItagItem(36, ItagType.VIDEO, MediaFormat.v3GPP, "240p"), new ItagItem(18, ItagType.VIDEO, MediaFormat.MPEG_4, "360p"), new ItagItem(34, ItagType.VIDEO, MediaFormat.MPEG_4, "360p"), new ItagItem(35, ItagType.VIDEO, MediaFormat.MPEG_4, "480p"), new ItagItem(59, ItagType.VIDEO, MediaFormat.MPEG_4, "480p"), new ItagItem(78, ItagType.VIDEO, MediaFormat.MPEG_4, "480p"), new ItagItem(22, ItagType.VIDEO, MediaFormat.MPEG_4, "720p"), new ItagItem(37, ItagType.VIDEO, MediaFormat.MPEG_4, "1080p"), new ItagItem(38, ItagType.VIDEO, MediaFormat.MPEG_4, "1080p"), new ItagItem(43, ItagType.VIDEO, MediaFormat.WEBM, "360p"), new ItagItem(44, ItagType.VIDEO, MediaFormat.WEBM, "480p"), new ItagItem(45, ItagType.VIDEO, MediaFormat.WEBM, "720p"), new ItagItem(46, ItagType.VIDEO, MediaFormat.WEBM, "1080p"), new ItagItem(171, ItagType.AUDIO, MediaFormat.WEBMA, 128), new ItagItem(172, ItagType.AUDIO, MediaFormat.WEBMA, 256), new ItagItem(139, ItagType.AUDIO, MediaFormat.M4A, 48), new ItagItem(140, ItagType.AUDIO, MediaFormat.M4A, 128), new ItagItem(141, ItagType.AUDIO, MediaFormat.M4A, 256), new ItagItem(160, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "144p"), new ItagItem(133, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "240p"), new ItagItem(135, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "480p"), new ItagItem(212, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "480p"), new ItagItem(298, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "720p60", 60), new ItagItem(137, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "1080p"), new ItagItem(299, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "1080p60", 60), new ItagItem(266, ItagType.VIDEO_ONLY, MediaFormat.MPEG_4, "2160p"), new ItagItem(278, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "144p"), new ItagItem(242, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "240p"), new ItagItem(244, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "480p"), new ItagItem(245, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "480p"), new ItagItem(246, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "480p"), new ItagItem(247, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "720p"), new ItagItem(248, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "1080p"), new ItagItem(271, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "1440p"), new ItagItem(272, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "2160p"), new ItagItem(302, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "720p60", 60), new ItagItem(303, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "1080p60", 60), new ItagItem(308, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "1440p60", 60), new ItagItem(313, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "2160p"), new ItagItem(315, ItagType.VIDEO_ONLY, MediaFormat.WEBM, "2160p60", 60)};
    public int id;
    public ItagType itagType;
    public int mediaFormatId;
    public int avgBitrate = -1;
    public String resolutionString;
    public int fps = -1;

    public static boolean isSupported(int itag) {
        for (ItagItem item : ITAG_LIST) {
            if (itag != item.id) continue;
            return true;
        }
        return false;
    }

    public static ItagItem getItag(int itagId) throws ParsingException {
        for (ItagItem item : ITAG_LIST) {
            if (itagId != item.id) continue;
            return item;
        }
        throw new ParsingException("itag=" + Integer.toString(itagId) + " not supported");
    }

    public ItagItem(int id, ItagType type, MediaFormat format, String resolution) {
        this.id = id;
        this.itagType = type;
        this.mediaFormatId = format.id;
        this.resolutionString = resolution;
        this.fps = 30;
    }

    public ItagItem(int id, ItagType type, MediaFormat format, String resolution, int fps) {
        this.id = id;
        this.itagType = type;
        this.mediaFormatId = format.id;
        this.resolutionString = resolution;
        this.fps = fps;
    }

    public ItagItem(int id, ItagType type, MediaFormat format, int avgBitrate) {
        this.id = id;
        this.itagType = type;
        this.mediaFormatId = format.id;
        this.avgBitrate = avgBitrate;
    }

    public static enum ItagType {
        AUDIO,
        VIDEO,
        VIDEO_ONLY;

    }
}

