/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.services.soundcloud;

import com.grack.nanojson.JsonObject;
import com.grack.nanojson.JsonParser;
import com.grack.nanojson.JsonParserException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.schabi.newpipe.extractor.Downloader;
import org.schabi.newpipe.extractor.MediaFormat;
import org.schabi.newpipe.extractor.NewPipe;
import org.schabi.newpipe.extractor.StreamingService;
import org.schabi.newpipe.extractor.exceptions.ContentNotAvailableException;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.exceptions.ParsingException;
import org.schabi.newpipe.extractor.services.soundcloud.SoundcloudParsingHelper;
import org.schabi.newpipe.extractor.stream.AudioStream;
import org.schabi.newpipe.extractor.stream.StreamExtractor;
import org.schabi.newpipe.extractor.stream.StreamInfoItem;
import org.schabi.newpipe.extractor.stream.StreamInfoItemCollector;
import org.schabi.newpipe.extractor.stream.StreamType;
import org.schabi.newpipe.extractor.stream.VideoStream;
import org.schabi.newpipe.extractor.utils.Parser;

public class SoundcloudStreamExtractor
extends StreamExtractor {
    private JsonObject track;

    public SoundcloudStreamExtractor(StreamingService service, String url) throws IOException, ExtractionException {
        super(service, url);
    }

    @Override
    public void fetchPage() throws IOException, ExtractionException {
        this.track = SoundcloudParsingHelper.resolveFor(this.getOriginalUrl());
        String policy = this.track.getString("policy", "");
        if (!policy.equals("ALLOW") && !policy.equals("MONETIZE")) {
            throw new ContentNotAvailableException("Content not available: policy " + policy);
        }
    }

    @Override
    public String getCleanUrl() {
        return this.track.isString("permalink_url") ? this.track.getString("permalink_url") : this.getOriginalUrl();
    }

    @Override
    public String getId() {
        return this.track.getInt("id") + "";
    }

    @Override
    public String getName() {
        return this.track.getString("title");
    }

    @Override
    public String getUploadDate() throws ParsingException {
        return SoundcloudParsingHelper.toDateString(this.track.getString("created_at"));
    }

    @Override
    public String getThumbnailUrl() {
        return this.track.getString("artwork_url", "");
    }

    @Override
    public String getDescription() {
        return this.track.getString("description");
    }

    @Override
    public int getAgeLimit() {
        return 0;
    }

    @Override
    public long getLength() {
        return this.track.getNumber("duration", (Number)0).longValue() / 1000L;
    }

    @Override
    public long getTimeStamp() throws ParsingException {
        String timeStamp;
        try {
            timeStamp = Parser.matchGroup1("(#t=\\d{0,3}h?\\d{0,3}m?\\d{1,3}s?)", this.getOriginalUrl());
        }
        catch (Parser.RegexException e) {
            return -2L;
        }
        if (!timeStamp.isEmpty()) {
            try {
                String hoursString;
                String minutesString;
                String secondsString;
                block7: {
                    secondsString = "";
                    minutesString = "";
                    hoursString = "";
                    try {
                        secondsString = Parser.matchGroup1("(\\d{1,3})s", timeStamp);
                        minutesString = Parser.matchGroup1("(\\d{1,3})m", timeStamp);
                        hoursString = Parser.matchGroup1("(\\d{1,3})h", timeStamp);
                    }
                    catch (Exception e) {
                        if (!secondsString.isEmpty() || !minutesString.isEmpty() || !hoursString.isEmpty()) break block7;
                        secondsString = Parser.matchGroup1("t=(\\d+)", timeStamp);
                    }
                }
                int seconds = secondsString.isEmpty() ? 0 : Integer.parseInt(secondsString);
                int minutes = minutesString.isEmpty() ? 0 : Integer.parseInt(minutesString);
                int hours = hoursString.isEmpty() ? 0 : Integer.parseInt(hoursString);
                return seconds + 60 * minutes + 3600 * hours;
            }
            catch (ParsingException e) {
                throw new ParsingException("Could not get timestamp.", e);
            }
        }
        return 0L;
    }

    @Override
    public long getViewCount() {
        return this.track.getNumber("playback_count", (Number)0).longValue();
    }

    @Override
    public long getLikeCount() {
        return this.track.getNumber("favoritings_count", (Number)-1).longValue();
    }

    @Override
    public long getDislikeCount() {
        return -1L;
    }

    @Override
    public String getUploaderUrl() {
        return this.track.getObject("user").getString("permalink_url", "");
    }

    @Override
    public String getUploaderName() {
        return this.track.getObject("user").getString("username", "");
    }

    @Override
    public String getUploaderAvatarUrl() {
        return this.track.getObject("user", new JsonObject()).getString("avatar_url", "");
    }

    @Override
    public String getDashMpdUrl() {
        return null;
    }

    @Override
    public List<AudioStream> getAudioStreams() throws IOException, ExtractionException {
        JsonObject responseObject;
        ArrayList<AudioStream> audioStreams = new ArrayList<AudioStream>();
        Downloader dl = NewPipe.getDownloader();
        String apiUrl = "https://api.soundcloud.com/i1/tracks/" + this.getId() + "/streams?client_id=" + SoundcloudParsingHelper.clientId();
        String response = dl.download(apiUrl);
        try {
            responseObject = (JsonObject)JsonParser.object().from(response);
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json response", e);
        }
        String mp3Url = responseObject.getString("http_mp3_128_url");
        if (mp3Url == null || mp3Url.isEmpty()) {
            throw new ExtractionException("Could not get SoundCloud's track audio url");
        }
        audioStreams.add(new AudioStream(mp3Url, MediaFormat.MP3.id, 128));
        return audioStreams;
    }

    @Override
    public List<VideoStream> getVideoStreams() throws IOException, ExtractionException {
        return null;
    }

    @Override
    public List<VideoStream> getVideoOnlyStreams() throws IOException, ExtractionException {
        return null;
    }

    @Override
    public StreamType getStreamType() {
        return StreamType.AUDIO_STREAM;
    }

    @Override
    public StreamInfoItem getNextVideo() throws IOException, ExtractionException {
        return null;
    }

    @Override
    public StreamInfoItemCollector getRelatedVideos() throws IOException, ExtractionException {
        StreamInfoItemCollector collector = new StreamInfoItemCollector(this.getServiceId());
        String apiUrl = "https://api-v2.soundcloud.com/tracks/" + this.getId() + "/related?client_id=" + SoundcloudParsingHelper.clientId();
        SoundcloudParsingHelper.getStreamsFromApi(collector, apiUrl);
        return collector;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }
}

