/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.schabi.newpipe.extractor.InfoItem;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.search.SearchEngine;

public class SearchResult {
    public String suggestion;
    public List<InfoItem> resultList = new ArrayList<InfoItem>();
    public List<Throwable> errors = new ArrayList<Throwable>();

    public static SearchResult getSearchResult(SearchEngine engine, String query, int page, String languageCode, SearchEngine.Filter filter) throws IOException, ExtractionException {
        SearchResult result = engine.search(query, page, languageCode, filter).getSearchResult();
        if (result.resultList.isEmpty()) {
            if (result.suggestion.isEmpty()) {
                if (result.errors.isEmpty()) {
                    throw new ExtractionException("Empty result despite no error");
                }
            } else {
                throw new SearchEngine.NothingFoundException(result.suggestion);
            }
        }
        return result;
    }
}

