/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.kiosk;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.schabi.newpipe.extractor.NewPipe;
import org.schabi.newpipe.extractor.StreamingService;
import org.schabi.newpipe.extractor.UrlIdHandler;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.kiosk.KioskExtractor;

public class KioskList {
    private int service_id;
    private HashMap<String, KioskEntry> kioskList = new HashMap();
    private String defaultKiosk = null;

    public KioskList(int service_id) {
        this.service_id = service_id;
    }

    public void addKioskEntry(KioskExtractorFactory extractorFactory, UrlIdHandler handler, String id) throws Exception {
        if (this.kioskList.get(id) != null) {
            throw new Exception("Kiosk with type " + id + " already exists.");
        }
        this.kioskList.put(id, new KioskEntry(extractorFactory, handler));
    }

    public void setDefaultKiosk(String kioskType) {
        this.defaultKiosk = kioskType;
    }

    public KioskExtractor getDefaultKioskExtractor(String nextStreamUrl) throws ExtractionException, IOException {
        if (this.defaultKiosk != null && !this.defaultKiosk.equals("")) {
            return this.getExtractorById(this.defaultKiosk, nextStreamUrl);
        }
        if (!this.kioskList.isEmpty()) {
            Object[] keySet = this.kioskList.keySet().toArray();
            return this.getExtractorById(keySet[0].toString(), nextStreamUrl);
        }
        return null;
    }

    public String getDefaultKioskId() {
        return this.defaultKiosk;
    }

    public KioskExtractor getExtractorById(String kioskId, String nextStreamsUrl) throws ExtractionException, IOException {
        KioskEntry ke = this.kioskList.get(kioskId);
        if (ke == null) {
            throw new ExtractionException("No kiosk found with the type: " + kioskId);
        }
        return ke.extractorFactory.createNewKiosk(NewPipe.getService(this.service_id), ke.handler.getUrl(kioskId), nextStreamsUrl, kioskId);
    }

    public Set<String> getAvailableKiosks() {
        return this.kioskList.keySet();
    }

    public KioskExtractor getExtractorByUrl(String url, String nextStreamsUrl) throws ExtractionException, IOException {
        for (Map.Entry<String, KioskEntry> e : this.kioskList.entrySet()) {
            KioskEntry ke = e.getValue();
            if (!ke.handler.acceptUrl(url)) continue;
            return this.getExtractorById(e.getKey(), nextStreamsUrl);
        }
        throw new ExtractionException("Could not find a kiosk that fits to the url: " + url);
    }

    public UrlIdHandler getUrlIdHandlerByType(String type) {
        return this.kioskList.get((Object)type).handler;
    }

    private class KioskEntry {
        KioskExtractorFactory extractorFactory;
        UrlIdHandler handler;

        public KioskEntry(KioskExtractorFactory ef, UrlIdHandler h) {
            this.extractorFactory = ef;
            this.handler = h;
        }
    }

    public static interface KioskExtractorFactory {
        public KioskExtractor createNewKiosk(StreamingService var1, String var2, String var3, String var4) throws ExtractionException, IOException;
    }
}

