/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor.kiosk;

import java.io.IOException;
import org.schabi.newpipe.extractor.ListExtractor;
import org.schabi.newpipe.extractor.ListInfo;
import org.schabi.newpipe.extractor.NewPipe;
import org.schabi.newpipe.extractor.ServiceList;
import org.schabi.newpipe.extractor.StreamingService;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.kiosk.KioskExtractor;
import org.schabi.newpipe.extractor.kiosk.KioskList;
import org.schabi.newpipe.extractor.stream.StreamInfoItemCollector;

public class KioskInfo
extends ListInfo {
    public static ListExtractor.NextItemsResult getMoreItems(ServiceList serviceItem, String url, String nextStreamsUrl) throws IOException, ExtractionException {
        return KioskInfo.getMoreItems(serviceItem.getService(), url, nextStreamsUrl);
    }

    public static ListExtractor.NextItemsResult getMoreItems(StreamingService service, String url, String nextStreamsUrl) throws IOException, ExtractionException {
        KioskList kl = service.getKioskList();
        KioskExtractor extractor = kl.getExtractorByUrl(url, nextStreamsUrl);
        return extractor.getNextStreams();
    }

    public static KioskInfo getInfo(String url, String contentCountry) throws IOException, ExtractionException {
        return KioskInfo.getInfo(NewPipe.getServiceByUrl(url), url, contentCountry);
    }

    public static KioskInfo getInfo(ServiceList serviceItem, String url, String contentContry) throws IOException, ExtractionException {
        return KioskInfo.getInfo(serviceItem.getService(), url, contentContry);
    }

    public static KioskInfo getInfo(StreamingService service, String url, String contentCountry) throws IOException, ExtractionException {
        KioskList kl = service.getKioskList();
        KioskExtractor extractor = kl.getExtractorByUrl(url, null);
        return KioskInfo.getInfo(extractor, contentCountry);
    }

    public static KioskInfo getInfo(KioskExtractor extractor, String contentCountry) throws IOException, ExtractionException {
        KioskInfo info = new KioskInfo();
        extractor.setContentCountry(contentCountry);
        extractor.fetchPage();
        info.name = extractor.getName();
        info.id = extractor.getId();
        info.url = extractor.getCleanUrl();
        try {
            StreamInfoItemCollector c = extractor.getStreams();
            info.related_streams = c.getItemList();
            info.errors.addAll(c.getErrors());
        }
        catch (Exception e) {
            info.errors.add(e);
        }
        return info;
    }
}

