/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor;

import org.schabi.newpipe.extractor.Downloader;
import org.schabi.newpipe.extractor.ServiceList;
import org.schabi.newpipe.extractor.StreamingService;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;

public class NewPipe {
    private static final String TAG = NewPipe.class.toString();
    private static Downloader downloader = null;

    private NewPipe() {
    }

    public static void init(Downloader d) {
        downloader = d;
    }

    public static Downloader getDownloader() {
        return downloader;
    }

    public static StreamingService[] getServices() {
        ServiceList[] values = ServiceList.values();
        StreamingService[] streamingServices = new StreamingService[values.length];
        for (int i = 0; i < values.length; ++i) {
            streamingServices[i] = values[i].getService();
        }
        return streamingServices;
    }

    public static StreamingService getService(int serviceId) throws ExtractionException {
        for (ServiceList item : ServiceList.values()) {
            if (item.getService().getServiceId() != serviceId) continue;
            return item.getService();
        }
        throw new ExtractionException("There's no service with the id = \"" + serviceId + "\"");
    }

    public static StreamingService getService(String serviceName) throws ExtractionException {
        for (ServiceList item : ServiceList.values()) {
            if (!item.getService().getServiceInfo().name.equals(serviceName)) continue;
            return item.getService();
        }
        throw new ExtractionException("There's no service with the name = \"" + serviceName + "\"");
    }

    public static StreamingService getServiceByUrl(String url) throws ExtractionException {
        for (ServiceList item : ServiceList.values()) {
            if (item.getService().getLinkTypeByUrl(url) == StreamingService.LinkType.NONE) continue;
            return item.getService();
        }
        throw new ExtractionException("No service can handle the url = \"" + url + "\"");
    }

    public static int getIdOfService(String serviceName) {
        try {
            return NewPipe.getService(serviceName).getServiceId();
        }
        catch (ExtractionException ignored) {
            return -1;
        }
    }

    public static String getNameOfService(int id) {
        try {
            return NewPipe.getService((int)id).getServiceInfo().name;
        }
        catch (Exception e) {
            System.err.println("Service id not known");
            e.printStackTrace();
            return "<unknown>";
        }
    }
}

