/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor;

import java.io.IOException;
import java.util.List;
import org.schabi.newpipe.extractor.Extractor;
import org.schabi.newpipe.extractor.InfoItem;
import org.schabi.newpipe.extractor.InfoItemCollector;
import org.schabi.newpipe.extractor.StreamingService;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.stream.StreamInfoItemCollector;

public abstract class ListExtractor
extends Extractor {
    protected String nextStreamsUrl;

    public ListExtractor(StreamingService service, String url, String nextStreamsUrl) throws IOException, ExtractionException {
        super(service, url);
        this.setNextStreamsUrl(nextStreamsUrl);
        if (this.fetchPageUponCreation()) {
            this.fetchPage();
        }
    }

    protected boolean fetchPageUponCreation() {
        return this.nextStreamsUrl == null || this.nextStreamsUrl.isEmpty();
    }

    public abstract StreamInfoItemCollector getStreams() throws IOException, ExtractionException;

    public abstract NextItemsResult getNextStreams() throws IOException, ExtractionException;

    public boolean hasMoreStreams() {
        return this.nextStreamsUrl != null && !this.nextStreamsUrl.isEmpty();
    }

    public String getNextStreamsUrl() {
        return this.nextStreamsUrl;
    }

    public void setNextStreamsUrl(String nextStreamsUrl) {
        this.nextStreamsUrl = nextStreamsUrl;
    }

    public static class NextItemsResult {
        public final List<InfoItem> nextItemsList;
        public final String nextItemsUrl;
        public final List<Throwable> errors;

        public NextItemsResult(InfoItemCollector collector, String nextItemsUrl) {
            this(collector.getItemList(), nextItemsUrl, collector.getErrors());
        }

        public NextItemsResult(List<InfoItem> nextItemsList, String nextItemsUrl, List<Throwable> errors) {
            this.nextItemsList = nextItemsList;
            this.nextItemsUrl = nextItemsUrl;
            this.errors = errors;
        }

        public boolean hasMoreStreams() {
            return this.nextItemsUrl != null && !this.nextItemsUrl.isEmpty();
        }
    }
}

