/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor;

import java.util.ArrayList;
import java.util.List;
import org.schabi.newpipe.extractor.InfoItem;
import org.schabi.newpipe.extractor.NewPipe;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;

public abstract class InfoItemCollector {
    private List<InfoItem> itemList = new ArrayList<InfoItem>();
    private List<Throwable> errors = new ArrayList<Throwable>();
    private int serviceId = -1;

    public InfoItemCollector(int serviceId) {
        this.serviceId = serviceId;
    }

    public List<InfoItem> getItemList() {
        return this.itemList;
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    protected void addFromCollector(InfoItemCollector otherC) throws ExtractionException {
        if (this.serviceId != otherC.serviceId) {
            throw new ExtractionException("Service Id does not equal: " + NewPipe.getNameOfService(this.serviceId) + " and " + NewPipe.getNameOfService(otherC.serviceId));
        }
        this.errors.addAll(otherC.errors);
        this.itemList.addAll(otherC.itemList);
    }

    protected void addError(Exception e) {
        this.errors.add(e);
    }

    protected void addItem(InfoItem item) {
        this.itemList.add(item);
    }

    protected int getServiceId() {
        return this.serviceId;
    }
}

