/*
 * Decompiled with CFR 0.152.
 */
package org.schabi.newpipe.extractor;

import java.io.IOException;
import org.schabi.newpipe.extractor.StreamingService;
import org.schabi.newpipe.extractor.UrlIdHandler;
import org.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.schabi.newpipe.extractor.exceptions.ParsingException;

public abstract class Extractor {
    private final StreamingService service;
    private final String originalUrl;
    private String cleanUrl;

    public Extractor(StreamingService service, String url) throws ExtractionException {
        this.service = service;
        this.originalUrl = url;
    }

    protected abstract UrlIdHandler getUrlIdHandler() throws ParsingException;

    public abstract void fetchPage() throws IOException, ExtractionException;

    public abstract String getId() throws ParsingException;

    public abstract String getName() throws ParsingException;

    public String getOriginalUrl() {
        return this.originalUrl;
    }

    public String getCleanUrl() {
        if (this.cleanUrl != null && !this.cleanUrl.isEmpty()) {
            return this.cleanUrl;
        }
        try {
            this.cleanUrl = this.getUrlIdHandler().cleanUrl(this.originalUrl);
        }
        catch (Exception e) {
            this.cleanUrl = null;
            return this.originalUrl;
        }
        return this.cleanUrl;
    }

    public StreamingService getService() {
        return this.service;
    }

    public int getServiceId() {
        return this.service.getServiceId();
    }
}

