/*
 * Decompiled with CFR 0.152.
 */
package tv.danmaku.ijk.media.player;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaDataSource;
import android.media.MediaPlayer;
import android.media.TimedText;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.Surface;
import android.view.SurfaceHolder;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Map;
import tv.danmaku.ijk.media.player.AbstractMediaPlayer;
import tv.danmaku.ijk.media.player.IjkTimedText;
import tv.danmaku.ijk.media.player.MediaInfo;
import tv.danmaku.ijk.media.player.misc.AndroidTrackInfo;
import tv.danmaku.ijk.media.player.misc.IMediaDataSource;
import tv.danmaku.ijk.media.player.misc.ITrackInfo;
import tv.danmaku.ijk.media.player.pragma.DebugLog;

public class AndroidMediaPlayer
extends AbstractMediaPlayer {
    private final MediaPlayer mInternalMediaPlayer;
    private final AndroidMediaPlayerListenerHolder mInternalListenerAdapter;
    private String mDataSource;
    private MediaDataSource mMediaDataSource;
    private final Object mInitLock;
    private boolean mIsReleased;
    private static MediaInfo sMediaInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AndroidMediaPlayer() {
        Object object = this.mInitLock = new Object();
        synchronized (object) {
            this.mInternalMediaPlayer = new MediaPlayer();
        }
        this.mInternalMediaPlayer.setAudioStreamType(3);
        this.mInternalListenerAdapter = new AndroidMediaPlayerListenerHolder(this);
        this.attachInternalListeners();
    }

    public MediaPlayer getInternalMediaPlayer() {
        return this.mInternalMediaPlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisplay(SurfaceHolder sh) {
        Object object = this.mInitLock;
        synchronized (object) {
            if (!this.mIsReleased) {
                this.mInternalMediaPlayer.setDisplay(sh);
            }
        }
    }

    @Override
    @TargetApi(value=14)
    public void setSurface(Surface surface) {
        this.mInternalMediaPlayer.setSurface(surface);
    }

    @Override
    public void setDataSource(Context context, Uri uri) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.mInternalMediaPlayer.setDataSource(context, uri);
    }

    @Override
    @TargetApi(value=14)
    public void setDataSource(Context context, Uri uri, Map<String, String> headers) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.mInternalMediaPlayer.setDataSource(context, uri, headers);
    }

    @Override
    public void setDataSource(FileDescriptor fd) throws IOException, IllegalArgumentException, IllegalStateException {
        this.mInternalMediaPlayer.setDataSource(fd);
    }

    @Override
    public void setDataSource(String path) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.mDataSource = path;
        Uri uri = Uri.parse((String)path);
        String scheme = uri.getScheme();
        if (!TextUtils.isEmpty((CharSequence)scheme) && scheme.equalsIgnoreCase("file")) {
            this.mInternalMediaPlayer.setDataSource(uri.getPath());
        } else {
            this.mInternalMediaPlayer.setDataSource(path);
        }
    }

    @Override
    @TargetApi(value=23)
    public void setDataSource(IMediaDataSource mediaDataSource) {
        this.releaseMediaDataSource();
        this.mMediaDataSource = new MediaDataSourceProxy(mediaDataSource);
        this.mInternalMediaPlayer.setDataSource(this.mMediaDataSource);
    }

    @Override
    public String getDataSource() {
        return this.mDataSource;
    }

    private void releaseMediaDataSource() {
        if (this.mMediaDataSource != null) {
            try {
                this.mMediaDataSource.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.mMediaDataSource = null;
        }
    }

    @Override
    public void prepareAsync() throws IllegalStateException {
        this.mInternalMediaPlayer.prepareAsync();
    }

    @Override
    public void start() throws IllegalStateException {
        this.mInternalMediaPlayer.start();
    }

    @Override
    public void stop() throws IllegalStateException {
        this.mInternalMediaPlayer.stop();
    }

    @Override
    public void pause() throws IllegalStateException {
        this.mInternalMediaPlayer.pause();
    }

    @Override
    public void setScreenOnWhilePlaying(boolean screenOn) {
        this.mInternalMediaPlayer.setScreenOnWhilePlaying(screenOn);
    }

    @Override
    public ITrackInfo[] getTrackInfo() {
        return AndroidTrackInfo.fromMediaPlayer(this.mInternalMediaPlayer);
    }

    @Override
    public int getVideoWidth() {
        return this.mInternalMediaPlayer.getVideoWidth();
    }

    @Override
    public int getVideoHeight() {
        return this.mInternalMediaPlayer.getVideoHeight();
    }

    @Override
    public int getVideoSarNum() {
        return 1;
    }

    @Override
    public int getVideoSarDen() {
        return 1;
    }

    @Override
    public boolean isPlaying() {
        try {
            return this.mInternalMediaPlayer.isPlaying();
        }
        catch (IllegalStateException e) {
            DebugLog.printStackTrace(e);
            return false;
        }
    }

    @Override
    public void seekTo(long msec) throws IllegalStateException {
        this.mInternalMediaPlayer.seekTo((int)msec);
    }

    @Override
    public long getCurrentPosition() {
        try {
            return this.mInternalMediaPlayer.getCurrentPosition();
        }
        catch (IllegalStateException e) {
            DebugLog.printStackTrace(e);
            return 0L;
        }
    }

    @Override
    public long getDuration() {
        try {
            return this.mInternalMediaPlayer.getDuration();
        }
        catch (IllegalStateException e) {
            DebugLog.printStackTrace(e);
            return 0L;
        }
    }

    @Override
    public void release() {
        this.mIsReleased = true;
        this.mInternalMediaPlayer.release();
        this.releaseMediaDataSource();
        this.resetListeners();
        this.attachInternalListeners();
    }

    @Override
    public void reset() {
        try {
            this.mInternalMediaPlayer.reset();
        }
        catch (IllegalStateException e) {
            DebugLog.printStackTrace(e);
        }
        this.releaseMediaDataSource();
        this.resetListeners();
        this.attachInternalListeners();
    }

    @Override
    public void setLooping(boolean looping) {
        this.mInternalMediaPlayer.setLooping(looping);
    }

    @Override
    public boolean isLooping() {
        return this.mInternalMediaPlayer.isLooping();
    }

    @Override
    public void setVolume(float leftVolume, float rightVolume) {
        this.mInternalMediaPlayer.setVolume(leftVolume, rightVolume);
    }

    @Override
    public int getAudioSessionId() {
        return this.mInternalMediaPlayer.getAudioSessionId();
    }

    @Override
    public MediaInfo getMediaInfo() {
        if (sMediaInfo == null) {
            MediaInfo module = new MediaInfo();
            module.mVideoDecoder = "android";
            module.mVideoDecoderImpl = "HW";
            module.mAudioDecoder = "android";
            module.mAudioDecoderImpl = "HW";
            sMediaInfo = module;
        }
        return sMediaInfo;
    }

    @Override
    public void setLogEnabled(boolean enable) {
    }

    @Override
    public boolean isPlayable() {
        return true;
    }

    @Override
    public void setWakeMode(Context context, int mode) {
        this.mInternalMediaPlayer.setWakeMode(context, mode);
    }

    @Override
    public void setAudioStreamType(int streamtype) {
        this.mInternalMediaPlayer.setAudioStreamType(streamtype);
    }

    @Override
    public void setKeepInBackground(boolean keepInBackground) {
    }

    private void attachInternalListeners() {
        this.mInternalMediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this.mInternalListenerAdapter);
        this.mInternalMediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this.mInternalListenerAdapter);
        this.mInternalMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this.mInternalListenerAdapter);
        this.mInternalMediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)this.mInternalListenerAdapter);
        this.mInternalMediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this.mInternalListenerAdapter);
        this.mInternalMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this.mInternalListenerAdapter);
        this.mInternalMediaPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)this.mInternalListenerAdapter);
        this.mInternalMediaPlayer.setOnTimedTextListener((MediaPlayer.OnTimedTextListener)this.mInternalListenerAdapter);
    }

    private class AndroidMediaPlayerListenerHolder
    implements MediaPlayer.OnPreparedListener,
    MediaPlayer.OnCompletionListener,
    MediaPlayer.OnBufferingUpdateListener,
    MediaPlayer.OnSeekCompleteListener,
    MediaPlayer.OnVideoSizeChangedListener,
    MediaPlayer.OnErrorListener,
    MediaPlayer.OnInfoListener,
    MediaPlayer.OnTimedTextListener {
        public final WeakReference<AndroidMediaPlayer> mWeakMediaPlayer;
        private Handler handler = new Handler(Looper.getMainLooper());

        public AndroidMediaPlayerListenerHolder(AndroidMediaPlayer mp) {
            this.mWeakMediaPlayer = new WeakReference<AndroidMediaPlayer>(mp);
        }

        public boolean onInfo(MediaPlayer mp, final int what, final int extra) {
            return this.handler.post(new Runnable(){

                @Override
                public void run() {
                    AndroidMediaPlayer self = (AndroidMediaPlayer)AndroidMediaPlayerListenerHolder.this.mWeakMediaPlayer.get();
                    if (self != null) {
                        AndroidMediaPlayer.this.notifyOnInfo(what, extra);
                    }
                }
            });
        }

        public boolean onError(MediaPlayer mp, final int what, final int extra) {
            return this.handler.post(new Runnable(){

                @Override
                public void run() {
                    AndroidMediaPlayer self = (AndroidMediaPlayer)AndroidMediaPlayerListenerHolder.this.mWeakMediaPlayer.get();
                    if (self != null) {
                        AndroidMediaPlayer.this.notifyOnError(what, extra);
                    }
                }
            });
        }

        public void onVideoSizeChanged(MediaPlayer mp, final int width, final int height) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    AndroidMediaPlayer self = (AndroidMediaPlayer)AndroidMediaPlayerListenerHolder.this.mWeakMediaPlayer.get();
                    if (self == null) {
                        return;
                    }
                    AndroidMediaPlayer.this.notifyOnVideoSizeChanged(width, height, 1, 1);
                }
            });
        }

        public void onSeekComplete(MediaPlayer mp) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    AndroidMediaPlayer self = (AndroidMediaPlayer)AndroidMediaPlayerListenerHolder.this.mWeakMediaPlayer.get();
                    if (self == null) {
                        return;
                    }
                    AndroidMediaPlayer.this.notifyOnSeekComplete();
                }
            });
        }

        public void onBufferingUpdate(MediaPlayer mp, final int percent) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    AndroidMediaPlayer self = (AndroidMediaPlayer)AndroidMediaPlayerListenerHolder.this.mWeakMediaPlayer.get();
                    if (self == null) {
                        return;
                    }
                    AndroidMediaPlayer.this.notifyOnBufferingUpdate(percent);
                }
            });
        }

        public void onCompletion(MediaPlayer mp) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    AndroidMediaPlayer self = (AndroidMediaPlayer)AndroidMediaPlayerListenerHolder.this.mWeakMediaPlayer.get();
                    if (self == null) {
                        return;
                    }
                    AndroidMediaPlayer.this.notifyOnCompletion();
                }
            });
        }

        public void onPrepared(MediaPlayer mp) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    AndroidMediaPlayer self = (AndroidMediaPlayer)AndroidMediaPlayerListenerHolder.this.mWeakMediaPlayer.get();
                    if (self == null) {
                        return;
                    }
                    AndroidMediaPlayer.this.notifyOnPrepared();
                }
            });
        }

        public void onTimedText(MediaPlayer mp, final TimedText text) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    AndroidMediaPlayer self = (AndroidMediaPlayer)AndroidMediaPlayerListenerHolder.this.mWeakMediaPlayer.get();
                    if (self == null) {
                        return;
                    }
                    IjkTimedText ijkText = null;
                    if (text != null) {
                        ijkText = new IjkTimedText(text.getBounds(), text.getText());
                    }
                    AndroidMediaPlayer.this.notifyOnTimedText(ijkText);
                }
            });
        }
    }

    @TargetApi(value=23)
    private static class MediaDataSourceProxy
    extends MediaDataSource {
        private final IMediaDataSource mMediaDataSource;

        public MediaDataSourceProxy(IMediaDataSource mediaDataSource) {
            this.mMediaDataSource = mediaDataSource;
        }

        public int readAt(long position, byte[] buffer, int offset, int size) throws IOException {
            return this.mMediaDataSource.readAt(position, buffer, offset, size);
        }

        public long getSize() throws IOException {
            return this.mMediaDataSource.getSize();
        }

        public void close() throws IOException {
            this.mMediaDataSource.close();
        }
    }
}

