/*
 * Decompiled with CFR 0.152.
 */
package com.tbruyelle.rxpermissions;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.tbruyelle.rxpermissions.Permission;
import com.tbruyelle.rxpermissions.ShadowActivity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;
import rx.subjects.PublishSubject;

public class RxPermissions {
    public static final String TAG = "RxPermissions";
    static RxPermissions sSingleton;
    private Context mCtx;
    private List<String> mNoResultRequests = new ArrayList<String>();
    private Map<String, PublishSubject<Permission>> mSubjects = new HashMap<String, PublishSubject<Permission>>();
    private boolean mLogging;

    public static RxPermissions getInstance(Context ctx) {
        if (sSingleton == null) {
            sSingleton = new RxPermissions(ctx.getApplicationContext());
        }
        return sSingleton;
    }

    RxPermissions(Context ctx) {
        this.mCtx = ctx;
    }

    public void setLogging(boolean logging) {
        this.mLogging = logging;
    }

    private void log(String message) {
        if (this.mLogging) {
            Log.d((String)TAG, (String)message);
        }
    }

    public Observable.Transformer<Object, Boolean> ensure(final String ... permissions) {
        return new Observable.Transformer<Object, Boolean>(){

            public Observable<Boolean> call(Observable<Object> o) {
                return RxPermissions.this.request(o, permissions).buffer(permissions.length).flatMap((Func1)new Func1<List<Permission>, Observable<Boolean>>(){

                    public Observable<Boolean> call(List<Permission> permissions) {
                        if (permissions.isEmpty()) {
                            return Observable.empty();
                        }
                        for (Permission p : permissions) {
                            if (p.granted) continue;
                            return Observable.just((Object)false);
                        }
                        return Observable.just((Object)true);
                    }
                });
            }
        };
    }

    public Observable.Transformer<Object, Permission> ensureEach(final String ... permissions) {
        return new Observable.Transformer<Object, Permission>(){

            public Observable<Permission> call(Observable<Object> o) {
                return RxPermissions.this.request(o, permissions);
            }
        };
    }

    public Observable<Boolean> request(String ... permissions) {
        return Observable.just(null).compose(this.ensure(permissions));
    }

    public Observable<Permission> requestEach(String ... permissions) {
        return Observable.just(null).compose(this.ensureEach(permissions));
    }

    private Observable<Permission> request(Observable<?> trigger, final String ... permissions) {
        if (permissions == null || permissions.length == 0) {
            throw new IllegalArgumentException("RxPermissions.request/requestEach requires at least one input permission");
        }
        if (this.pending(permissions)) {
            return this.request_(permissions);
        }
        return trigger.flatMap((Func1)new Func1<Object, Observable<Permission>>(){

            public Observable<Permission> call(Object o) {
                return RxPermissions.this.request_(permissions);
            }
        });
    }

    private boolean pending(String ... permissions) {
        for (String p : permissions) {
            if (this.mNoResultRequests.contains(p)) continue;
            return false;
        }
        return true;
    }

    @TargetApi(value=23)
    private Observable<Permission> request_(String ... permissions) {
        ArrayList<Object> list = new ArrayList<Object>(permissions.length);
        ArrayList<String> unrequestedPermissions = new ArrayList<String>();
        for (String permission : permissions) {
            this.log("Requesting permission " + permission);
            if (this.isGranted(permission)) {
                list.add(Observable.just((Object)new Permission(permission, true)));
                continue;
            }
            if (this.isRevoked(permission)) {
                list.add(Observable.just((Object)new Permission(permission, false)));
                continue;
            }
            PublishSubject subject = this.mSubjects.get(permission);
            if (subject == null && !this.mNoResultRequests.contains(permission)) {
                unrequestedPermissions.add(permission);
            }
            if (subject == null) {
                subject = PublishSubject.create();
                this.mSubjects.put(permission, (PublishSubject<Permission>)subject);
            }
            list.add(subject);
        }
        if (!unrequestedPermissions.isEmpty()) {
            this.startShadowActivity(unrequestedPermissions.toArray(new String[unrequestedPermissions.size()]));
        }
        return Observable.concat((Observable)Observable.from(list));
    }

    public Observable<Boolean> shouldShowRequestPermissionRationale(Activity activity, String ... permissions) {
        if (!this.isMarshmallow()) {
            return Observable.just((Object)false);
        }
        return Observable.just((Object)this.shouldShowRequestPermissionRationale_(activity, permissions));
    }

    @TargetApi(value=23)
    private boolean shouldShowRequestPermissionRationale_(Activity activity, String ... permissions) {
        for (String p : permissions) {
            if (this.isGranted(p) || activity.shouldShowRequestPermissionRationale(p)) continue;
            return false;
        }
        return true;
    }

    void startShadowActivity(String[] permissions) {
        this.log("startShadowActivity " + TextUtils.join((CharSequence)", ", (Object[])permissions));
        Intent intent = new Intent(this.mCtx, ShadowActivity.class);
        intent.putExtra("permissions", permissions);
        intent.addFlags(0x10000000);
        this.mCtx.startActivity(intent);
    }

    public boolean isGranted(String permission) {
        return !this.isMarshmallow() || this.isGranted_(permission);
    }

    public boolean isRevoked(String permission) {
        return this.isMarshmallow() && this.isRevoked_(permission);
    }

    boolean isMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }

    @TargetApi(value=23)
    private boolean isGranted_(String permission) {
        return this.mCtx.checkSelfPermission(permission) == 0;
    }

    @TargetApi(value=23)
    private boolean isRevoked_(String permission) {
        return this.mCtx.getPackageManager().isPermissionRevokedByPolicy(permission, this.mCtx.getPackageName());
    }

    void onDestroy() {
        this.log("onDestroy");
        for (String permission : this.mSubjects.keySet()) {
            this.mNoResultRequests.add(permission);
        }
        this.mSubjects.clear();
    }

    void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        int size = permissions.length;
        for (int i = 0; i < size; ++i) {
            this.log("onRequestPermissionsResult  " + permissions[i]);
            PublishSubject<Permission> subject = this.mSubjects.get(permissions[i]);
            if (subject == null) {
                throw new IllegalStateException("RxPermissions.onRequestPermissionsResult invoked but didn't find the corresponding permission request.");
            }
            this.mSubjects.remove(permissions[i]);
            this.mNoResultRequests.remove(permissions[i]);
            boolean granted = grantResults[i] == 0;
            subject.onNext((Object)new Permission(permissions[i], granted));
            subject.onCompleted();
        }
    }
}

