/*
 * Decompiled with CFR 0.152.
 */
package com.tbruyelle.rxpermissions;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.tbruyelle.rxpermissions.Permission;
import com.tbruyelle.rxpermissions.ShadowActivity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;
import rx.subjects.PublishSubject;
import rx.subjects.Subject;

public class RxPermissions {
    public static final String TAG = "RxPermissions";
    private static RxPermissions sSingleton;
    private Context mCtx;
    private Map<String, PublishSubject<Permission>> mSubjects = new HashMap<String, PublishSubject<Permission>>();
    private boolean mLogging;

    public static RxPermissions getInstance(Context ctx) {
        if (sSingleton == null) {
            sSingleton = new RxPermissions(ctx.getApplicationContext());
        }
        return sSingleton;
    }

    RxPermissions(Context ctx) {
        this.mCtx = ctx;
    }

    public void setLogging(boolean logging) {
        this.mLogging = logging;
    }

    private void log(String message) {
        if (this.mLogging) {
            Log.d((String)TAG, (String)message);
        }
    }

    public Observable<Permission> requestEach(String ... permissions) {
        return this.requestEach((Observable<?>)null, permissions);
    }

    public Observable<Permission> requestEach(Observable<?> trigger, final String ... permissions) {
        if (permissions == null || permissions.length == 0) {
            throw new IllegalArgumentException("RxPermissions.request/requestEach requires at least one input permission");
        }
        return this.oneOf(trigger, this.pending(permissions)).flatMap((Func1)new Func1<Object, Observable<Permission>>(){

            public Observable<Permission> call(Object o) {
                return RxPermissions.this.request_(permissions);
            }
        });
    }

    public Observable<Boolean> request(String ... permissions) {
        return this.request((Observable<?>)null, permissions);
    }

    public Observable<Boolean> request(Observable<?> trigger, String ... permissions) {
        return this.requestEach(trigger, permissions).buffer(permissions.length).flatMap((Func1)new Func1<List<Permission>, Observable<Boolean>>(){

            public Observable<Boolean> call(List<Permission> permissions) {
                if (permissions.isEmpty()) {
                    return Observable.empty();
                }
                for (Permission p : permissions) {
                    if (p.granted) continue;
                    return Observable.just((Object)false);
                }
                return Observable.just((Object)true);
            }
        });
    }

    private Observable<?> pending(String ... permissions) {
        for (String p : permissions) {
            Subject s = (Subject)this.mSubjects.get(p);
            if (s != null && s.hasCompleted()) continue;
            return Observable.empty();
        }
        return Observable.just(null);
    }

    private Observable<Object> oneOf(Observable<?> trigger, Observable<?> pending) {
        if (trigger == null) {
            return Observable.just(null);
        }
        return Observable.merge(trigger, pending);
    }

    @TargetApi(value=23)
    private Observable<Permission> request_(String ... permissions) {
        if (this.mLogging) {
            this.log("Requesting permissions " + TextUtils.join((CharSequence)", ", (Object[])permissions));
        }
        if (this.isGranted(permissions)) {
            if (this.mLogging) {
                this.log("GRANTED " + TextUtils.join((CharSequence)", ", (Object[])permissions));
            }
            return Observable.from((Object[])permissions).map((Func1)new Func1<String, Permission>(){

                public Permission call(String s) {
                    return new Permission(s, true);
                }
            });
        }
        ArrayList<PublishSubject> list = new ArrayList<PublishSubject>(permissions.length);
        ArrayList<String> unrequestedPermissions = new ArrayList<String>();
        for (String permission : permissions) {
            PublishSubject subject = this.mSubjects.get(permission);
            if (subject == null || subject.hasCompleted()) {
                if (subject == null) {
                    unrequestedPermissions.add(permission);
                }
                subject = PublishSubject.create();
                this.mSubjects.put(permission, (PublishSubject<Permission>)subject);
            }
            list.add(subject);
        }
        if (!unrequestedPermissions.isEmpty()) {
            this.startShadowActivity(unrequestedPermissions.toArray(new String[0]));
        }
        return Observable.concat((Observable)Observable.from(list));
    }

    public Observable<Boolean> shouldShowRequestPermissionRationale(Activity activity, String ... permissions) {
        if (this.isMarshmallow()) {
            return Observable.just((Object)this.shouldShowRequestPermissionRationale_(activity, permissions));
        }
        return Observable.just((Object)false);
    }

    @TargetApi(value=23)
    private boolean shouldShowRequestPermissionRationale_(Activity activity, String ... permissions) {
        for (String p : permissions) {
            if (activity.shouldShowRequestPermissionRationale(p)) continue;
            return false;
        }
        return true;
    }

    void startShadowActivity(String[] permissions) {
        this.log("startShadowActivity " + TextUtils.join((CharSequence)", ", (Object[])permissions));
        Intent intent = new Intent(this.mCtx, ShadowActivity.class);
        intent.putExtra("permissions", permissions);
        intent.addFlags(0x10000000);
        this.mCtx.startActivity(intent);
    }

    public boolean isGranted(String ... permissions) {
        return !this.isMarshmallow() || this.hasPermission_(permissions);
    }

    boolean isMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }

    @TargetApi(value=23)
    private boolean hasPermission_(String ... permissions) {
        for (String permission : permissions) {
            if (this.mCtx.checkSelfPermission(permission) == 0) continue;
            return false;
        }
        return true;
    }

    void onDestroy() {
        this.log("onDestroy");
        for (Subject subject : this.mSubjects.values()) {
            subject.onCompleted();
        }
    }

    void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        int size = permissions.length;
        for (int i = 0; i < size; ++i) {
            this.log("onRequestPermissionsResult  " + permissions[i]);
            PublishSubject<Permission> subject = this.mSubjects.get(permissions[i]);
            if (subject == null) {
                throw new IllegalStateException("RxPermissions.onRequestPermissionsResult invoked but didn't find the corresponding permission request.");
            }
            this.mSubjects.remove(permissions[i]);
            boolean granted = grantResults[i] == 0;
            subject.onNext((Object)new Permission(permissions[i], granted));
            subject.onCompleted();
        }
    }
}

