/*
 * Decompiled with CFR 0.152.
 */
package com.tbruyelle.rxpermissions;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.tbruyelle.rxpermissions.ShadowActivity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.FuncN;
import rx.subjects.PublishSubject;

public class RxPermissions {
    private static RxPermissions sSingleton;
    private Context mCtx;
    private Map<String, PublishSubject<Boolean>> mSubjects = new HashMap<String, PublishSubject<Boolean>>();

    public static RxPermissions getInstance(Context ctx) {
        if (sSingleton == null) {
            sSingleton = new RxPermissions();
            RxPermissions.sSingleton.mCtx = ctx.getApplicationContext();
        }
        return sSingleton;
    }

    private RxPermissions() {
    }

    public Observable<Boolean> request(String ... permissions) {
        if (permissions == null || permissions.length == 0) {
            throw new IllegalArgumentException("RxPermission.request requires at least one input permission");
        }
        if (this.isGranted(permissions)) {
            return Observable.just((Object)true);
        }
        return this.request_(permissions);
    }

    @TargetApi(value=23)
    private Observable<Boolean> request_(String ... permissions) {
        ArrayList<PublishSubject> list = new ArrayList<PublishSubject>(permissions.length);
        ArrayList<String> unrequestedPermissions = new ArrayList<String>();
        for (String permission : permissions) {
            PublishSubject subject = this.mSubjects.get(permission);
            if (subject == null) {
                subject = PublishSubject.create();
                this.mSubjects.put(permission, (PublishSubject<Boolean>)subject);
                unrequestedPermissions.add(permission);
            }
            list.add(subject);
        }
        if (!unrequestedPermissions.isEmpty()) {
            this.startShadowActivity(permissions);
        }
        return Observable.combineLatest(list, (FuncN)combineLatestBools.INSTANCE).doOnSubscribe(new Action0(){

            public void call() {
            }
        });
    }

    void startShadowActivity(String[] permissions) {
        Intent intent = new Intent(this.mCtx, ShadowActivity.class);
        intent.putExtra("permissions", permissions);
        intent.addFlags(0x10000000);
        this.mCtx.startActivity(intent);
    }

    public boolean isGranted(String ... permissions) {
        return Build.VERSION.SDK_INT < 23 || this.hasPermission_(permissions);
    }

    @TargetApi(value=23)
    private boolean hasPermission_(String ... permissions) {
        for (String permission : permissions) {
            if (this.mCtx.checkSelfPermission(permission) == 0) continue;
            return false;
        }
        return true;
    }

    void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        for (int i = 0; i < permissions.length; ++i) {
            PublishSubject<Boolean> subject = this.mSubjects.get(permissions[i]);
            if (subject == null) {
                throw new IllegalStateException("RxPermission.onRequestPermissionsResult invoked but didn't find the corresponding permission request.");
            }
            this.mSubjects.remove(permissions[i]);
            subject.onNext((Object)(grantResults[i] == 0 ? 1 : 0));
            subject.onCompleted();
        }
    }

    private static enum combineLatestBools implements FuncN<Boolean>
    {
        INSTANCE;


        public Boolean call(Object ... args) {
            for (Object arg : args) {
                if (((Boolean)arg).booleanValue()) continue;
                return false;
            }
            return true;
        }
    }
}

