/*
 * Decompiled with CFR 0.152.
 */
package com.tbruyelle.rxpermissions2;

import android.annotation.TargetApi;
import android.app.Activity;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import com.tbruyelle.rxpermissions2.Permission;
import com.tbruyelle.rxpermissions2.RxPermissionsFragment;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.functions.Function;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.List;

public class RxPermissions {
    static final String TAG = RxPermissions.class.getSimpleName();
    static final Object TRIGGER = new Object();
    private final Lazy<RxPermissionsFragment> mRxPermissionsFragment;

    public RxPermissions(@NonNull FragmentActivity activity) {
        this.mRxPermissionsFragment = this.getLazySingleton(activity);
    }

    @NonNull
    private Lazy<RxPermissionsFragment> getLazySingleton(final @NonNull FragmentActivity activity) {
        return new Lazy<RxPermissionsFragment>(){
            private RxPermissionsFragment rxPermissionsFragment;

            @Override
            public synchronized RxPermissionsFragment get() {
                if (this.rxPermissionsFragment == null) {
                    this.rxPermissionsFragment = RxPermissions.this.getRxPermissionsFragment(activity);
                }
                return this.rxPermissionsFragment;
            }
        };
    }

    private RxPermissionsFragment getRxPermissionsFragment(@NonNull FragmentActivity activity) {
        boolean isNewInstance;
        RxPermissionsFragment rxPermissionsFragment = this.findRxPermissionsFragment(activity);
        boolean bl = isNewInstance = rxPermissionsFragment == null;
        if (isNewInstance) {
            rxPermissionsFragment = new RxPermissionsFragment();
            FragmentManager fragmentManager = activity.getSupportFragmentManager();
            fragmentManager.beginTransaction().add((Fragment)rxPermissionsFragment, TAG).commitNow();
        }
        return rxPermissionsFragment;
    }

    private RxPermissionsFragment findRxPermissionsFragment(@NonNull FragmentActivity activity) {
        return (RxPermissionsFragment)activity.getSupportFragmentManager().findFragmentByTag(TAG);
    }

    public void setLogging(boolean logging) {
        this.mRxPermissionsFragment.get().setLogging(logging);
    }

    public <T> ObservableTransformer<T, Boolean> ensure(final String ... permissions) {
        return new ObservableTransformer<T, Boolean>(){

            public ObservableSource<Boolean> apply(Observable<T> o) {
                return RxPermissions.this.request(o, permissions).buffer(permissions.length).flatMap((Function)new Function<List<Permission>, ObservableSource<Boolean>>(){

                    public ObservableSource<Boolean> apply(List<Permission> permissions) {
                        if (permissions.isEmpty()) {
                            return Observable.empty();
                        }
                        for (Permission p : permissions) {
                            if (p.granted) continue;
                            return Observable.just((Object)false);
                        }
                        return Observable.just((Object)true);
                    }
                });
            }
        };
    }

    public <T> ObservableTransformer<T, Permission> ensureEach(final String ... permissions) {
        return new ObservableTransformer<T, Permission>(){

            public ObservableSource<Permission> apply(Observable<T> o) {
                return RxPermissions.this.request(o, permissions);
            }
        };
    }

    public <T> ObservableTransformer<T, Permission> ensureEachCombined(final String ... permissions) {
        return new ObservableTransformer<T, Permission>(){

            public ObservableSource<Permission> apply(Observable<T> o) {
                return RxPermissions.this.request(o, permissions).buffer(permissions.length).flatMap((Function)new Function<List<Permission>, ObservableSource<Permission>>(){

                    public ObservableSource<Permission> apply(List<Permission> permissions) {
                        if (permissions.isEmpty()) {
                            return Observable.empty();
                        }
                        return Observable.just((Object)new Permission(permissions));
                    }
                });
            }
        };
    }

    public Observable<Boolean> request(String ... permissions) {
        return Observable.just((Object)TRIGGER).compose(this.ensure(permissions));
    }

    public Observable<Permission> requestEach(String ... permissions) {
        return Observable.just((Object)TRIGGER).compose(this.ensureEach(permissions));
    }

    public Observable<Permission> requestEachCombined(String ... permissions) {
        return Observable.just((Object)TRIGGER).compose(this.ensureEachCombined(permissions));
    }

    private Observable<Permission> request(Observable<?> trigger, final String ... permissions) {
        if (permissions == null || permissions.length == 0) {
            throw new IllegalArgumentException("RxPermissions.request/requestEach requires at least one input permission");
        }
        return this.oneOf(trigger, this.pending(permissions)).flatMap((Function)new Function<Object, Observable<Permission>>(){

            public Observable<Permission> apply(Object o) {
                return RxPermissions.this.requestImplementation(permissions);
            }
        });
    }

    private Observable<?> pending(String ... permissions) {
        for (String p : permissions) {
            if (this.mRxPermissionsFragment.get().containsByPermission(p)) continue;
            return Observable.empty();
        }
        return Observable.just((Object)TRIGGER);
    }

    private Observable<?> oneOf(Observable<?> trigger, Observable<?> pending) {
        if (trigger == null) {
            return Observable.just((Object)TRIGGER);
        }
        return Observable.merge(trigger, pending);
    }

    @TargetApi(value=23)
    private Observable<Permission> requestImplementation(String ... permissions) {
        ArrayList<Object> list = new ArrayList<Object>(permissions.length);
        ArrayList<String> unrequestedPermissions = new ArrayList<String>();
        for (String permission : permissions) {
            this.mRxPermissionsFragment.get().log("Requesting permission " + permission);
            if (this.isGranted(permission)) {
                list.add(Observable.just((Object)new Permission(permission, true, false)));
                continue;
            }
            if (this.isRevoked(permission)) {
                list.add(Observable.just((Object)new Permission(permission, false, false)));
                continue;
            }
            PublishSubject subject = this.mRxPermissionsFragment.get().getSubjectByPermission(permission);
            if (subject == null) {
                unrequestedPermissions.add(permission);
                subject = PublishSubject.create();
                this.mRxPermissionsFragment.get().setSubjectForPermission(permission, (PublishSubject<Permission>)subject);
            }
            list.add(subject);
        }
        if (!unrequestedPermissions.isEmpty()) {
            String[] unrequestedPermissionsArray = unrequestedPermissions.toArray(new String[unrequestedPermissions.size()]);
            this.requestPermissionsFromFragment(unrequestedPermissionsArray);
        }
        return Observable.concat((ObservableSource)Observable.fromIterable(list));
    }

    public Observable<Boolean> shouldShowRequestPermissionRationale(Activity activity, String ... permissions) {
        if (!this.isMarshmallow()) {
            return Observable.just((Object)false);
        }
        return Observable.just((Object)this.shouldShowRequestPermissionRationaleImplementation(activity, permissions));
    }

    @TargetApi(value=23)
    private boolean shouldShowRequestPermissionRationaleImplementation(Activity activity, String ... permissions) {
        for (String p : permissions) {
            if (this.isGranted(p) || activity.shouldShowRequestPermissionRationale(p)) continue;
            return false;
        }
        return true;
    }

    @TargetApi(value=23)
    void requestPermissionsFromFragment(String[] permissions) {
        this.mRxPermissionsFragment.get().log("requestPermissionsFromFragment " + TextUtils.join((CharSequence)", ", (Object[])permissions));
        this.mRxPermissionsFragment.get().requestPermissions(permissions);
    }

    public boolean isGranted(String permission) {
        return !this.isMarshmallow() || this.mRxPermissionsFragment.get().isGranted(permission);
    }

    public boolean isRevoked(String permission) {
        return this.isMarshmallow() && this.mRxPermissionsFragment.get().isRevoked(permission);
    }

    boolean isMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }

    void onRequestPermissionsResult(String[] permissions, int[] grantResults) {
        this.mRxPermissionsFragment.get().onRequestPermissionsResult(permissions, grantResults, new boolean[permissions.length]);
    }

    @FunctionalInterface
    public static interface Lazy<V> {
        public V get();
    }
}

