/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.riot.api.request.ratelimit;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.rithms.riot.api.ApiMethod;
import net.rithms.riot.api.request.Request;
import net.rithms.riot.api.request.RequestResponse;
import net.rithms.riot.api.request.ratelimit.RateLimitHandler;
import net.rithms.riot.api.request.ratelimit.RespectedRateLimitException;
import net.rithms.riot.constant.Platform;

public class DefaultRateLimitHandler
implements RateLimitHandler {
    protected final RateLimitList rateLimitList = new RateLimitList();

    protected boolean isRateLimitExceeded(Request request) {
        ApiMethod object = request.getObject();
        return this.rateLimitList.isLimitExceeded(object.getPlatform(), object.getService(), object.getClass().getName());
    }

    @Override
    public void onRequestAboutToFire(Request request) throws RespectedRateLimitException {
        if (this.isRateLimitExceeded(request)) {
            ApiMethod object = request.getObject();
            RateLimit rateLimit = this.rateLimitList.getRateLimit(object.getPlatform(), object.getService(), object.getClass().getName());
            if (rateLimit == null) {
                return;
            }
            throw new RespectedRateLimitException(rateLimit.getRetryAfter(), rateLimit.getRateLimitType());
        }
    }

    @Override
    public void onRequestDone(Request request) {
        RequestResponse response = request.getResponse();
        if (response.getCode() == 429) {
            String retryAfterString = response.getHeaderField("Retry-After");
            String rateLimitType = response.getHeaderField("X-Rate-Limit-Type");
            if (retryAfterString != null) {
                int retryAfter = Integer.parseInt(retryAfterString);
                ApiMethod object = request.getObject();
                this.rateLimitList.setRateLimit(object.getPlatform(), object.getService(), object.getClass().getName(), rateLimitType, retryAfter);
            }
        }
    }

    public class RateLimitList {
        private final Map<Platform, RateLimit> applicationLimits = new ConcurrentHashMap<Platform, RateLimit>();
        private final Map<Platform, Map<String, RateLimit>> serviceLimits = new ConcurrentHashMap<Platform, Map<String, RateLimit>>();
        private final Map<Platform, Map<String, RateLimit>> methodLimits = new ConcurrentHashMap<Platform, Map<String, RateLimit>>();

        public RateLimit getRateLimit(Platform platform, String service, String method) {
            if (this.applicationLimits.containsKey((Object)platform) && this.applicationLimits.get((Object)platform).isLimitExceeded()) {
                return this.applicationLimits.get((Object)platform);
            }
            if (this.serviceLimits.containsKey((Object)platform) && this.serviceLimits.get((Object)platform).containsKey(service) && this.serviceLimits.get((Object)platform).get(service).isLimitExceeded()) {
                return this.serviceLimits.get((Object)platform).get(service);
            }
            if (this.methodLimits.containsKey((Object)platform) && this.methodLimits.get((Object)platform).containsKey(method) && this.methodLimits.get((Object)platform).get(method).isLimitExceeded()) {
                return this.methodLimits.get((Object)platform).get(method);
            }
            return null;
        }

        public boolean isLimitExceeded(Platform platform, String service, String method) {
            return this.getRateLimit(platform, service, method) != null;
        }

        public void setRateLimit(Platform platform, String service, String method, String type, int retryAfter) {
            if (type.equals("application")) {
                this.applicationLimits.put(platform, new RateLimit(type, retryAfter));
            } else if (type.equals("service")) {
                if (!this.serviceLimits.containsKey((Object)platform)) {
                    this.serviceLimits.put(platform, new ConcurrentHashMap());
                }
                this.serviceLimits.get((Object)platform).put(service, new RateLimit(type, retryAfter));
            } else if (type.equals("method")) {
                if (!this.methodLimits.containsKey((Object)platform)) {
                    this.methodLimits.put(platform, new ConcurrentHashMap());
                }
                this.methodLimits.get((Object)platform).put(method, new RateLimit(type, retryAfter));
            }
        }
    }

    public class RateLimit {
        private final String rateLimitType;
        private final int retryAfter;
        private final long retryTime;

        public RateLimit(String rateLimitType, int retryAfter) {
            this.rateLimitType = rateLimitType;
            this.retryAfter = retryAfter;
            this.retryTime = System.currentTimeMillis() + (long)(retryAfter * 1000);
        }

        public int getRetryAfter() {
            return this.retryAfter;
        }

        public long getRetryTime() {
            return this.retryTime;
        }

        public String getRateLimitType() {
            return this.rateLimitType;
        }

        public boolean isLimitExceeded() {
            return this.retryTime > System.currentTimeMillis();
        }
    }
}

