/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.riot.api.request;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.logging.Level;
import net.rithms.riot.api.ApiConfig;
import net.rithms.riot.api.ApiMethod;
import net.rithms.riot.api.HttpHeadParameter;
import net.rithms.riot.api.RiotApi;
import net.rithms.riot.api.RiotApiException;
import net.rithms.riot.api.request.RequestMethod;
import net.rithms.riot.api.request.RequestResponse;
import net.rithms.riot.api.request.RiotApiError;
import net.rithms.riot.api.request.ratelimit.RateLimitException;
import net.rithms.riot.api.request.ratelimit.RespectedRateLimitException;

public class Request {
    public static final int CODE_SUCCESS_OK = 200;
    public static final int CODE_SUCCESS_NO_CONTENT = 204;
    public static final int CODE_ERROR_BAD_REQUEST = 400;
    public static final int CODE_ERROR_UNAUTHORIZED = 401;
    public static final int CODE_ERROR_FORBIDDEN = 403;
    public static final int CODE_ERROR_NOT_FOUND = 404;
    public static final int CODE_ERROR_METHOD_NOT_ALLOWED = 405;
    public static final int CODE_ERROR_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int CODE_ERROR_UNPROCESSABLE_ENTITY = 422;
    public static final int CODE_ERROR_RATE_LIMITED = 429;
    public static final int CODE_ERROR_SERVER_ERROR = 500;
    public static final int CODE_ERROR_BAD_GATEWAY = 502;
    public static final int CODE_ERROR_SERVICE_UNAVAILABLE = 503;
    public static final int CODE_ERROR_GATEWAY_TIMEOUT = 504;
    private volatile RequestState state = RequestState.Waiting;
    private RequestResponse response = null;
    protected ApiConfig config;
    protected ApiMethod object;
    protected HttpURLConnection connection = null;
    private volatile RiotApiException exception = null;

    public Request(ApiConfig config, ApiMethod object) throws RateLimitException, RiotApiException {
        this.init(config, object);
        this.execute();
    }

    protected Request() {
    }

    public boolean cancel() {
        if (this.isDone()) {
            return false;
        }
        this.state = RequestState.Cancelled;
        return true;
    }

    protected synchronized void execute() throws RiotApiException, RateLimitException {
        this.setState(RequestState.Waiting);
        try {
            this.object.checkRequirements();
            if (this.config.getRateLimitHandler() != null) {
                this.config.getRateLimitHandler().onRequestAboutToFire(this);
            }
            URL url = new URL(this.object.getUrl());
            this.connection = (HttpURLConnection)url.openConnection();
            this.setTimeout();
            this.connection.setDoInput(true);
            this.connection.setInstanceFollowRedirects(false);
            this.connection.setRequestMethod(this.getHttpMethod().name());
            for (HttpHeadParameter p : this.object.getHttpHeadParameters()) {
                this.connection.setRequestProperty(p.getKey(), p.getValue());
            }
            String body = this.object.getBody();
            if (body != null) {
                this.connection.setRequestProperty("Content-Type", "application/json");
                this.connection.setDoOutput(true);
                DataOutputStream dos = new DataOutputStream(this.connection.getOutputStream());
                dos.writeBytes(body);
                dos.flush();
                dos.close();
            }
            int responseCode = this.connection.getResponseCode();
            InputStream is = null;
            is = responseCode < 400 ? this.connection.getInputStream() : this.connection.getErrorStream();
            StringBuilder responseBodyBuilder = new StringBuilder();
            if (responseCode != 204 && is != null) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                while ((line = br.readLine()) != null) {
                    responseBodyBuilder.append(line).append(System.lineSeparator());
                }
                br.close();
            }
            if (responseCode >= 300 && responseCode != 429) {
                RiotApiError errorDto = null;
                try {
                    errorDto = (RiotApiError)new Gson().fromJson(responseBodyBuilder.toString(), RiotApiError.class);
                }
                catch (JsonSyntaxException e) {
                    // empty catch block
                }
                throw new RiotApiException(responseCode, errorDto);
            }
            this.setResponse(new RequestResponse(this.connection.getResponseCode(), responseBodyBuilder.toString(), this.connection.getHeaderFields()));
            if (this.config.getRateLimitHandler() != null) {
                this.config.getRateLimitHandler().onRequestDone(this);
            }
            if (responseCode == 429) {
                String retryAfterString = this.connection.getHeaderField("Retry-After");
                String rateLimitType = this.connection.getHeaderField("X-Rate-Limit-Type");
                if (retryAfterString != null) {
                    int retryAfter = Integer.parseInt(retryAfterString);
                    throw new RateLimitException(retryAfter, rateLimitType);
                }
                throw new RateLimitException(0, rateLimitType);
            }
            this.setState(RequestState.Succeeded);
        }
        catch (RespectedRateLimitException e) {
            this.setException(e);
            this.setState(RequestState.Failed);
            RiotApi.log.fine("[" + this.object + "] Request > RespectedRateLimitException: " + e.getMessage());
            throw e;
        }
        catch (RateLimitException e) {
            this.setException(e);
            this.setState(RequestState.Failed);
            RiotApi.log.fine("[" + this.object + "] Request > RateLimitException: " + e.getMessage());
            throw e;
        }
        catch (RiotApiException e) {
            this.setException(e);
            this.setState(RequestState.Failed);
            RiotApi.log.fine("[" + this.object + "] Request > RiotApiException: " + e.getMessage());
            throw e;
        }
        catch (SocketTimeoutException e) {
            RiotApiException exception = new RiotApiException(603);
            this.setException(exception);
            this.setState(RequestState.Timeout);
            RiotApi.log.fine("[" + this.object + "] Request > Timeout");
            throw exception;
        }
        catch (IOException e) {
            RiotApiException exception = new RiotApiException(601);
            this.setException(exception);
            this.setState(RequestState.Failed);
            RiotApi.log.log(Level.SEVERE, "[" + this.object + "] Request > IOException", e);
            throw exception;
        }
        catch (NullPointerException e) {
            RiotApiException exception = new RiotApiException(602);
            this.setException(exception);
            this.setState(RequestState.Failed);
            RiotApi.log.log(Level.SEVERE, "[" + this.object + "] Request > NullPointerException", e);
            throw exception;
        }
        finally {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    public <T> T getDto() throws RiotApiException, RateLimitException {
        return this.getDto(false);
    }

    protected <T> T getDto(boolean overrideStateRequirement) throws RiotApiException {
        if (!overrideStateRequirement) {
            this.requireSucceededRequestState();
        }
        if (this.response.getCode() == 204) {
            return null;
        }
        Type type = this.object.getReturnType();
        if (type == Void.class) {
            return null;
        }
        if (type == null) {
            throw new NullPointerException("The ApiMethod \"" + this.object + "\" has not set a dtoType. If this method is supposed to return something and you encounter this issue, please file a bug.");
        }
        Object dto = null;
        try {
            dto = new Gson().fromJson(this.response.getBody(), type);
        }
        catch (JsonSyntaxException e) {
            RiotApiException exception = new RiotApiException(600);
            this.setException(exception);
            throw exception;
        }
        if (dto == null) {
            RiotApiException exception = new RiotApiException(600);
            this.setException(exception);
            throw exception;
        }
        return (T)dto;
    }

    public RiotApiException getException() {
        return this.exception;
    }

    private RequestMethod getHttpMethod() {
        RequestMethod method = this.object.getHttpMethod();
        Objects.requireNonNull(method);
        return method;
    }

    public ApiMethod getObject() {
        return this.object;
    }

    public RequestResponse getResponse() {
        return this.response;
    }

    protected void init(ApiConfig config, ApiMethod object) {
        this.config = config;
        this.object = object;
    }

    public boolean isCancelled() {
        return this.state == RequestState.Cancelled;
    }

    public boolean isDone() {
        return this.state != RequestState.Waiting;
    }

    public boolean isFailed() {
        return this.state == RequestState.Failed;
    }

    public boolean isPending() {
        return this.state == RequestState.Waiting;
    }

    public boolean isSuccessful() {
        return this.state == RequestState.Succeeded;
    }

    public boolean isTimeOut() {
        return this.state == RequestState.Timeout;
    }

    protected void requireSucceededRequestState() {
        if (this.state == RequestState.Waiting) {
            throw new IllegalStateException("The request has not received a response yet");
        }
        if (this.state == RequestState.Cancelled) {
            throw new IllegalStateException("The request has been cancelled");
        }
        if (this.state == RequestState.Failed) {
            throw new IllegalStateException("The request has failed");
        }
    }

    protected void setException(RiotApiException exception) {
        this.exception = exception;
    }

    private void setResponse(RequestResponse response) {
        this.response = response;
    }

    protected boolean setState(RequestState state) {
        if (this.isDone()) {
            return false;
        }
        this.state = state;
        return true;
    }

    protected void setTimeout() {
        this.setTimeout(this.config.getRequestTimeout());
    }

    protected void setTimeout(int timeout) {
        if (this.connection != null && timeout > 0) {
            this.connection.setConnectTimeout(timeout);
            this.connection.setReadTimeout(timeout);
        }
    }

    protected static enum RequestState {
        Waiting,
        Cancelled,
        Succeeded,
        Failed,
        Timeout;

    }
}

