/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.riot.api.request;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import net.rithms.riot.api.ApiConfig;
import net.rithms.riot.api.ApiMethod;
import net.rithms.riot.api.RiotApi;
import net.rithms.riot.api.RiotApiException;
import net.rithms.riot.api.request.Request;
import net.rithms.riot.api.request.RequestListener;

public class AsyncRequest
extends Request
implements Runnable {
    protected final Object signal = new Object();
    private Collection<RequestListener> listeners = new CopyOnWriteArrayList<RequestListener>();
    private Thread executionThread = null;
    private boolean sent = false;

    public AsyncRequest(ApiConfig config, ApiMethod object) {
        this.init(config, object);
    }

    public void addListeners(RequestListener ... listeners) {
        this.listeners.addAll(Arrays.asList(listeners));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        while (!this.isDone()) {
            Object object = this.signal;
            synchronized (object) {
                this.signal.wait();
            }
        }
    }

    public void await(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.await(timeout, unit, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(long timeout, TimeUnit unit, boolean cancelOnTimeout) throws InterruptedException, TimeoutException {
        long end = System.currentTimeMillis() + unit.toMillis(timeout);
        while (!this.isDone() && System.currentTimeMillis() < end) {
            Object object = this.signal;
            synchronized (object) {
                this.signal.wait(end - System.currentTimeMillis());
            }
        }
        if (!this.isDone()) {
            if (cancelOnTimeout) {
                this.cancel();
            }
            throw new TimeoutException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel() {
        Object object = this.signal;
        synchronized (object) {
            boolean cancelled = super.cancel();
            if (!cancelled) {
                return false;
            }
            this.signal.notifyAll();
            if (this.connection != null) {
                this.setTimeout(1);
                this.connection.disconnect();
            }
        }
        return true;
    }

    @Override
    public synchronized void execute() {
        if (this.isSent()) {
            return;
        }
        this.sent = true;
        this.executionThread = new Thread(this);
        this.executionThread.setName("AsyncRequest - " + this.object);
        this.executionThread.start();
    }

    @Override
    public <T> T getDto() {
        try {
            return super.getDto(true);
        }
        catch (RiotApiException e) {
            RiotApi.log.log(Level.WARNING, "Retrieving Dto Failed", e);
            return null;
        }
    }

    public <T> T getDtoAndThrowException() throws RiotApiException {
        return super.getDto(true);
    }

    public boolean isSent() {
        return this.sent;
    }

    protected synchronized void notifyListeners(Request.RequestState state) {
        for (RequestListener listener : this.listeners) {
            if (state == Request.RequestState.Succeeded) {
                listener.onRequestSucceeded(this);
                continue;
            }
            if (state == Request.RequestState.Failed) {
                listener.onRequestFailed(this.getException());
                continue;
            }
            if (state != Request.RequestState.Timeout) continue;
            listener.onRequestTimeout(this);
        }
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void removeListener(RequestListener listeners) {
        this.listeners.removeAll(Arrays.asList(listeners));
    }

    @Override
    public void run() {
        try {
            super.execute();
        }
        catch (RiotApiException e) {
            this.setException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean setState(Request.RequestState state) {
        if (this.isDone()) {
            return false;
        }
        this.notifyListeners(state);
        super.setState(state);
        if (this.isDone()) {
            Object object = this.signal;
            synchronized (object) {
                this.signal.notifyAll();
            }
        }
        return true;
    }

    @Override
    protected void setTimeout() {
        this.setTimeout(this.config.getAsyncRequestTimeout());
    }
}

