/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.riot.api.endpoints.summoner.methods;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.logging.Level;
import net.rithms.riot.api.ApiConfig;
import net.rithms.riot.api.RiotApi;
import net.rithms.riot.api.endpoints.summoner.SummonerApiMethod;
import net.rithms.riot.api.endpoints.summoner.dto.Summoner;
import net.rithms.riot.constant.Platform;
import net.rithms.util.RiotApiUtil;

public class GetSummonerByName
extends SummonerApiMethod {
    public GetSummonerByName(ApiConfig config, Platform platform, String summonerName) {
        super(config);
        this.setPlatform(platform);
        summonerName = RiotApiUtil.normalizeSummonerName(summonerName);
        this.setReturnType((Type)((Object)Summoner.class));
        try {
            this.setUrlBase(platform.getHost() + "/lol/summoner/v3/summoners/by-name/" + URLEncoder.encode(summonerName, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            RiotApi.log.log(Level.SEVERE, "URL Encoding Failed", e);
        }
        this.addApiKeyParameter();
    }
}

