/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.riot.api;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.logging.Level;
import net.rithms.riot.api.RiotApi;

public class UrlParameter
implements Cloneable {
    private final String key;
    private final String value;

    public UrlParameter(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public UrlParameter(String key, int value) {
        this(key, String.valueOf(value));
    }

    public UrlParameter(String key, long value) {
        this(key, String.valueOf(value));
    }

    public UrlParameter(String key, boolean value) {
        this(key, value ? "true" : "false");
    }

    public UrlParameter(String key, Object value) {
        this(key, value.toString());
    }

    public UrlParameter clone() {
        return new UrlParameter(this.key, this.value);
    }

    protected String getKey() {
        return this.key;
    }

    protected String getValue() {
        return this.value;
    }

    public String toString() {
        String parameter = null;
        try {
            parameter = URLEncoder.encode(this.getKey(), "UTF-8") + "=" + URLEncoder.encode(this.getValue(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RiotApi.log.log(Level.SEVERE, "URL Encoding Failed", e);
        }
        return parameter;
    }
}

