/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.riot.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import net.rithms.riot.api.ApiConfig;
import net.rithms.riot.api.ApiMethod;
import net.rithms.riot.api.AsyncRequestPool;
import net.rithms.riot.api.RiotApiException;
import net.rithms.riot.api.request.AsyncRequest;
import net.rithms.riot.api.request.Request;
import net.rithms.riot.api.request.RequestListener;
import net.rithms.riot.api.request.ratelimit.RateLimitException;

class EndpointManager {
    private final ApiConfig config;
    private final AsyncRequestPool pool;
    private final Collection<RequestListener> listeners = new CopyOnWriteArrayList<RequestListener>();

    EndpointManager(ApiConfig config) {
        this.config = config;
        this.pool = new AsyncRequestPool(config);
    }

    void addListeners(RequestListener ... listeners) {
        this.listeners.addAll(Arrays.asList(listeners));
    }

    void awaitAll() throws InterruptedException {
        this.pool.awaitAll();
    }

    void callMethod(ApiMethod method) throws RateLimitException, RiotApiException {
        new Request(this.config, method);
    }

    <T> T callMethodAndReturnDto(ApiMethod method) throws RateLimitException, RiotApiException {
        Request request = new Request(this.config, method);
        return request.getDto();
    }

    AsyncRequest callMethodAsynchronously(ApiMethod method) {
        AsyncRequest request = new AsyncRequest(this.config, method);
        request.addListeners(this.listeners.toArray(new RequestListener[this.listeners.size()]));
        this.pool.add(request);
        return request;
    }

    int getPoolSize() {
        return this.pool.getPoolSize();
    }

    int getQueueSize() {
        return this.pool.getQueueSize();
    }

    void removeListeners(RequestListener ... listeners) {
        this.listeners.removeAll(Arrays.asList(listeners));
    }
}

