/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.riot.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.rithms.riot.api.ApiConfig;
import net.rithms.riot.api.AsyncRequestPoolSupervisor;
import net.rithms.riot.api.request.AsyncRequest;

class AsyncRequestPool {
    private final ApiConfig config;
    private final Queue<AsyncRequest> queue = new ConcurrentLinkedQueue<AsyncRequest>();
    private final List<AsyncRequest> pool = new ArrayList<AsyncRequest>();
    private AsyncRequestPoolSupervisor supervisor = null;

    AsyncRequestPool(ApiConfig config) {
        this.config = config;
    }

    void add(AsyncRequest request) {
        this.queue.add(request);
        this.invokeSupervisor();
    }

    void awaitAll() throws InterruptedException {
        if (this.pool.isEmpty() && this.queue.isEmpty()) {
            return;
        }
        ArrayList<AsyncRequest> pool = new ArrayList<AsyncRequest>(this.pool);
        for (AsyncRequest request : pool) {
            request.await();
        }
        ArrayList<AsyncRequest> queue = new ArrayList<AsyncRequest>(this.queue);
        for (AsyncRequest request : queue) {
            request.await();
        }
        this.clearPool();
        this.awaitAll();
    }

    synchronized int clearPool() {
        int clearedFromPool = 0;
        Iterator<AsyncRequest> iterator = this.pool.iterator();
        while (iterator.hasNext()) {
            AsyncRequest request = iterator.next();
            if (!request.isDone()) continue;
            iterator.remove();
            ++clearedFromPool;
        }
        return clearedFromPool;
    }

    int getMaxAsyncThreads() {
        if (this.config.getMaxAsyncThreads() > 0) {
            return this.config.getMaxAsyncThreads();
        }
        return Integer.MAX_VALUE;
    }

    int getPoolSize() {
        return this.pool.size();
    }

    int getQueueSize() {
        return this.queue.size();
    }

    private synchronized void invokeSupervisor() {
        if (this.supervisor == null) {
            this.supervisor = new AsyncRequestPoolSupervisor(this);
            this.supervisor.start();
        }
    }

    boolean isEmpty() {
        return this.pool.isEmpty() && this.queue.isEmpty();
    }

    synchronized boolean pollQueue() {
        if (this.getPoolSize() == this.getMaxAsyncThreads()) {
            return false;
        }
        AsyncRequest request = this.queue.poll();
        if (request == null) {
            return false;
        }
        request.execute();
        this.pool.add(request);
        return true;
    }

    void resignSupervisor() {
        if (this.supervisor == null) {
            return;
        }
        this.supervisor.shutdown();
        this.supervisor = null;
    }
}

