/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.riot.api;

import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.rithms.riot.api.ApiConfig;
import net.rithms.riot.api.HttpHeadParameter;
import net.rithms.riot.api.RiotApiException;
import net.rithms.riot.api.UrlParameter;
import net.rithms.riot.api.request.RequestMethod;
import net.rithms.riot.constant.Platform;

public abstract class ApiMethod {
    private final ApiConfig config;
    private final String service;
    private Platform platform = null;
    private String urlBase;
    private final List<UrlParameter> urlParameters = new ArrayList<UrlParameter>();
    private final List<HttpHeadParameter> httpHeadParameters = new ArrayList<HttpHeadParameter>();
    private RequestMethod httpMethod = RequestMethod.GET;
    private String body = null;
    private Type returnType = null;
    private boolean requireApiKey = false;

    protected ApiMethod(ApiConfig config, String service) {
        this.config = config;
        this.service = service;
    }

    protected void add(HttpHeadParameter p) {
        this.httpHeadParameters.add(p);
    }

    protected void add(UrlParameter p) {
        this.urlParameters.add(p);
    }

    protected void addApiKeyParameter() {
        this.add(new HttpHeadParameter("X-Riot-Token", this.getConfig().getKey()));
    }

    public void buildJsonBody(Map<String, Object> map) {
        this.body = new Gson().toJson(map);
    }

    public void checkRequirements() throws RiotApiException {
        if (this.doesRequireApiKey() && this.getConfig().getKey() == null) {
            throw new RiotApiException(611);
        }
    }

    public boolean doesRequireApiKey() {
        return this.requireApiKey;
    }

    public String getBody() {
        return this.body;
    }

    protected ApiConfig getConfig() {
        return this.config;
    }

    public List<HttpHeadParameter> getHttpHeadParameters() {
        return this.httpHeadParameters;
    }

    public RequestMethod getHttpMethod() {
        return this.httpMethod;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public String getService() {
        return this.service;
    }

    public String getUrl() {
        StringBuilder url = new StringBuilder(this.urlBase);
        int connector = 63;
        for (UrlParameter p : this.urlParameters) {
            url.append((char)connector).append(p.toString());
            connector = 38;
        }
        return url.toString();
    }

    protected void requireApiKey() {
        this.requireApiKey = true;
    }

    protected void setPlatform(Platform platform) {
        this.platform = platform;
    }

    protected void setReturnType(Type returnType) {
        this.returnType = returnType;
    }

    protected void setHttpMethod(RequestMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    protected void setUrlBase(String urlBase) {
        this.urlBase = urlBase;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

