/*
 * Decompiled with CFR 0.152.
 */
package com.tarek360.instacapture;

import android.app.Activity;
import android.graphics.Bitmap;
import android.view.View;
import com.tarek360.instacapture.ActivityReferenceManager;
import com.tarek360.instacapture.exception.ActivityNotRunningException;
import com.tarek360.instacapture.listener.ScreenCaptureListener;
import com.tarek360.instacapture.screenshot.ScreenshotProvider;
import com.tarek360.instacapture.utility.Logger;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000e\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/tarek360/instacapture/Instacapture;", "", "()V", "ERROR_SCREENSHOT_CAPTURE_FAILED", "", "MESSAGE_IS_ACTIVITY_RUNNING", "capture", "", "activity", "Landroid/app/Activity;", "screenCaptureListener", "Lcom/tarek360/instacapture/listener/ScreenCaptureListener;", "ignoredViews", "", "Landroid/view/View;", "(Landroid/app/Activity;Lcom/tarek360/instacapture/listener/ScreenCaptureListener;[Landroid/view/View;)V", "captureRx", "Lrx/Observable;", "Landroid/graphics/Bitmap;", "(Landroid/app/Activity;[Landroid/view/View;)Lrx/Observable;", "enableLogging", "enable", "", "instacapture_release"})
public final class Instacapture {
    private static final String MESSAGE_IS_ACTIVITY_RUNNING = "Is your activity running?";
    private static final String ERROR_SCREENSHOT_CAPTURE_FAILED = "Screenshot capture failed";
    public static final Instacapture INSTANCE;

    public final void capture(@NotNull Activity activity, @NotNull ScreenCaptureListener screenCaptureListener, View ... ignoredViews) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)screenCaptureListener, (String)"screenCaptureListener");
        Intrinsics.checkParameterIsNotNull((Object)ignoredViews, (String)"ignoredViews");
        screenCaptureListener.onCaptureStarted();
        this.captureRx(activity, Arrays.copyOf(ignoredViews, ignoredViews.length)).subscribe((Subscriber)new Subscriber<Bitmap>(screenCaptureListener){
            final /* synthetic */ ScreenCaptureListener $screenCaptureListener;

            public void onCompleted() {
            }

            public void onError(@NotNull Throwable e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                Logger.INSTANCE.e(Instacapture.access$getERROR_SCREENSHOT_CAPTURE_FAILED$p(Instacapture.INSTANCE));
                Logger.INSTANCE.printStackTrace(e);
                this.$screenCaptureListener.onCaptureFailed(e);
            }

            public void onNext(@NotNull Bitmap bitmap) {
                Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
                this.$screenCaptureListener.onCaptureComplete(bitmap);
            }
            {
                this.$screenCaptureListener = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public final Observable<Bitmap> captureRx(@NotNull Activity activity, View ... ignoredViews) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)ignoredViews, (String)"ignoredViews");
        ActivityReferenceManager activityReferenceManager = new ActivityReferenceManager();
        activityReferenceManager.setActivity(activity);
        Activity activity2 = activityReferenceManager.getValidatedActivity();
        if (activity2 == null) {
            Observable observable = Observable.error((Throwable)new ActivityNotRunningException(MESSAGE_IS_ACTIVITY_RUNNING));
            Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.error<Bitmap>\u2026AGE_IS_ACTIVITY_RUNNING))");
            return observable;
        }
        Activity validatedActivity = activity2;
        ScreenshotProvider screenshotProvider = new ScreenshotProvider();
        Observable observable = screenshotProvider.getScreenshotBitmap(validatedActivity, ignoredViews).observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"screenshotProvider.getSc\u2026dSchedulers.mainThread())");
        return observable;
    }

    public final void enableLogging(boolean enable) {
        if (enable) {
            Logger.INSTANCE.enable();
        } else {
            Logger.INSTANCE.disable();
        }
    }

    private Instacapture() {
    }

    static {
        Instacapture instacapture;
        INSTANCE = instacapture = new Instacapture();
        MESSAGE_IS_ACTIVITY_RUNNING = MESSAGE_IS_ACTIVITY_RUNNING;
        ERROR_SCREENSHOT_CAPTURE_FAILED = ERROR_SCREENSHOT_CAPTURE_FAILED;
    }

    @NotNull
    public static final /* synthetic */ String access$getERROR_SCREENSHOT_CAPTURE_FAILED$p(Instacapture $this) {
        Instacapture instacapture = $this;
        return ERROR_SCREENSHOT_CAPTURE_FAILED;
    }
}

