/*
 * Decompiled with CFR 0.152.
 */
package com.tarek360.instacapture.screenshot.maps;

import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.MapView;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.SupportMapFragment;
import com.tarek360.instacapture.exception.MapSnapshotFailedException;
import com.tarek360.instacapture.screenshot.maps.GoogleMapBitmap;
import com.tarek360.instacapture.utility.Logger;
import rx.Observable;
import rx.Subscriber;

public final class GoogleMapBitmapObservable {
    private GoogleMapBitmapObservable() {
    }

    public static Observable<GoogleMapBitmap> getMapViewObservable(final @NonNull MapView mapView) {
        final int[] screenPosition = new int[2];
        mapView.getLocationOnScreen(screenPosition);
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<GoogleMapBitmap>(){

            public void call(final Subscriber<? super GoogleMapBitmap> subscriber) {
                Logger.d("create call");
                mapView.getMapAsync(new OnMapReadyCallback(){

                    public void onMapReady(@NonNull GoogleMap gMap) {
                        gMap.snapshot(new GoogleMap.SnapshotReadyCallback(){

                            public void onSnapshotReady(@Nullable Bitmap bitmap) {
                                if (bitmap != null) {
                                    Logger.d("onSnapshotReady bitmap != null");
                                    subscriber.onNext((Object)new GoogleMapBitmap(screenPosition, bitmap));
                                    subscriber.onCompleted();
                                } else {
                                    Logger.d("onSnapshotReady bitmap == null");
                                    subscriber.onError((Throwable)new MapSnapshotFailedException());
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    public static Observable<GoogleMapBitmap> getMapFragmentObservable(final @NonNull SupportMapFragment mapFragment) {
        final int[] screenPosition = new int[2];
        View view = mapFragment.getView();
        if (view != null) {
            view.getLocationOnScreen(screenPosition);
        }
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<GoogleMapBitmap>(){

            public void call(final Subscriber<? super GoogleMapBitmap> subscriber) {
                Logger.d("create call");
                mapFragment.getMapAsync(new OnMapReadyCallback(){

                    public void onMapReady(@NonNull GoogleMap gMap) {
                        gMap.snapshot(new GoogleMap.SnapshotReadyCallback(){

                            public void onSnapshotReady(@Nullable Bitmap bitmap) {
                                if (bitmap != null) {
                                    Logger.d("onSnapshotReady bitmap != null");
                                    subscriber.onNext((Object)new GoogleMapBitmap(screenPosition, bitmap));
                                    subscriber.onCompleted();
                                } else {
                                    Logger.d("onSnapshotReady bitmap == null");
                                    subscriber.onError((Throwable)new MapSnapshotFailedException());
                                }
                            }
                        });
                    }
                });
            }
        });
    }
}

