/*
 * Decompiled with CFR 0.152.
 */
package com.tarek360.instacapture.screenshot;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.maps.MapView;
import com.google.android.gms.maps.SupportMapFragment;
import com.tarek360.instacapture.screenshot.ScreenshotFileObservable;
import com.tarek360.instacapture.screenshot.ScreenshotProvider;
import com.tarek360.instacapture.screenshot.maps.GoogleMapBitmap;
import com.tarek360.instacapture.screenshot.maps.GoogleMapBitmapObservable;
import com.tarek360.instacapture.screenshot.nonMaps.NonMapViewsBitmapObservable;
import com.tarek360.instacapture.utility.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

public class ScreenshotProviderImpl
implements ScreenshotProvider {
    private static Paint MAP_PAINT;
    private static final Func2<Bitmap, List<GoogleMapBitmap>, Bitmap> BITMAP_COMBINING_FUNCTION;

    public ScreenshotProviderImpl() {
        if (MAP_PAINT == null) {
            MAP_PAINT = new Paint();
            MAP_PAINT.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
        }
    }

    @Override
    public Observable<File> getScreenshotFile(@NonNull Activity activity, File file, View[] removedViews) {
        Observable<Bitmap> screenshotBitmapObservable = this.getScreenshotBitmapObservable(activity, removedViews);
        return ScreenshotFileObservable.get(screenshotBitmapObservable, activity.getApplicationContext(), file);
    }

    private Observable<Bitmap> getScreenshotBitmapObservable(@NonNull Activity activity, View[] removedViews) {
        Observable<Bitmap> nonMapViewsBitmapObservable = NonMapViewsBitmapObservable.get(activity, removedViews);
        View rootView = activity.getWindow().getDecorView().getRootView();
        List<MapView> mapViews = this.getMapViews(rootView);
        List<SupportMapFragment> mapFragments = this.getMapFragments(activity);
        if (mapViews.isEmpty() && mapFragments.isEmpty()) {
            return nonMapViewsBitmapObservable;
        }
        if (!mapFragments.isEmpty()) {
            Observable<List<GoogleMapBitmap>> mapViewBitmapsObservable = this.getMapFragmentBitmapsObservable(mapFragments);
            return Observable.zip(nonMapViewsBitmapObservable, mapViewBitmapsObservable, BITMAP_COMBINING_FUNCTION);
        }
        Observable<List<GoogleMapBitmap>> mapViewBitmapsObservable = this.getMapViewBitmapsObservable(mapViews);
        return Observable.zip(nonMapViewsBitmapObservable, mapViewBitmapsObservable, BITMAP_COMBINING_FUNCTION);
    }

    private List<SupportMapFragment> getMapFragments(@NonNull Activity activity) {
        List fragments;
        ArrayList<SupportMapFragment> mapFragments = new ArrayList<SupportMapFragment>();
        if (activity instanceof FragmentActivity && (fragments = ((FragmentActivity)activity).getSupportFragmentManager().getFragments()) != null) {
            for (Fragment fragment : fragments) {
                if (fragment instanceof SupportMapFragment) {
                    Logger.d("zzfragment instanceof SupportMapFragment");
                    mapFragments.add((SupportMapFragment)fragment);
                }
                Logger.d("zz fragment " + fragment);
            }
        }
        return mapFragments;
    }

    private List<MapView> getMapViews(@NonNull View rootView) {
        ArrayList<MapView> mapViews = new ArrayList<MapView>();
        LinkedList<View> views = new LinkedList<View>();
        views.add(rootView);
        while (!views.isEmpty()) {
            View view = (View)views.remove();
            if (view instanceof MapView && view.getVisibility() == 0) {
                mapViews.add((MapView)view);
                continue;
            }
            if (!(view instanceof ViewGroup)) continue;
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                views.add(viewGroup.getChildAt(i));
            }
        }
        return mapViews;
    }

    private Observable<List<GoogleMapBitmap>> getMapViewBitmapsObservable(@NonNull List<MapView> mapViews) {
        return Observable.from(mapViews).concatMap((Func1)new Func1<MapView, Observable<GoogleMapBitmap>>(){

            public Observable<GoogleMapBitmap> call(@NonNull MapView mapView) {
                Logger.d("getMapViewBitmapsObservable list " + mapView);
                return GoogleMapBitmapObservable.getMapViewObservable(mapView);
            }
        }).toList();
    }

    private Observable<List<GoogleMapBitmap>> getMapFragmentBitmapsObservable(@NonNull List<SupportMapFragment> supportMapFragments) {
        return Observable.from(supportMapFragments).concatMap((Func1)new Func1<SupportMapFragment, Observable<GoogleMapBitmap>>(){

            public Observable<GoogleMapBitmap> call(@NonNull SupportMapFragment mapFragment) {
                Logger.d("getMapViewBitmapsObservable list " + mapFragment);
                return GoogleMapBitmapObservable.getMapFragmentObservable(mapFragment);
            }
        }).toList();
    }

    static {
        BITMAP_COMBINING_FUNCTION = new Func2<Bitmap, List<GoogleMapBitmap>, Bitmap>(){

            public Bitmap call(Bitmap baseLocatedBitmap, List<GoogleMapBitmap> googleMapBitmaps) {
                Canvas canvas = new Canvas(baseLocatedBitmap);
                for (GoogleMapBitmap googleMapBitmap : googleMapBitmaps) {
                    int[] position = googleMapBitmap.getPosition();
                    canvas.drawBitmap(googleMapBitmap.getBitmap(), (float)position[0], (float)position[1], MAP_PAINT);
                }
                return baseLocatedBitmap;
            }
        };
    }
}

