/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.annotation.SuppressLint;
import com.tamsiree.rxkit.RxConstTool;
import com.tamsiree.rxkit.RxDataTool;
import com.tamsiree.rxkit.TLog;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0014\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u0007J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\bH\u0007J\u001c\u0010\u0018\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u0019\u001a\u00020\u0004H\u0007J\u0012\u0010\u001a\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0007J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\fH\u0007J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J\u0012\u0010\u001d\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u0010H\u0007J\u001c\u0010\u001e\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u0010H\u0007J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!H\u0007J\u001a\u0010$\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\b2\b\u0010%\u001a\u0004\u0018\u00010&H\u0007J\u001c\u0010$\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00102\b\u0010%\u001a\u0004\u0018\u00010&H\u0007J$\u0010$\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00102\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J\"\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b2\b\u0010%\u001a\u0004\u0018\u00010&H\u0007J&\u0010'\u001a\u00020\f2\b\u0010*\u001a\u0004\u0018\u00010\u00102\b\u0010(\u001a\u0004\u0018\u00010\u00102\b\u0010%\u001a\u0004\u0018\u00010&H\u0007J.\u0010'\u001a\u00020\f2\b\u0010*\u001a\u0004\u0018\u00010\u00102\b\u0010(\u001a\u0004\u0018\u00010\u00102\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J\u0012\u0010+\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u0010H\u0007J\u0010\u0010,\u001a\u00020-2\u0006\u0010\"\u001a\u00020!H\u0007J\u0010\u0010.\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\fH\u0007J\u001a\u0010/\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\f2\b\b\u0002\u0010\u0019\u001a\u00020\u0004H\u0007J\u001a\u00100\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f2\b\u0010%\u001a\u0004\u0018\u00010&H\u0007J\u001c\u00101\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u00102\b\u00102\u001a\u0004\u0018\u00010\bH\u0007J\u001c\u00103\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0019\u001a\u00020\u0004H\u0007J\u001e\u00103\u001a\u0004\u0018\u00010\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00102\b\u00104\u001a\u0004\u0018\u00010\u0010H\u0007J\u001c\u00105\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0019\u001a\u00020\u0004H\u0007J\u001c\u00106\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u00102\b\u00104\u001a\u0004\u0018\u00010\u0010H\u0007J\u0012\u00107\u001a\u00020!2\b\u00108\u001a\u0004\u0018\u00010\u0010H\u0007J\u001a\u00107\u001a\u00020!2\b\u00108\u001a\u0004\u0018\u00010\u00102\u0006\u00101\u001a\u00020\u0004H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u00108FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00069"}, d2={"Lcom/tamsiree/rxkit/RxTimeTool;", "", "()V", "DEFAULT_SDF", "Ljava/text/SimpleDateFormat;", "getDEFAULT_SDF", "()Ljava/text/SimpleDateFormat;", "curTimeDate", "Ljava/util/Date;", "getCurTimeDate", "()Ljava/util/Date;", "curTimeMills", "", "getCurTimeMills", "()J", "curTimeString", "", "getCurTimeString$annotations", "getCurTimeString", "()Ljava/lang/String;", "Date2Timestamp", "mDate", "date2Milliseconds", "time", "date2String", "format", "formatSeconds", "formatTime", "milliseconds", "getCurrentDateTime", "getDate", "times", "getDaysByYearMonth", "", "year", "month", "getIntervalByNow", "unit", "Lcom/tamsiree/rxkit/RxConstTool$TimeUnit;", "getIntervalTime", "time1", "time2", "time0", "getYestoryDate", "isLeapYear", "", "milliseconds2Date", "milliseconds2String", "milliseconds2Unit", "simpleDateFormat", "date", "string2Date", "datess", "string2Milliseconds", "string2Timestamp", "stringForWeek", "strDate", "RxKit_release"})
public final class RxTimeTool {
    @NotNull
    public static final RxTimeTool INSTANCE = new RxTimeTool();
    @NotNull
    private static final SimpleDateFormat DEFAULT_SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());

    private RxTimeTool() {
    }

    @NotNull
    public final SimpleDateFormat getDEFAULT_SDF() {
        return DEFAULT_SDF;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String milliseconds2String(long milliseconds, @NotNull SimpleDateFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        String string = format.format(new Date(milliseconds));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format.format(Date(milliseconds))");
        return string;
    }

    public static /* synthetic */ String milliseconds2String$default(long l, SimpleDateFormat simpleDateFormat, int n, Object object) {
        if ((n & 2) != 0) {
            simpleDateFormat = DEFAULT_SDF;
        }
        return RxTimeTool.milliseconds2String(l, simpleDateFormat);
    }

    @JvmStatic
    @JvmOverloads
    public static final long string2Milliseconds(@Nullable String time, @NotNull SimpleDateFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        try {
            return format.parse(time).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public static /* synthetic */ long string2Milliseconds$default(String string, SimpleDateFormat simpleDateFormat, int n, Object object) {
        if ((n & 2) != 0) {
            simpleDateFormat = DEFAULT_SDF;
        }
        return RxTimeTool.string2Milliseconds(string, simpleDateFormat);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Date string2Date(@Nullable String time, @NotNull SimpleDateFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return new Date(RxTimeTool.string2Milliseconds(time, format));
    }

    public static /* synthetic */ Date string2Date$default(String string, SimpleDateFormat simpleDateFormat, int n, Object object) {
        if ((n & 2) != 0) {
            simpleDateFormat = DEFAULT_SDF;
        }
        return RxTimeTool.string2Date(string, simpleDateFormat);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String date2String(@Nullable Date time, @NotNull SimpleDateFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        String string = format.format(time);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format.format(time)");
        return string;
    }

    public static /* synthetic */ String date2String$default(Date date, SimpleDateFormat simpleDateFormat, int n, Object object) {
        if ((n & 2) != 0) {
            simpleDateFormat = DEFAULT_SDF;
        }
        return RxTimeTool.date2String(date, simpleDateFormat);
    }

    @JvmStatic
    public static final long date2Milliseconds(@NotNull Date time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return time.getTime();
    }

    @JvmStatic
    @NotNull
    public static final Date milliseconds2Date(long milliseconds) {
        return new Date(milliseconds);
    }

    @JvmStatic
    public static final long milliseconds2Unit(long milliseconds, @Nullable RxConstTool.TimeUnit unit) {
        RxConstTool.TimeUnit timeUnit = unit;
        int n = timeUnit == null ? -1 : WhenMappings.$EnumSwitchMapping$0[timeUnit.ordinal()];
        switch (n) {
            case 1: {
                return milliseconds / 1L;
            }
            case 2: {
                return milliseconds / (long)1000;
            }
            case 3: {
                return milliseconds / (long)60000;
            }
            case 4: {
                return milliseconds / (long)3600000;
            }
            case 5: {
                return milliseconds / (long)86400000;
            }
        }
        return -1L;
    }

    @JvmStatic
    public static final long getIntervalTime(@Nullable String time0, @Nullable String time1, @Nullable RxConstTool.TimeUnit unit) {
        return RxTimeTool.getIntervalTime(time0, time1, unit, DEFAULT_SDF);
    }

    @JvmStatic
    public static final long getIntervalTime(@Nullable String time0, @Nullable String time1, @Nullable RxConstTool.TimeUnit unit, @NotNull SimpleDateFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return Math.abs(RxTimeTool.milliseconds2Unit(RxTimeTool.string2Milliseconds(time0, format) - RxTimeTool.string2Milliseconds(time1, format), unit));
    }

    @JvmStatic
    public static final long getIntervalTime(@NotNull Date time1, @NotNull Date time2, @Nullable RxConstTool.TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)time1, (String)"time1");
        Intrinsics.checkNotNullParameter((Object)time2, (String)"time2");
        return Math.abs(RxTimeTool.milliseconds2Unit(RxTimeTool.date2Milliseconds(time2) - RxTimeTool.date2Milliseconds(time1), unit));
    }

    public final long getCurTimeMills() {
        return System.currentTimeMillis();
    }

    @NotNull
    public static final String getCurTimeString() {
        return RxTimeTool.date2String$default(new Date(), null, 2, null);
    }

    @JvmStatic
    public static /* synthetic */ void getCurTimeString$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final String getCurTimeString(@NotNull SimpleDateFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return RxTimeTool.date2String(new Date(), format);
    }

    @NotNull
    public final Date getCurTimeDate() {
        return new Date();
    }

    @JvmStatic
    public static final long getIntervalByNow(@Nullable String time, @Nullable RxConstTool.TimeUnit unit) {
        return RxTimeTool.getIntervalByNow(time, unit, DEFAULT_SDF);
    }

    @JvmStatic
    public static final long getIntervalByNow(@Nullable String time, @Nullable RxConstTool.TimeUnit unit, @NotNull SimpleDateFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return RxTimeTool.getIntervalTime(INSTANCE.getCurTimeString(), time, unit, format);
    }

    @JvmStatic
    public static final long getIntervalByNow(@NotNull Date time, @Nullable RxConstTool.TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return RxTimeTool.getIntervalTime(INSTANCE.getCurTimeDate(), time, unit);
    }

    @JvmStatic
    public static final boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    @JvmStatic
    @NotNull
    public static final String simpleDateFormat(@Nullable String format, @Nullable Date date) {
        String format2 = format;
        if (RxDataTool.Companion.isNullString(format2)) {
            format2 = "yyyy-MM-dd HH:mm:ss SSS";
        }
        String string = new SimpleDateFormat(format2).format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SimpleDateFormat(format).format(date)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String Date2Timestamp(@Nullable Date mDate) {
        Intrinsics.checkNotNull((Object)mDate);
        String string = String.valueOf(mDate.getTime());
        int n = 0;
        int n2 = 10;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    @JvmStatic
    @Nullable
    public static final Date string2Date(@Nullable String format, @Nullable String datess) {
        SimpleDateFormat sdr = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = sdr.parse(datess);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    @JvmStatic
    @NotNull
    public static final String string2Timestamp(@Nullable String format, @Nullable String datess) {
        Date date = RxTimeTool.string2Date(format, datess);
        return RxTimeTool.Date2Timestamp(date);
    }

    @JvmStatic
    @SuppressLint(value={"SimpleDateFormat"})
    @NotNull
    public static final String getCurrentDateTime(@Nullable String format) {
        return RxTimeTool.simpleDateFormat(format, new Date());
    }

    @JvmStatic
    @SuppressLint(value={"SimpleDateFormat"})
    @NotNull
    public static final String getDate(@Nullable String times, @Nullable String format) {
        Intrinsics.checkNotNull((Object)times);
        return RxTimeTool.simpleDateFormat(format, new Date((long)RxDataTool.Companion.stringToInt(times) * 1000L));
    }

    @JvmStatic
    @NotNull
    public static final String getYestoryDate(@Nullable String format) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        return RxTimeTool.simpleDateFormat(format, calendar.getTime());
    }

    @JvmStatic
    @NotNull
    public static final String formatTime(long milliseconds) {
        String format = "mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        String string = sdf.format(milliseconds);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdf.format(milliseconds)");
        return string;
    }

    @JvmStatic
    public static final long formatSeconds(@Nullable String time) {
        String format = "mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        Date date = null;
        long times = 0L;
        try {
            long l;
            Date date2 = sdf.parse(time);
            Intrinsics.checkNotNullExpressionValue((Object)date2, (String)"sdf.parse(time)");
            date = date2;
            times = l = date.getTime();
            TLog.d$default("\u65f6\u95f4\u6233", times + "", null, 4, null);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return times;
    }

    @JvmStatic
    public static final int getDaysByYearMonth(int year, int month) {
        Calendar a = Calendar.getInstance();
        a.set(1, year);
        a.set(2, month - 1);
        a.set(5, 1);
        a.roll(5, -1);
        return a.get(5);
    }

    @JvmStatic
    public static final int stringForWeek(@Nullable String strDate) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.setTime(format.parse(strDate));
        return c.get(7) == 1 ? 7 : c.get(7) - 1;
    }

    @JvmStatic
    public static final int stringForWeek(@Nullable String strDate, @NotNull SimpleDateFormat simpleDateFormat) throws Exception {
        Intrinsics.checkNotNullParameter((Object)simpleDateFormat, (String)"simpleDateFormat");
        Calendar c = Calendar.getInstance();
        c.setTime(simpleDateFormat.parse(strDate));
        return c.get(7) == 1 ? 7 : c.get(7) - 1;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String milliseconds2String(long milliseconds) {
        return RxTimeTool.milliseconds2String$default(milliseconds, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final long string2Milliseconds(@Nullable String time) {
        return RxTimeTool.string2Milliseconds$default(time, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Date string2Date(@Nullable String time) {
        return RxTimeTool.string2Date$default(time, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String date2String(@Nullable Date time) {
        return RxTimeTool.date2String$default(time, null, 2, null);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RxConstTool.TimeUnit.values().length];
            nArray[RxConstTool.TimeUnit.MSEC.ordinal()] = 1;
            nArray[RxConstTool.TimeUnit.SEC.ordinal()] = 2;
            nArray[RxConstTool.TimeUnit.MIN.ordinal()] = 3;
            nArray[RxConstTool.TimeUnit.HOUR.ordinal()] = 4;
            nArray[RxConstTool.TimeUnit.DAY.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

