/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001:\u00012B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0016\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0019J0\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001c0\u001b0\u0019\"\u0004\b\u0000\u0010\u001c2\u0016\u0010\u001d\u001a\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u001c\u0018\u00010\u001f\u0018\u00010\u001eJB\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001c0\u001b0\u0019\"\u0004\b\u0000\u0010\u001c2\u0016\u0010\u001d\u001a\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u001c\u0018\u00010\u001f\u0018\u00010\u001e2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J)\u0010 \u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c2\u0016\u0010\u001d\u001a\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u001c\u0018\u00010\u001f\u0018\u00010\u001e\u00a2\u0006\u0002\u0010!J;\u0010 \u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c2\u0016\u0010\u001d\u001a\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u001c\u0018\u00010\u001f\u0018\u00010\u001e2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\"J&\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010%\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J4\u0010#\u001a\b\u0012\u0004\u0012\u0002H&0$\"\u0004\b\u0000\u0010&2\u000e\u0010'\u001a\n\u0012\u0004\u0012\u0002H&\u0018\u00010\u001f2\u0006\u0010%\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J.\u0010(\u001a\u0006\u0012\u0002\b\u00030$2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010)\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J.\u0010*\u001a\u0006\u0012\u0002\b\u00030$2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010)\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0006\u0010,\u001a\u00020\u0015J\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019J\u0014\u0010.\u001a\u0006\u0012\u0002\b\u00030\u001b2\b\u0010/\u001a\u0004\u0018\u00010\u0017J)\u0010.\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001b\"\u0004\b\u0000\u0010\u001c2\b\u0010/\u001a\u0004\u0018\u00010\u00172\u0006\u00100\u001a\u0002H\u001c\u00a2\u0006\u0002\u00101J\"\u0010.\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001b\"\u0004\b\u0000\u0010\u001c2\u000e\u0010/\u001a\n\u0012\u0004\u0012\u0002H\u001c\u0018\u00010\u001fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000bR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/tamsiree/rxkit/RxThreadPoolTool;", "", "type", "Lcom/tamsiree/rxkit/RxThreadPoolTool$Type;", "corePoolSize", "", "(Lcom/tamsiree/rxkit/RxThreadPoolTool$Type;I)V", "exec", "Ljava/util/concurrent/ExecutorService;", "isShutDown", "", "()Z", "isTerminated", "scheduleExec", "Ljava/util/concurrent/ScheduledExecutorService;", "awaitTermination", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "execute", "", "command", "Ljava/lang/Runnable;", "commands", "", "invokeAll", "Ljava/util/concurrent/Future;", "T", "tasks", "", "Ljava/util/concurrent/Callable;", "invokeAny", "(Ljava/util/Collection;)Ljava/lang/Object;", "(Ljava/util/Collection;JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "schedule", "Ljava/util/concurrent/ScheduledFuture;", "delay", "V", "callable", "scheduleWithFixedDelay", "initialDelay", "scheduleWithFixedRate", "period", "shutDown", "shutDownNow", "submit", "task", "result", "(Ljava/lang/Runnable;Ljava/lang/Object;)Ljava/util/concurrent/Future;", "Type", "RxKit_release"})
public final class RxThreadPoolTool {
    @Nullable
    private ExecutorService exec;
    @NotNull
    private final ScheduledExecutorService scheduleExec;

    public RxThreadPoolTool(@Nullable Type type, int corePoolSize) {
        ExecutorService executorService;
        Object object = Executors.newScheduledThreadPool(corePoolSize);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newScheduledThreadPool(corePoolSize)");
        this.scheduleExec = object;
        object = type;
        int n = object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 1: {
                executorService = Executors.newFixedThreadPool(corePoolSize);
                break;
            }
            case 2: {
                executorService = Executors.newSingleThreadExecutor();
                break;
            }
            case 3: {
                executorService = Executors.newCachedThreadPool();
                break;
            }
            default: {
                executorService = this.scheduleExec;
            }
        }
        this.exec = executorService;
    }

    public final void execute(@Nullable Runnable command) {
        ExecutorService executorService = this.exec;
        Intrinsics.checkNotNull((Object)executorService);
        executorService.execute(command);
    }

    public final void execute(@NotNull List<? extends Runnable> commands) {
        Intrinsics.checkNotNullParameter(commands, (String)"commands");
        for (Runnable runnable : commands) {
            ExecutorService executorService = this.exec;
            Intrinsics.checkNotNull((Object)executorService);
            executorService.execute(runnable);
        }
    }

    public final void shutDown() {
        ExecutorService executorService = this.exec;
        Intrinsics.checkNotNull((Object)executorService);
        executorService.shutdown();
    }

    @NotNull
    public final List<Runnable> shutDownNow() {
        ExecutorService executorService = this.exec;
        Intrinsics.checkNotNull((Object)executorService);
        List<Runnable> list = executorService.shutdownNow();
        Intrinsics.checkNotNullExpressionValue(list, (String)"exec!!.shutdownNow()");
        return list;
    }

    public final boolean isShutDown() {
        ExecutorService executorService = this.exec;
        Intrinsics.checkNotNull((Object)executorService);
        return executorService.isShutdown();
    }

    public final boolean isTerminated() {
        ExecutorService executorService = this.exec;
        Intrinsics.checkNotNull((Object)executorService);
        return executorService.isTerminated();
    }

    public final boolean awaitTermination(long timeout, @Nullable TimeUnit unit) throws InterruptedException {
        ExecutorService executorService = this.exec;
        Intrinsics.checkNotNull((Object)executorService);
        return executorService.awaitTermination(timeout, unit);
    }

    @NotNull
    public final <T> Future<T> submit(@Nullable Callable<T> task) {
        ExecutorService executorService = this.exec;
        Intrinsics.checkNotNull((Object)executorService);
        Future<T> future = executorService.submit(task);
        Intrinsics.checkNotNullExpressionValue(future, (String)"exec!!.submit(task)");
        return future;
    }

    @NotNull
    public final <T> Future<T> submit(@Nullable Runnable task, T result) {
        ExecutorService executorService = this.exec;
        Intrinsics.checkNotNull((Object)executorService);
        Future<T> future = executorService.submit(task, result);
        Intrinsics.checkNotNullExpressionValue(future, (String)"exec!!.submit(task, result)");
        return future;
    }

    @NotNull
    public final Future<?> submit(@Nullable Runnable task) {
        ExecutorService executorService = this.exec;
        Intrinsics.checkNotNull((Object)executorService);
        Future<?> future = executorService.submit(task);
        Intrinsics.checkNotNullExpressionValue(future, (String)"exec!!.submit(task)");
        return future;
    }

    @NotNull
    public final <T> List<Future<T>> invokeAll(@Nullable Collection<? extends Callable<T>> tasks) throws InterruptedException {
        ExecutorService executorService = this.exec;
        Intrinsics.checkNotNull((Object)executorService);
        List list = executorService.invokeAll(tasks);
        Intrinsics.checkNotNullExpressionValue(list, (String)"exec!!.invokeAll(tasks)");
        return list;
    }

    @NotNull
    public final <T> List<Future<T>> invokeAll(@Nullable Collection<? extends Callable<T>> tasks, long timeout, @Nullable TimeUnit unit) throws InterruptedException {
        ExecutorService executorService = this.exec;
        Intrinsics.checkNotNull((Object)executorService);
        List list = executorService.invokeAll(tasks, timeout, unit);
        Intrinsics.checkNotNullExpressionValue(list, (String)"exec!!.invokeAll(tasks, timeout, unit)");
        return list;
    }

    public final <T> T invokeAny(@Nullable Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        ExecutorService executorService = this.exec;
        Intrinsics.checkNotNull((Object)executorService);
        return executorService.invokeAny(tasks);
    }

    public final <T> T invokeAny(@Nullable Collection<? extends Callable<T>> tasks, long timeout, @Nullable TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutorService executorService = this.exec;
        Intrinsics.checkNotNull((Object)executorService);
        return executorService.invokeAny(tasks, timeout, unit);
    }

    @NotNull
    public final ScheduledFuture<?> schedule(@Nullable Runnable command, long delay, @Nullable TimeUnit unit) {
        ScheduledFuture<?> scheduledFuture = this.scheduleExec.schedule(command, delay, unit);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"scheduleExec.schedule(command, delay, unit)");
        return scheduledFuture;
    }

    @NotNull
    public final <V> ScheduledFuture<V> schedule(@Nullable Callable<V> callable, long delay, @Nullable TimeUnit unit) {
        ScheduledFuture<V> scheduledFuture = this.scheduleExec.schedule(callable, delay, unit);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"scheduleExec.schedule(callable, delay, unit)");
        return scheduledFuture;
    }

    @NotNull
    public final ScheduledFuture<?> scheduleWithFixedRate(@Nullable Runnable command, long initialDelay, long period, @Nullable TimeUnit unit) {
        ScheduledFuture<?> scheduledFuture = this.scheduleExec.scheduleAtFixedRate(command, initialDelay, period, unit);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"scheduleExec.scheduleAtFixedRate(command, initialDelay, period, unit)");
        return scheduledFuture;
    }

    @NotNull
    public final ScheduledFuture<?> scheduleWithFixedDelay(@Nullable Runnable command, long initialDelay, long delay, @Nullable TimeUnit unit) {
        ScheduledFuture<?> scheduledFuture = this.scheduleExec.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"scheduleExec.scheduleWithFixedDelay(command, initialDelay, delay, unit)");
        return scheduledFuture;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/tamsiree/rxkit/RxThreadPoolTool$Type;", "", "(Ljava/lang/String;I)V", "FixedThread", "CachedThread", "SingleThread", "RxKit_release"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type FixedThread = new Type();
        public static final /* enum */ Type CachedThread = new Type();
        public static final /* enum */ Type SingleThread = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            Type[] typeArray = $VALUES;
            return Arrays.copyOf(typeArray, typeArray.length);
        }

        public static Type valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.FixedThread, Type.CachedThread, Type.SingleThread};
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            nArray[Type.FixedThread.ordinal()] = 1;
            nArray[Type.SingleThread.ordinal()] = 2;
            nArray[Type.CachedThread.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

