/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.tamsiree.rxkit.TLog;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.StandardDatabase;
import org.greenrobot.greendao.internal.DaoConfig;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JU\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000426\u0010\u0010\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00130\u00120\u0011\"\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010\u0014JU\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000426\u0010\u0010\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00130\u00120\u0011\"\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010\u0014JM\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e26\u0010\u0010\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00130\u00120\u0011\"\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010\u0018JM\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e26\u0010\u0010\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00130\u00120\u0011\"\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010\u0018J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\nH\u0002JM\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001f26\u0010\u0010\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00130\u00120\u0011\"\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00130\u0012H\u0007\u00a2\u0006\u0002\u0010 JM\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e26\u0010\u0010\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00130\u00120\u0011\"\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00130\u0012H\u0007\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\nH\u0002J]\u0010#\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u000426\u0010\u0010\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00130\u00120\u0011\"\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010&JM\u0010'\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e26\u0010\u0010\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00130\u00120\u0011\"\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010\u0018R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/tamsiree/rxkit/RxMigrationHelper;", "", "()V", "DEBUG", "", "getDEBUG", "()Z", "setDEBUG", "(Z)V", "TAG", "", "createAllTables", "", "db", "Lorg/greenrobot/greendao/database/StandardDatabase;", "ifNotExists", "daoClasses", "", "Ljava/lang/Class;", "Lorg/greenrobot/greendao/AbstractDao;", "(Lorg/greenrobot/greendao/database/StandardDatabase;Z[Ljava/lang/Class;)V", "dropAllTables", "ifExists", "generateNewTablesIfNotExists", "(Lorg/greenrobot/greendao/database/StandardDatabase;[Ljava/lang/Class;)V", "generateTempTables", "getColumns", "", "tableName", "migrate", "sqliteDatabase", "Landroid/database/sqlite/SQLiteDatabase;", "(Landroid/database/sqlite/SQLiteDatabase;[Ljava/lang/Class;)V", "printLog", "info", "reflectMethod", "methodName", "isExists", "(Lorg/greenrobot/greendao/database/StandardDatabase;Ljava/lang/String;Z[Ljava/lang/Class;)V", "restoreData", "RxKit_release"})
public final class RxMigrationHelper {
    @NotNull
    public static final RxMigrationHelper INSTANCE = new RxMigrationHelper();
    private static boolean DEBUG;
    @NotNull
    private static final String TAG = "RxMigrationHelper";

    private RxMigrationHelper() {
    }

    public final boolean getDEBUG() {
        return DEBUG;
    }

    public final void setDEBUG(boolean bl) {
        DEBUG = bl;
    }

    @JvmStatic
    public static final void migrate(@NotNull SQLiteDatabase sqliteDatabase, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        Intrinsics.checkNotNullParameter((Object)sqliteDatabase, (String)"sqliteDatabase");
        Intrinsics.checkNotNullParameter(daoClasses, (String)"daoClasses");
        StandardDatabase db = new StandardDatabase(sqliteDatabase);
        INSTANCE.printLog(Intrinsics.stringPlus((String)"\u3010The Old Database Version\u3011", (Object)sqliteDatabase.getVersion()));
        INSTANCE.printLog("\u3010Generate temp table\u3011start");
        RxMigrationHelper.migrate(db, Arrays.copyOf(daoClasses, daoClasses.length));
    }

    @JvmStatic
    public static final void migrate(@NotNull StandardDatabase db, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter(daoClasses, (String)"daoClasses");
        INSTANCE.generateNewTablesIfNotExists(db, Arrays.copyOf(daoClasses, daoClasses.length));
        INSTANCE.printLog("\u3010Generate temp table\u3011complete");
        INSTANCE.generateTempTables(db, Arrays.copyOf(daoClasses, daoClasses.length));
        INSTANCE.dropAllTables(db, true, Arrays.copyOf(daoClasses, daoClasses.length));
        INSTANCE.createAllTables(db, false, Arrays.copyOf(daoClasses, daoClasses.length));
        INSTANCE.printLog("\u3010Restore data\u3011start");
        INSTANCE.restoreData(db, Arrays.copyOf(daoClasses, daoClasses.length));
        INSTANCE.printLog("\u3010Restore data\u3011complete");
    }

    private final void generateNewTablesIfNotExists(StandardDatabase db, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        this.reflectMethod(db, "createTable", true, Arrays.copyOf(daoClasses, daoClasses.length));
    }

    private final void generateTempTables(StandardDatabase db, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        int n = 0;
        int n2 = daoClasses.length;
        if (n < n2) {
            do {
                int i = n++;
                DaoConfig daoConfig = new DaoConfig((Database)db, daoClasses[i]);
                String tableName = daoConfig.tablename;
                String tempTableName = Intrinsics.stringPlus((String)daoConfig.tablename, (Object)"_TEMP");
                StringBuilder insertTableStringBuilder = new StringBuilder();
                insertTableStringBuilder.append("CREATE TEMP TABLE ").append(tempTableName);
                insertTableStringBuilder.append(" AS SELECT * FROM ").append(tableName).append(";");
                db.execSQL(insertTableStringBuilder.toString());
            } while (n < n2);
        }
    }

    private final void dropAllTables(StandardDatabase db, boolean ifExists, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        this.reflectMethod(db, "dropTable", ifExists, Arrays.copyOf(daoClasses, daoClasses.length));
    }

    private final void createAllTables(StandardDatabase db, boolean ifNotExists, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        this.reflectMethod(db, "createTable", ifNotExists, Arrays.copyOf(daoClasses, daoClasses.length));
    }

    private final void reflectMethod(StandardDatabase db, String methodName, boolean isExists, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        if (daoClasses.length < 1) {
            return;
        }
        try {
            for (Class<AbstractDao<?, ?>> clazz : daoClasses) {
                Class[] classArray = new Class[]{Database.class, Boolean.TYPE};
                Object[] objectArray = clazz.getDeclaredMethod(methodName, classArray);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"cls.getDeclaredMethod(methodName, Database::class.java, Boolean::class.javaPrimitiveType)");
                Object[] method = objectArray;
                objectArray = new Object[]{db, isExists};
                method.invoke(null, objectArray);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private final void restoreData(StandardDatabase db, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        int n = 0;
        int n2 = daoClasses.length;
        if (n < n2) {
            do {
                int i = n++;
                DaoConfig daoConfig = new DaoConfig((Database)db, daoClasses[i]);
                String tableName = daoConfig.tablename;
                String tempTableName = Intrinsics.stringPlus((String)daoConfig.tablename, (Object)"_TEMP");
                List<String> columns = this.getColumns(db, tempTableName);
                ArrayList<String> properties = new ArrayList<String>(columns.size());
                int n3 = 0;
                int n4 = daoConfig.properties.length + -1;
                if (n3 <= n4) {
                    do {
                        int j = n3++;
                        String columnName = daoConfig.properties[j].columnName;
                        if (!columns.contains(columnName)) continue;
                        properties.add(columnName);
                    } while (n3 <= n4);
                }
                if (properties.size() > 0) {
                    String columnSQL = TextUtils.join((CharSequence)",", (Iterable)properties);
                    StringBuilder insertTableStringBuilder = new StringBuilder();
                    insertTableStringBuilder.append("INSERT INTO ").append(tableName).append(" (");
                    insertTableStringBuilder.append(columnSQL);
                    insertTableStringBuilder.append(") SELECT ");
                    insertTableStringBuilder.append(columnSQL);
                    insertTableStringBuilder.append(" FROM ").append(tempTableName).append(";");
                    db.execSQL(insertTableStringBuilder.toString());
                }
                StringBuilder dropTableStringBuilder = new StringBuilder();
                dropTableStringBuilder.append("DROP TABLE ").append(tempTableName);
                db.execSQL(dropTableStringBuilder.toString());
            } while (n < n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<String> getColumns(StandardDatabase db, String tableName) {
        List columns;
        block9: {
            block8: {
                String[] stringArray;
                columns = null;
                String[] cursor = null;
                try {
                    cursor = db.rawQuery("SELECT * FROM " + tableName + " limit 0", null);
                    if (cursor != null && cursor.getColumnCount() > 0) {
                        stringArray = cursor.getColumnNames();
                        columns = Arrays.asList(Arrays.copyOf(stringArray, stringArray.length));
                    }
                    if ((stringArray = cursor) == null) break block8;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block9;
                }
                finally {
                    String[] stringArray2 = cursor;
                    if (stringArray2 != null) {
                        stringArray2.close();
                    }
                    columns = new ArrayList();
                }
                stringArray.close();
            }
            if (columns == null) {
                columns = new ArrayList();
            }
        }
        return columns;
    }

    private final void printLog(String info) {
        if (DEBUG) {
            TLog.d$default(TAG, info, null, 4, null);
        }
    }
}

