/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.LinearGradient;
import android.graphics.MaskFilter;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.ThumbnailUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import android.widget.ImageView;
import androidx.exifinterface.media.ExifInterface;
import com.tamsiree.rxkit.RxDataTool;
import com.tamsiree.rxkit.RxFileTool;
import com.tamsiree.rxkit.RxTool;
import com.tamsiree.rxkit.TLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b#\n\u0002\u0010\u0006\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J*\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0007J\"\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J>\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J$\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007JN\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00182\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\nH\u0007J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0018H\u0007J\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J\u001c\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010 \u001a\u00020!2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010$\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020\u001cH\u0007J\u001a\u0010&\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010%\u001a\u00020\u001cH\u0007J\u0010\u0010&\u001a\u00020!2\u0006\u0010%\u001a\u00020\u001cH\u0007J \u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\nH\u0002J \u0010,\u001a\u00020\n2\u0006\u0010(\u001a\u00020)2\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\nH\u0002J\u0018\u0010/\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0007J<\u00100\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J\u0018\u00103\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u00104\u001a\u00020\u0018H\u0007J$\u00105\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u00106\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J$\u00105\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u00107\u001a\u0002082\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J$\u00109\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010:\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J\"\u0010;\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u00182\u0006\u0010=\u001a\u00020\u0018H\u0007J*\u0010;\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u00182\u0006\u0010=\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0007J\"\u0010;\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\n2\u0006\u0010?\u001a\u00020\nH\u0007J*\u0010;\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\n2\u0006\u0010?\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0002J0\u0010F\u001a\u00020\u00042\u0006\u0010G\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\n2\u0006\u0010I\u001a\u00020\u00062\u0006\u0010J\u001a\u00020\n2\u0006\u0010K\u001a\u00020\nH\u0007J\u0018\u0010L\u001a\u00020\n2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u0018H\u0007J\u0010\u0010L\u001a\u00020\n2\u0006\u0010O\u001a\u00020\u0018H\u0007J\u0018\u0010P\u001a\u00020\n2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u0018H\u0007J\u0010\u0010P\u001a\u00020\n2\u0006\u0010O\u001a\u00020\u0018H\u0007J$\u0010Q\u001a\u00020A2\b\u0010R\u001a\u0004\u0018\u00010S2\u0006\u0010T\u001a\u00020\u00042\b\u0010U\u001a\u0004\u0018\u00010VH\u0007J\u0010\u0010W\u001a\u00020\u00042\u0006\u0010X\u001a\u00020!H\u0007J\u001a\u0010Y\u001a\u00020\u001c2\u0006\u0010X\u001a\u00020!2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J\u0010\u0010Z\u001a\u00020\u00182\u0006\u0010[\u001a\u00020\nH\u0007J\u001c\u0010\\\u001a\u0004\u0018\u00010\u00042\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010]\u001a\u00020\nH\u0007J,\u0010\\\u001a\u0004\u0018\u00010\u00042\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010]\u001a\u00020\n2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\nH\u0007J\u0014\u0010\\\u001a\u0004\u0018\u00010\u00042\b\u0010^\u001a\u0004\u0018\u00010_H\u0007J$\u0010\\\u001a\u0004\u0018\u00010\u00042\b\u0010^\u001a\u0004\u0018\u00010_2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\nH\u0007J\u0014\u0010\\\u001a\u0004\u0018\u00010\u00042\b\u0010`\u001a\u0004\u0018\u00010aH\u0007J$\u0010\\\u001a\u0004\u0018\u00010\u00042\b\u0010`\u001a\u0004\u0018\u00010a2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\nH\u0007J\u0014\u0010\\\u001a\u0004\u0018\u00010\u00042\b\u0010b\u001a\u0004\u0018\u00010CH\u0007J$\u0010\\\u001a\u0004\u0018\u00010\u00042\b\u0010b\u001a\u0004\u0018\u00010C2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\nH\u0007J\u001a\u0010\\\u001a\u0004\u0018\u00010\u00042\u0006\u0010c\u001a\u00020\u001c2\u0006\u0010d\u001a\u00020\nH\u0007J*\u0010\\\u001a\u0004\u0018\u00010\u00042\u0006\u0010c\u001a\u00020\u001c2\u0006\u0010d\u001a\u00020\n2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\nH\u0007J\u0012\u0010\\\u001a\u0004\u0018\u00010\u00042\u0006\u0010e\u001a\u00020\nH\u0007J\"\u0010\\\u001a\u0004\u0018\u00010\u00042\u0006\u0010e\u001a\u00020\n2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\nH\u0007J\u0014\u0010\\\u001a\u0004\u0018\u00010\u00042\b\u0010f\u001a\u0004\u0018\u00010\u0006H\u0007J$\u0010\\\u001a\u0004\u0018\u00010\u00042\b\u0010f\u001a\u0004\u0018\u00010\u00062\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\nH\u0007J\u0014\u0010g\u001a\u0004\u0018\u00010\u00042\b\u0010h\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010i\u001a\u00020\n2\u0006\u0010j\u001a\u00020\nH\u0007J\u0010\u0010k\u001a\u00020\u00182\u0006\u0010l\u001a\u00020NH\u0007J(\u0010m\u001a\u00020\u00042\u0006\u0010n\u001a\u00020o2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010p\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0018\u0010q\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010r\u001a\u00020\rH\u0007J\u0014\u0010s\u001a\u0004\u0018\u00010\u00062\b\u0010^\u001a\u0004\u0018\u00010_H\u0007J\u0014\u0010s\u001a\u0004\u0018\u00010\u00062\b\u0010b\u001a\u0004\u0018\u00010CH\u0007J\u0012\u0010s\u001a\u0004\u0018\u00010\u00062\u0006\u0010%\u001a\u00020\u001cH\u0007J\u0014\u0010s\u001a\u0004\u0018\u00010\u00062\b\u0010f\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010t\u001a\u00020\n2\u0006\u0010f\u001a\u00020\u0006H\u0007J\u0010\u0010u\u001a\u00020v2\u0006\u0010l\u001a\u00020NH\u0007J\"\u0010w\u001a\u00020\u00042\b\u0010G\u001a\u0004\u0018\u00010\u00042\u0006\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\nH\u0007J\u001a\u0010w\u001a\u0004\u0018\u00010\u00042\u0006\u0010f\u001a\u00020\u00062\u0006\u0010x\u001a\u00020\nH\u0007J\u0010\u0010y\u001a\u00020\r2\u0006\u0010z\u001a\u00020\u001cH\u0007J\u0012\u0010{\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010|\u001a\u00020\r2\u0006\u0010z\u001a\u00020\u001cH\u0007J\u0012\u0010}\u001a\u00020\r2\b\u0010^\u001a\u0004\u0018\u00010_H\u0007J\u0010\u0010}\u001a\u00020\r2\u0006\u0010f\u001a\u00020\u0006H\u0007J\u0010\u0010~\u001a\u00020\r2\u0006\u0010z\u001a\u00020\u001cH\u0007J\u0010\u0010\u007f\u001a\u00020\r2\u0006\u0010z\u001a\u00020\u001cH\u0007J\u0011\u0010\u0080\u0001\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\nH\u0007J\u0012\u0010\u0081\u0001\u001a\u00020\n2\u0007\u0010\u0082\u0001\u001a\u00020\u0018H\u0007J\u001a\u0010\u0083\u0001\u001a\u00020\n2\u0006\u0010M\u001a\u00020N2\u0007\u0010\u0082\u0001\u001a\u00020\u0018H\u0007J\u0012\u0010\u0083\u0001\u001a\u00020\n2\u0007\u0010\u0082\u0001\u001a\u00020\u0018H\u0007J\u0012\u0010\u0084\u0001\u001a\u00020\n2\u0007\u0010\u0082\u0001\u001a\u00020\u0018H\u0007J8\u0010\u0085\u0001\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\u0007\u0010\u0086\u0001\u001a\u00020\n2\u0007\u0010\u0087\u0001\u001a\u00020\u00182\u0007\u0010\u0088\u0001\u001a\u00020\u00182\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J/\u0010\u0089\u0001\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00042\b\u0010^\u001a\u0004\u0018\u00010_2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J%\u0010\u0089\u0001\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00042\b\u0010f\u001a\u0004\u0018\u00010\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J-\u0010\u0089\u0001\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00042\b\u0010f\u001a\u0004\u0018\u00010\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\f\u001a\u00020\rH\u0007J-\u0010\u008a\u0001\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u00182\u0006\u0010=\u001a\u00020\u00182\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J-\u0010\u008a\u0001\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\n2\u0006\u0010?\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J%\u0010\u008b\u0001\u001a\u00020\u00042\t\u0010\u008c\u0001\u001a\u0004\u0018\u00010#2\u0006\u0010e\u001a\u00020\n2\u0007\u0010\u008d\u0001\u001a\u00020\nH\u0007J-\u0010\u008e\u0001\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\u0007\u0010\u008f\u0001\u001a\u00020\u00182\u0007\u0010\u0090\u0001\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0007J7\u0010\u008e\u0001\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\u0007\u0010\u008f\u0001\u001a\u00020\u00182\u0007\u0010\u0090\u0001\u001a\u00020\u00182\u0007\u0010\u0087\u0001\u001a\u00020\u00182\u0007\u0010\u0088\u0001\u001a\u00020\u0018H\u0007JE\u0010\u008e\u0001\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\u0007\u0010\u008f\u0001\u001a\u00020\u00182\u0007\u0010\u0090\u0001\u001a\u00020\u00182\t\b\u0002\u0010\u0087\u0001\u001a\u00020\u00182\t\b\u0002\u0010\u0088\u0001\u001a\u00020\u00182\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u0091\u0001\u001a\u00020\n2\u0007\u0010\u0092\u0001\u001a\u00020\u0018H\u0007J\u001b\u0010\u0093\u0001\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007J\u0013\u0010\u0093\u0001\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0007J\u001d\u0010\u0094\u0001\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J\u001d\u0010\u0095\u0001\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J'\u0010\u0096\u0001\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010p\u001a\u00020\u00182\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J!\u0010\u0097\u0001\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\nH\u0007J$\u0010\u0098\u0001\u001a\u00020\u00042\u0007\u0010\u0099\u0001\u001a\u00020\u00042\u0007\u0010>\u001a\u00030\u009a\u00012\u0007\u0010?\u001a\u00030\u009a\u0001H\u0007\u00a8\u0006\u009b\u0001"}, d2={"Lcom/tamsiree/rxkit/RxImageTool;", "", "()V", "GetLocalOrNetBitmap", "Landroid/graphics/Bitmap;", "url", "", "addFrame", "src", "borderWidth", "", "color", "recycle", "", "addImageWatermark", "watermark", "x", "y", "alpha", "addReflection", "reflectionHeight", "addTextWatermark", "content", "textSize", "", "adjustAlpha", "alphaValueAsInt", "bitmap2Bytes", "", "bitmap", "format", "Landroid/graphics/Bitmap$CompressFormat;", "bitmap2Drawable", "Landroid/graphics/drawable/Drawable;", "res", "Landroid/content/res/Resources;", "bytes2Bitmap", "bytes", "bytes2Drawable", "calculateInSampleSize", "options", "Landroid/graphics/BitmapFactory$Options;", "maxWidth", "maxHeight", "calculateInSampleSize2", "reqWidth", "reqHeight", "changeColorAlpha", "clip", "width", "height", "colorAtLightness", "lightness", "compressByQuality", "quality", "maxByteSize", "", "compressBySampleSize", "sampleSize", "compressByScale", "scaleWidth", "scaleHeight", "newWidth", "newHeight", "copy", "", "in", "Ljava/io/InputStream;", "out", "Ljava/io/OutputStream;", "createTextImage", "source", "txtSize", "innerTxt", "textColor", "textBackgroundColor", "dip2px", "mContext", "Landroid/content/Context;", "dpValue", "dp2px", "drawNinePath", "c", "Landroid/graphics/Canvas;", "bmp", "rect", "Landroid/graphics/Rect;", "drawable2Bitmap", "drawable", "drawable2Bytes", "getAlphaPercent", "argb", "getBitmap", "id", "file", "Ljava/io/File;", "fd", "Ljava/io/FileDescriptor;", "is", "data", "offset", "resId", "filePath", "getBitmapFromNet", "imgUrl", "getColorByInt", "colorInt", "getDensity", "context", "getDropShadow", "iv", "Landroid/widget/ImageView;", "radius", "getHexString", "showAlpha", "getImageType", "getRotateDegree", "getScreenResolution", "", "getThumb", "kind", "isBMP", "b", "isEmptyBitmap", "isGIF", "isImage", "isJPEG", "isPNG", "lightnessOfColor", "px2dip", "pxValue", "px2dp", "px2sp", "rotate", "degrees", "px", "py", "save", "scale", "scaleImage", "resources", "maxSize", "skew", "kx", "ky", "sp2px", "spValue", "toAlpha", "toGray", "toRound", "toRoundCorner", "zoomBitmap", "zoomImage", "bgimage", "", "RxKit_release"})
public final class RxImageTool {
    @NotNull
    public static final RxImageTool INSTANCE = new RxImageTool();

    private RxImageTool() {
    }

    @JvmStatic
    public static final int dip2px(float dpValue) {
        return RxImageTool.dp2px(dpValue);
    }

    @JvmStatic
    public static final int dip2px(@NotNull Context mContext, float dpValue) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        return RxImageTool.dp2px(mContext, dpValue);
    }

    @JvmStatic
    public static final int dp2px(float dpValue) {
        return RxImageTool.dp2px(RxTool.INSTANCE.getContext(), dpValue);
    }

    @JvmStatic
    public static final int dp2px(@NotNull Context mContext, float dpValue) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        float scale = mContext.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    @JvmStatic
    public static final int px2dip(float pxValue) {
        return RxImageTool.px2dp(pxValue);
    }

    @JvmStatic
    public static final int px2dp(float pxValue) {
        return RxImageTool.px2dp(RxTool.INSTANCE.getContext(), pxValue);
    }

    @JvmStatic
    public static final int px2dp(@NotNull Context mContext, float pxValue) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        float scale = mContext.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    @JvmStatic
    public static final int sp2px(float spValue) {
        float fontScale = RxTool.INSTANCE.getContext().getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    @JvmStatic
    public static final int px2sp(float pxValue) {
        float fontScale = RxTool.INSTANCE.getContext().getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap GetLocalOrNetBitmap(@Nullable String url) {
        Bitmap bitmap;
        Bitmap bitmap2 = null;
        InputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new BufferedInputStream(new URL(url).openStream(), 1024);
            ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
            out = new BufferedOutputStream(dataStream, 1024);
            INSTANCE.copy(in, out);
            out.flush();
            byte[] data = dataStream.toByteArray();
            bitmap2 = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
            data = null;
            bitmap = bitmap2;
        }
        catch (IOException e) {
            e.printStackTrace();
            bitmap = null;
        }
        return bitmap;
    }

    private final void copy(InputStream in, OutputStream out) throws IOException {
        byte[] b = new byte[1024];
        int read = 0;
        while (true) {
            int n = in.read(b);
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            read = it;
            if (n == -1) break;
            out.write(b, 0, read);
        }
    }

    @JvmStatic
    public static final int getColorByInt(int colorInt) {
        return colorInt | 0xFF000000;
    }

    @JvmStatic
    public static final int changeColorAlpha(int color, int alpha) {
        int red = Color.red((int)color);
        int green = Color.green((int)color);
        int blue = Color.blue((int)color);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    @JvmStatic
    public static final float getAlphaPercent(int argb) {
        return (float)Color.alpha((int)argb) / 255.0f;
    }

    @JvmStatic
    public static final int alphaValueAsInt(float alpha) {
        return Math.round(alpha * (float)255);
    }

    @JvmStatic
    public static final int adjustAlpha(float alpha, int color) {
        return RxImageTool.alphaValueAsInt(alpha) << 24 | 0xFFFFFF & color;
    }

    @JvmStatic
    public static final int colorAtLightness(int color, float lightness) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color, (float[])hsv);
        hsv[2] = lightness;
        return Color.HSVToColor((float[])hsv);
    }

    @JvmStatic
    public static final float lightnessOfColor(int color) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color, (float[])hsv);
        return hsv[2];
    }

    @JvmStatic
    @NotNull
    public static final String getHexString(int color, boolean showAlpha) {
        int base = showAlpha ? -1 : 0xFFFFFF;
        String format = showAlpha ? "#%08X" : "#%06X";
        Object object = StringCompanionObject.INSTANCE;
        Object object2 = new Object[]{base & color};
        boolean bl = false;
        String string = String.format(format, Arrays.copyOf(object2, ((Object[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
        object = string;
        object2 = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"ROOT");
        bl = false;
        Object object3 = object;
        boolean bl2 = false;
        Object object4 = object3;
        if (object4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = ((String)object4).toUpperCase((Locale)object2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toUpperCase(locale)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final byte[] bitmap2Bytes(@NotNull Bitmap bitmap, @Nullable Bitmap.CompressFormat format) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(format, 100, (OutputStream)baos);
        byte[] byArray = baos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"baos.toByteArray()");
        return byArray;
    }

    @JvmStatic
    @Nullable
    public static final Bitmap bytes2Bitmap(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return bytes.length != 0 ? BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length) : (Bitmap)null;
    }

    @JvmStatic
    @NotNull
    public static final Bitmap drawable2Bitmap(@NotNull Drawable drawable) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        int w = drawable.getIntrinsicWidth();
        int h = drawable.getIntrinsicHeight();
        Bitmap.Config config = drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, w, h);
        drawable.draw(canvas);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return bitmap;
    }

    @JvmStatic
    @NotNull
    public static final Drawable bitmap2Drawable(@Nullable Resources res, @Nullable Bitmap bitmap) {
        return (Drawable)new BitmapDrawable(res, bitmap);
    }

    @JvmStatic
    @NotNull
    public static final Drawable bitmap2Drawable(@Nullable Bitmap bitmap) {
        return (Drawable)new BitmapDrawable(bitmap);
    }

    @JvmStatic
    @NotNull
    public static final byte[] drawable2Bytes(@NotNull Drawable drawable, @Nullable Bitmap.CompressFormat format) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Bitmap bitmap = RxImageTool.drawable2Bitmap(drawable);
        return RxImageTool.bitmap2Bytes(bitmap, format);
    }

    @JvmStatic
    @NotNull
    public static final Drawable bytes2Drawable(@Nullable Resources res, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Bitmap bitmap = RxImageTool.bytes2Bitmap(bytes);
        return RxImageTool.bitmap2Drawable(res, bitmap);
    }

    @JvmStatic
    @NotNull
    public static final Drawable bytes2Drawable(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Bitmap bitmap = RxImageTool.bytes2Bitmap(bytes);
        return RxImageTool.bitmap2Drawable(bitmap);
    }

    private final int calculateInSampleSize(BitmapFactory.Options options, int maxWidth, int maxHeight) {
        if (maxWidth == 0 || maxHeight == 0) {
            return 1;
        }
        int height = 0;
        height = options.outHeight;
        int width = 0;
        width = options.outWidth;
        int inSampleSize = 1;
        while (true) {
            int n = 1;
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            if ((height >>= it) < maxHeight) break;
            n = 1;
            bl = false;
            bl2 = false;
            it = n;
            boolean bl4 = false;
            if ((width >>= it) < maxWidth) break;
            inSampleSize <<= 1;
        }
        return inSampleSize;
    }

    private final int calculateInSampleSize2(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int n;
        int reqWidth2 = reqWidth;
        int reqHeight2 = reqHeight;
        int height = options.outHeight;
        int width = options.outWidth;
        int MIN_WIDTH = 100;
        int inSampleSize = 1;
        if (width < MIN_WIDTH) {
            n = inSampleSize;
        } else {
            int heightRatio = 0;
            if (width > height && reqWidth2 < reqHeight2 || width < height && reqWidth2 > reqHeight2) {
                heightRatio = reqWidth2;
                reqWidth2 = reqHeight2;
                reqHeight2 = heightRatio;
            }
            if (height > reqHeight2 || width > reqWidth2) {
                heightRatio = Math.round((float)height / (float)reqHeight2);
                int widthRatio = Math.round((float)width / (float)reqWidth2);
                inSampleSize = Math.max(heightRatio, widthRatio);
            }
            n = inSampleSize;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final Bitmap getBitmap(@Nullable File file) {
        Bitmap bitmap;
        if (file == null) {
            return null;
        }
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            bitmap = BitmapFactory.decodeStream((InputStream)is);
        }
        catch (FileNotFoundException e) {
            try {
                e.printStackTrace();
                bitmap = null;
            }
            catch (Throwable throwable) {
                Closeable[] closeableArray = new Closeable[]{is};
                RxFileTool.Companion.closeIO(closeableArray);
                throw throwable;
            }
            Closeable[] closeableArray = new Closeable[]{is};
            RxFileTool.Companion.closeIO(closeableArray);
        }
        Closeable[] closeableArray = new Closeable[]{is};
        RxFileTool.Companion.closeIO(closeableArray);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final Bitmap getBitmap(@Nullable File file, int maxWidth, int maxHeight) {
        Bitmap bitmap;
        if (file == null) {
            return null;
        }
        InputStream is = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            is = new BufferedInputStream(new FileInputStream(file));
            BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            options.inSampleSize = INSTANCE.calculateInSampleSize(options, maxWidth, maxHeight);
            options.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
        }
        catch (FileNotFoundException e) {
            try {
                e.printStackTrace();
                bitmap = null;
            }
            catch (Throwable throwable) {
                Closeable[] closeableArray = new Closeable[]{is};
                RxFileTool.Companion.closeIO(closeableArray);
                throw throwable;
            }
            Closeable[] closeableArray = new Closeable[]{is};
            RxFileTool.Companion.closeIO(closeableArray);
        }
        Closeable[] closeableArray = new Closeable[]{is};
        RxFileTool.Companion.closeIO(closeableArray);
        return bitmap;
    }

    @JvmStatic
    @Nullable
    public static final Bitmap getBitmap(@Nullable String filePath) {
        return RxDataTool.Companion.isNullString(filePath) ? (Bitmap)null : BitmapFactory.decodeFile((String)filePath);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap getBitmap(@Nullable String filePath, int maxWidth, int maxHeight) {
        if (RxDataTool.Companion.isNullString(filePath)) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        options.inSampleSize = INSTANCE.calculateInSampleSize(options, maxWidth, maxHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap getBitmap(@Nullable InputStream is, int maxWidth, int maxHeight) {
        if (is == null) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
        options.inSampleSize = INSTANCE.calculateInSampleSize(options, maxWidth, maxHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap getBitmap(@NotNull byte[] data, int offset, int maxWidth, int maxHeight) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.length == 0) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)data.length, (BitmapFactory.Options)options);
        options.inSampleSize = INSTANCE.calculateInSampleSize(options, maxWidth, maxHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)data.length, (BitmapFactory.Options)options);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap getBitmap(int resId) {
        InputStream inputStream = RxTool.INSTANCE.getContext().getResources().openRawResource(resId);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"RxTool.getContext().resources.openRawResource(resId)");
        InputStream is = inputStream;
        return BitmapFactory.decodeStream((InputStream)is);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap getBitmap(int resId, int maxWidth, int maxHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        InputStream inputStream = RxTool.INSTANCE.getContext().getResources().openRawResource(resId);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"RxTool.getContext().resources.openRawResource(resId)");
        InputStream is = inputStream;
        BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
        options.inSampleSize = INSTANCE.calculateInSampleSize(options, maxWidth, maxHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap getBitmap(@Nullable Resources res, int id) {
        return res == null ? (Bitmap)null : BitmapFactory.decodeResource((Resources)res, (int)id);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap getBitmap(@Nullable Resources res, int id, int maxWidth, int maxHeight) {
        if (res == null) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)res, (int)id, (BitmapFactory.Options)options);
        options.inSampleSize = INSTANCE.calculateInSampleSize(options, maxWidth, maxHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)res, (int)id, (BitmapFactory.Options)options);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap getBitmap(@Nullable FileDescriptor fd) {
        return fd == null ? (Bitmap)null : BitmapFactory.decodeFileDescriptor((FileDescriptor)fd);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap getBitmap(@Nullable FileDescriptor fd, int maxWidth, int maxHeight) {
        if (fd == null) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
        options.inSampleSize = INSTANCE.calculateInSampleSize(options, maxWidth, maxHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap scale(@NotNull Bitmap src, int newWidth, int newHeight, boolean recycle) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (RxImageTool.isEmptyBitmap(src)) {
            return null;
        }
        Bitmap ret = Bitmap.createScaledBitmap((Bitmap)src, (int)newWidth, (int)newHeight, (boolean)true);
        if (recycle && !src.isRecycled()) {
            src.recycle();
        }
        return ret;
    }

    public static /* synthetic */ Bitmap scale$default(Bitmap bitmap, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 8) != 0) {
            bl = false;
        }
        return RxImageTool.scale(bitmap, n, n2, bl);
    }

    @JvmOverloads
    @Nullable
    public final Bitmap scale(@NotNull Bitmap src, float scaleWidth, float scaleHeight, boolean recycle) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (RxImageTool.isEmptyBitmap(src)) {
            return null;
        }
        Matrix matrix = new Matrix();
        matrix.setScale(scaleWidth, scaleHeight);
        Bitmap ret = Bitmap.createBitmap((Bitmap)src, (int)0, (int)0, (int)src.getWidth(), (int)src.getHeight(), (Matrix)matrix, (boolean)true);
        if (recycle && !src.isRecycled()) {
            src.recycle();
        }
        return ret;
    }

    public static /* synthetic */ Bitmap scale$default(RxImageTool rxImageTool, Bitmap bitmap, float f, float f2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return rxImageTool.scale(bitmap, f, f2, bl);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap clip(@NotNull Bitmap src, int x, int y, int width, int height, boolean recycle) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (RxImageTool.isEmptyBitmap(src)) {
            return null;
        }
        Bitmap ret = Bitmap.createBitmap((Bitmap)src, (int)x, (int)y, (int)width, (int)height);
        if (recycle && !src.isRecycled()) {
            src.recycle();
        }
        return ret;
    }

    public static /* synthetic */ Bitmap clip$default(Bitmap bitmap, int n, int n2, int n3, int n4, boolean bl, int n5, Object object) {
        if ((n5 & 0x20) != 0) {
            bl = false;
        }
        return RxImageTool.clip(bitmap, n, n2, n3, n4, bl);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap skew(@NotNull Bitmap src, float kx, float ky, boolean recycle) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return RxImageTool.skew(src, kx, ky, 0.0f, 0.0f, recycle);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap skew(@NotNull Bitmap src, float kx, float ky, float px, float py) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return RxImageTool.skew(src, kx, ky, 0.0f, 0.0f, false);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap skew(@NotNull Bitmap src, float kx, float ky, float px, float py, boolean recycle) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (RxImageTool.isEmptyBitmap(src)) {
            return null;
        }
        Matrix matrix = new Matrix();
        matrix.setSkew(kx, ky, px, py);
        Bitmap ret = Bitmap.createBitmap((Bitmap)src, (int)0, (int)0, (int)src.getWidth(), (int)src.getHeight(), (Matrix)matrix, (boolean)true);
        if (recycle && !src.isRecycled()) {
            src.recycle();
        }
        return ret;
    }

    public static /* synthetic */ Bitmap skew$default(Bitmap bitmap, float f, float f2, float f3, float f4, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            f3 = 0.0f;
        }
        if ((n & 0x10) != 0) {
            f4 = 0.0f;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return RxImageTool.skew(bitmap, f, f2, f3, f4, bl);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap rotate(@NotNull Bitmap src, int degrees, float px, float py, boolean recycle) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (RxImageTool.isEmptyBitmap(src)) {
            return null;
        }
        if (degrees == 0) {
            return src;
        }
        Matrix matrix = new Matrix();
        matrix.setRotate((float)degrees, px, py);
        Bitmap ret = Bitmap.createBitmap((Bitmap)src, (int)0, (int)0, (int)src.getWidth(), (int)src.getHeight(), (Matrix)matrix, (boolean)true);
        if (recycle && !src.isRecycled()) {
            src.recycle();
        }
        return ret;
    }

    public static /* synthetic */ Bitmap rotate$default(Bitmap bitmap, int n, float f, float f2, boolean bl, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        return RxImageTool.rotate(bitmap, n, f, f2, bl);
    }

    @JvmStatic
    public static final int getRotateDegree(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        int degree = 0;
        try {
            int n;
            int orientation;
            ExifInterface exifInterface = new ExifInterface(filePath);
            int n2 = orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (n2) {
                case 6: {
                    n = 90;
                    break;
                }
                case 3: {
                    n = 180;
                    break;
                }
                case 8: {
                    n = 270;
                    break;
                }
                default: {
                    n = 90;
                }
            }
            degree = n;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap toRound(@NotNull Bitmap src, boolean recycle) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (RxImageTool.isEmptyBitmap(src)) {
            return null;
        }
        int width = src.getWidth();
        int height = src.getHeight();
        int radius = Math.min(width, height) >> 1;
        Bitmap ret = src.copy(src.getConfig(), true);
        Paint paint = new Paint();
        Canvas canvas = new Canvas(ret);
        Rect rect = new Rect(0, 0, width, height);
        paint.setAntiAlias(true);
        paint.setColor(0);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawARGB(0, 0, 0, 0);
        canvas.drawCircle((float)(width >> 1), (float)(height >> 1), (float)radius, paint);
        canvas.drawBitmap(src, rect, rect, paint);
        if (recycle && !src.isRecycled()) {
            src.recycle();
        }
        return ret;
    }

    public static /* synthetic */ Bitmap toRound$default(Bitmap bitmap, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return RxImageTool.toRound(bitmap, bl);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap toRoundCorner(@Nullable Bitmap src, float radius, boolean recycle) {
        if (src == null) {
            return null;
        }
        int width = src.getWidth();
        int height = src.getHeight();
        Bitmap ret = src.copy(src.getConfig(), true);
        BitmapShader bitmapShader = new BitmapShader(src, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        Paint paint = new Paint();
        Canvas canvas = new Canvas(ret);
        RectF rectf = new RectF(0.0f, 0.0f, (float)width, (float)height);
        paint.setAntiAlias(true);
        paint.setShader((Shader)bitmapShader);
        canvas.drawRoundRect(rectf, radius, radius, paint);
        if (recycle && !src.isRecycled()) {
            src.recycle();
        }
        return ret;
    }

    public static /* synthetic */ Bitmap toRoundCorner$default(Bitmap bitmap, float f, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return RxImageTool.toRoundCorner(bitmap, f, bl);
    }

    @JvmStatic
    @NotNull
    public static final Bitmap addFrame(@Nullable Bitmap src, int borderWidth, int color) {
        return RxImageTool.addFrame(src, borderWidth, color);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap addFrame(@NotNull Bitmap src, int borderWidth, int color, boolean recycle) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (RxImageTool.isEmptyBitmap(src)) {
            return null;
        }
        int newWidth = src.getWidth() + borderWidth >> 1;
        int newHeight = src.getHeight() + borderWidth >> 1;
        Bitmap ret = Bitmap.createBitmap((int)newWidth, (int)newHeight, (Bitmap.Config)src.getConfig());
        Canvas canvas = new Canvas(ret);
        Rect rect = canvas.getClipBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"canvas.clipBounds");
        Rect rec = rect;
        Paint paint = new Paint();
        paint.setColor(color);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth((float)borderWidth);
        canvas.drawRect(rec, paint);
        canvas.drawBitmap(src, (float)borderWidth, (float)borderWidth, null);
        if (recycle && !src.isRecycled()) {
            src.recycle();
        }
        return ret;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap addReflection(@NotNull Bitmap src, int reflectionHeight, boolean recycle) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (RxImageTool.isEmptyBitmap(src)) {
            return null;
        }
        boolean REFLECTION_GAP = false;
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        if (srcWidth == 0 || srcHeight == 0) {
            return null;
        }
        Matrix matrix = new Matrix();
        matrix.preScale(1.0f, -1.0f);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)src, (int)0, (int)(srcHeight - reflectionHeight), (int)srcWidth, (int)reflectionHeight, (Matrix)matrix, (boolean)false);
        if (bitmap == null) {
            return null;
        }
        Bitmap reflectionBitmap = bitmap;
        Bitmap ret = Bitmap.createBitmap((int)srcWidth, (int)(srcHeight + reflectionHeight), (Bitmap.Config)src.getConfig());
        Canvas canvas = new Canvas(ret);
        canvas.drawBitmap(src, 0.0f, 0.0f, null);
        canvas.drawBitmap(reflectionBitmap, 0.0f, (float)srcHeight + (float)REFLECTION_GAP, null);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        LinearGradient shader = new LinearGradient(0.0f, (float)srcHeight * 1.0f, 0.0f, (float)ret.getHeight() + (float)REFLECTION_GAP * 1.0f, 0x70FFFFFF, 0xFFFFFF, Shader.TileMode.MIRROR);
        paint.setShader((Shader)shader);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        canvas.save();
        canvas.drawRect(0.0f, (float)srcHeight, (float)srcWidth, (float)ret.getHeight() + (float)REFLECTION_GAP, paint);
        canvas.restore();
        if (!reflectionBitmap.isRecycled()) {
            reflectionBitmap.recycle();
        }
        if (recycle && !src.isRecycled()) {
            src.recycle();
        }
        return ret;
    }

    public static /* synthetic */ Bitmap addReflection$default(Bitmap bitmap, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return RxImageTool.addReflection(bitmap, n, bl);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap addTextWatermark(@NotNull Bitmap src, @Nullable String content, int textSize, int color, int alpha, float x, float y, boolean recycle) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (RxImageTool.isEmptyBitmap(src) || content == null) {
            return null;
        }
        Bitmap ret = src.copy(src.getConfig(), true);
        Paint paint = new Paint(1);
        Canvas canvas = new Canvas(ret);
        paint.setAlpha(alpha);
        paint.setColor(color);
        paint.setTextSize((float)textSize);
        Rect bounds = new Rect();
        paint.getTextBounds(content, 0, content.length(), bounds);
        canvas.drawText(content, x, y, paint);
        if (recycle && !src.isRecycled()) {
            src.recycle();
        }
        return ret;
    }

    public static /* synthetic */ Bitmap addTextWatermark$default(Bitmap bitmap, String string, int n, int n2, int n3, float f, float f2, boolean bl, int n4, Object object) {
        if ((n4 & 0x80) != 0) {
            bl = false;
        }
        return RxImageTool.addTextWatermark(bitmap, string, n, n2, n3, f, f2, bl);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap addImageWatermark(@NotNull Bitmap src, @Nullable Bitmap watermark, int x, int y, int alpha, boolean recycle) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (RxImageTool.isEmptyBitmap(src)) {
            return null;
        }
        Bitmap ret = src.copy(src.getConfig(), true);
        if (!RxImageTool.isEmptyBitmap(watermark)) {
            Paint paint = new Paint(1);
            Canvas canvas = new Canvas(ret);
            paint.setAlpha(alpha);
            Intrinsics.checkNotNull((Object)watermark);
            canvas.drawBitmap(watermark, (float)x, (float)y, paint);
        }
        if (recycle && !src.isRecycled()) {
            src.recycle();
        }
        return ret;
    }

    public static /* synthetic */ Bitmap addImageWatermark$default(Bitmap bitmap, Bitmap bitmap2, int n, int n2, int n3, boolean bl, int n4, Object object) {
        if ((n4 & 0x20) != 0) {
            bl = false;
        }
        return RxImageTool.addImageWatermark(bitmap, bitmap2, n, n2, n3, bl);
    }

    @JvmStatic
    @NotNull
    public static final Bitmap toAlpha(@Nullable Bitmap src) {
        return RxImageTool.toAlpha(src);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap toAlpha(@NotNull Bitmap src, boolean recycle) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (RxImageTool.isEmptyBitmap(src)) {
            return null;
        }
        Bitmap ret = src.extractAlpha();
        if (recycle && !src.isRecycled()) {
            src.recycle();
        }
        return ret;
    }

    private final Bitmap getDropShadow(ImageView iv, Bitmap src, float radius, int color) {
        Paint paint = new Paint(1);
        paint.setColor(color);
        int width = src.getWidth();
        int height = src.getHeight();
        Bitmap dest = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(dest);
        Bitmap alpha = src.extractAlpha();
        canvas.drawBitmap(alpha, 0.0f, 0.0f, paint);
        BlurMaskFilter filter = new BlurMaskFilter(radius, BlurMaskFilter.Blur.OUTER);
        paint.setMaskFilter((MaskFilter)filter);
        canvas.drawBitmap(alpha, 0.0f, 0.0f, paint);
        iv.setImageBitmap(dest);
        Intrinsics.checkNotNullExpressionValue((Object)dest, (String)"dest");
        return dest;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap toGray(@NotNull Bitmap src, boolean recycle) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (RxImageTool.isEmptyBitmap(src)) {
            return null;
        }
        Bitmap grayBitmap = Bitmap.createBitmap((int)src.getWidth(), (int)src.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(grayBitmap);
        Paint paint = new Paint();
        ColorMatrix colorMatrix = new ColorMatrix();
        colorMatrix.setSaturation(0.0f);
        ColorMatrixColorFilter colorMatrixColorFilter = new ColorMatrixColorFilter(colorMatrix);
        paint.setColorFilter((ColorFilter)colorMatrixColorFilter);
        canvas.drawBitmap(src, 0.0f, 0.0f, paint);
        if (recycle && !src.isRecycled()) {
            src.recycle();
        }
        return grayBitmap;
    }

    public static /* synthetic */ Bitmap toGray$default(Bitmap bitmap, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return RxImageTool.toGray(bitmap, bl);
    }

    @JvmStatic
    public static final boolean save(@NotNull Bitmap src, @Nullable String filePath, @Nullable Bitmap.CompressFormat format) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return RxImageTool.save(src, RxFileTool.Companion.getFileByPath(filePath), format, false);
    }

    @JvmStatic
    public static final boolean save(@NotNull Bitmap src, @Nullable String filePath, @Nullable Bitmap.CompressFormat format, boolean recycle) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return RxImageTool.save(src, RxFileTool.Companion.getFileByPath(filePath), format, recycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @JvmOverloads
    public static final boolean save(@NotNull Bitmap src, @Nullable File file, @Nullable Bitmap.CompressFormat format, boolean recycle) {
        boolean ret;
        OutputStream os;
        block5: {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            if (RxImageTool.isEmptyBitmap(src) || !RxFileTool.Companion.createOrExistsFile(file)) {
                return false;
            }
            String string = src.getWidth() + ", " + src.getHeight();
            boolean bl = false;
            System.out.println((Object)string);
            os = null;
            ret = false;
            try {
                os = new BufferedOutputStream(new FileOutputStream(file));
                ret = src.compress(format, 100, os);
                if (!recycle || src.isRecycled()) break block5;
                src.recycle();
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Closeable[] closeableArray = new Closeable[]{os};
                    RxFileTool.Companion.closeIO(closeableArray);
                    throw throwable;
                }
                Closeable[] closeableArray = new Closeable[]{os};
                RxFileTool.Companion.closeIO(closeableArray);
            }
        }
        Closeable[] closeableArray = new Closeable[]{os};
        RxFileTool.Companion.closeIO(closeableArray);
        return ret;
    }

    public static /* synthetic */ boolean save$default(Bitmap bitmap, File file, Bitmap.CompressFormat compressFormat, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return RxImageTool.save(bitmap, file, compressFormat, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isImage(@Nullable File file) {
        if (file == null) return false;
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        if (!RxImageTool.isImage(string)) return false;
        return true;
    }

    @JvmStatic
    public static final boolean isImage(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String string = filePath;
        boolean bl = false;
        String string2 = string.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
        String path = string2;
        return StringsKt.endsWith$default((String)path, (String)".PNG", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".JPG", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".JPEG", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".BMP", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".GIF", (boolean)false, (int)2, null);
    }

    @JvmStatic
    @Nullable
    public static final String getImageType(@Nullable String filePath) {
        return RxImageTool.getImageType(RxFileTool.Companion.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final String getImageType(@Nullable File file) {
        String string;
        if (file == null) {
            return null;
        }
        InputStream is = null;
        try {
            is = new FileInputStream(file);
            string = RxImageTool.getImageType(is);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                string = null;
            }
            catch (Throwable throwable) {
                Closeable[] closeableArray = new Closeable[]{is};
                RxFileTool.Companion.closeIO(closeableArray);
                throw throwable;
            }
            Closeable[] closeableArray = new Closeable[]{is};
            RxFileTool.Companion.closeIO(closeableArray);
        }
        Closeable[] closeableArray = new Closeable[]{is};
        RxFileTool.Companion.closeIO(closeableArray);
        return string;
    }

    @JvmStatic
    @Nullable
    public static final String getImageType(@Nullable InputStream is) {
        String string;
        if (is == null) {
            string = null;
        } else {
            String string2;
            try {
                byte[] bytes = new byte[8];
                string2 = is.read(bytes, 0, 8) != -1 ? RxImageTool.getImageType(bytes) : null;
            }
            catch (IOException e) {
                e.printStackTrace();
                string2 = null;
            }
            string = string2;
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final String getImageType(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (RxImageTool.isJPEG(bytes)) {
            return "JPEG";
        }
        if (RxImageTool.isGIF(bytes)) {
            return "GIF";
        }
        if (RxImageTool.isPNG(bytes)) {
            return "PNG";
        }
        return RxImageTool.isBMP(bytes) ? "BMP" : null;
    }

    @JvmStatic
    public static final boolean isJPEG(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return b.length >= 2 && b[0] == -1 && b[1] == -40;
    }

    @JvmStatic
    public static final boolean isGIF(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return b.length >= 6 && b[0] == 71 && b[1] == 73 && b[2] == 70 && b[3] == 56 && (b[4] == 55 || b[4] == 57) && b[5] == 97;
    }

    @JvmStatic
    public static final boolean isPNG(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return b.length >= 8 && b[0] == -119 && b[1] == 80 && b[2] == 78 && b[3] == 71 && b[4] == 13 && b[5] == 10 && b[6] == 26 && b[7] == 10;
    }

    @JvmStatic
    public static final boolean isBMP(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return b.length >= 2 && b[0] == 66 && b[1] == 77;
    }

    @JvmStatic
    public static final boolean isEmptyBitmap(@Nullable Bitmap src) {
        return src == null || src.getWidth() == 0 || src.getHeight() == 0;
    }

    @JvmStatic
    @Nullable
    public static final Bitmap compressByScale(@NotNull Bitmap src, int newWidth, int newHeight) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return RxImageTool.scale(src, newWidth, newHeight, false);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap compressByScale(@NotNull Bitmap src, int newWidth, int newHeight, boolean recycle) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return RxImageTool.scale(src, newWidth, newHeight, recycle);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap compressByScale(@NotNull Bitmap src, float scaleWidth, float scaleHeight) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return INSTANCE.scale(src, scaleWidth, scaleHeight, false);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap compressByScale(@NotNull Bitmap src, float scaleWidth, float scaleHeight, boolean recycle) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return INSTANCE.scale(src, scaleWidth, scaleHeight, recycle);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap compressByQuality(@NotNull Bitmap src, int quality, boolean recycle) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (RxImageTool.isEmptyBitmap(src) || quality < 0 || quality > 100) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        src.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)baos);
        byte[] bytes = baos.toByteArray();
        if (recycle && !src.isRecycled()) {
            src.recycle();
        }
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    public static /* synthetic */ Bitmap compressByQuality$default(Bitmap bitmap, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return RxImageTool.compressByQuality(bitmap, n, bl);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap compressByQuality(@NotNull Bitmap src, long maxByteSize, boolean recycle) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (RxImageTool.isEmptyBitmap(src) || maxByteSize <= 0L) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int quality = 0;
        quality = 100;
        src.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)baos);
        while ((long)baos.toByteArray().length > maxByteSize && quality >= 0) {
            void it;
            baos.reset();
            int n = 5;
            boolean bl = false;
            boolean bl2 = false;
            int n2 = n;
            Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.JPEG;
            Bitmap bitmap = src;
            boolean bl3 = false;
            int n3 = quality -= it;
            bitmap.compress(compressFormat, n3, (OutputStream)baos);
        }
        if (quality < 0) {
            return null;
        }
        byte[] bytes = baos.toByteArray();
        if (recycle && !src.isRecycled()) {
            src.recycle();
        }
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    public static /* synthetic */ Bitmap compressByQuality$default(Bitmap bitmap, long l, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return RxImageTool.compressByQuality(bitmap, l, bl);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap compressBySampleSize(@NotNull Bitmap src, int sampleSize, boolean recycle) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (RxImageTool.isEmptyBitmap(src)) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = sampleSize;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        src.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        byte[] bytes = baos.toByteArray();
        if (recycle && !src.isRecycled()) {
            src.recycle();
        }
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
    }

    public static /* synthetic */ Bitmap compressBySampleSize$default(Bitmap bitmap, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return RxImageTool.compressBySampleSize(bitmap, n, bl);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap getThumb(@NotNull String filePath, int kind) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return ThumbnailUtils.createVideoThumbnail((String)filePath, (int)kind);
    }

    @JvmStatic
    @NotNull
    public static final Bitmap getThumb(@Nullable Bitmap source, int width, int height) {
        Bitmap bitmap = ThumbnailUtils.extractThumbnail((Bitmap)source, (int)width, (int)height);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"extractThumbnail(source, width, height)");
        return bitmap;
    }

    @JvmStatic
    @NotNull
    public static final Bitmap zoomImage(@NotNull Bitmap bgimage, double newWidth, double newHeight) {
        Intrinsics.checkNotNullParameter((Object)bgimage, (String)"bgimage");
        float width = bgimage.getWidth();
        float height = bgimage.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = (float)newWidth / width;
        float scaleHeight = (float)newHeight / height;
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)bgimage, (int)0, (int)0, (int)((int)width), (int)((int)height), (Matrix)matrix, (boolean)true);
        TLog.e$default("tag", "" + (bitmap.getHeight() + bitmap.getWidth()) + 'd', null, 4, null);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return bitmap;
    }

    @JvmStatic
    @NotNull
    public static final Bitmap zoomBitmap(@NotNull Bitmap bitmap, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = (float)width / (float)w;
        float scaleHeight = (float)height / (float)h;
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)w, (int)h, (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(bitmap, 0, 0, w, h, matrix, true)");
        return bitmap2;
    }

    @JvmStatic
    @Nullable
    public static final Bitmap getBitmap(@Nullable InputStream is) {
        return is == null ? (Bitmap)null : BitmapFactory.decodeStream((InputStream)is);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap getBitmap(@NotNull byte[] data, int offset) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] byArray = data;
        boolean bl = false;
        return byArray.length == 0 ? (Bitmap)null : BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final Bitmap getBitmapFromNet(@Nullable String imgUrl) {
        block24: {
            HttpURLConnection httpURLConnection2;
            ByteArrayOutputStream outputStream;
            InputStream inputStream;
            block22: {
                Bitmap bitmap;
                block23: {
                    inputStream = null;
                    outputStream = null;
                    URL url = null;
                    url = new URL(imgUrl);
                    URLConnection uRLConnection = url.openConnection();
                    if (uRLConnection == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
                    }
                    httpURLConnection2 = (HttpURLConnection)uRLConnection;
                    httpURLConnection2.setRequestMethod("GET");
                    httpURLConnection2.setReadTimeout(2000);
                    httpURLConnection2.connect();
                    if (httpURLConnection2.getResponseCode() != 200) break block22;
                    inputStream = httpURLConnection2.getInputStream();
                    outputStream = new ByteArrayOutputStream();
                    byte[] buffer = new byte[8192];
                    int len = 0;
                    len = -1;
                    while (true) {
                        int n = inputStream.read(buffer);
                        boolean bl = false;
                        boolean bl2 = false;
                        int it = n;
                        boolean bl3 = false;
                        len = it;
                        if (n == -1) break;
                        outputStream.write(buffer, 0, len);
                    }
                    byte[] bu = outputStream.toByteArray();
                    bitmap = BitmapFactory.decodeByteArray((byte[])bu, (int)0, (int)bu.length);
                    if (inputStream == null) break block23;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return bitmap;
            }
            try {
                try {
                    TLog.d(Intrinsics.stringPlus((String)"\u7f51\u7edc\u8fde\u63a5\u5931\u8d25----", (Object)httpURLConnection2.getResponseCode()));
                }
                catch (Exception httpURLConnection2) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (outputStream == null) break block24;
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
        return null;
    }

    @JvmStatic
    public static final void drawNinePath(@Nullable Canvas c, @NotNull Bitmap bmp, @Nullable Rect rect) {
        Intrinsics.checkNotNullParameter((Object)bmp, (String)"bmp");
        NinePatch patch = new NinePatch(bmp, bmp.getNinePatchChunk(), null);
        patch.draw(c, rect);
    }

    @JvmStatic
    @NotNull
    public static final Bitmap createTextImage(@NotNull Bitmap source, int txtSize, @NotNull String innerTxt, int textColor, int textBackgroundColor) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)innerTxt, (String)"innerTxt");
        int bitmapWidth = source.getWidth();
        int bitmapHeight = source.getHeight();
        int textWidth = txtSize * innerTxt.length();
        int textHeight = txtSize;
        int width = 0;
        width = bitmapWidth > textWidth ? bitmapWidth + txtSize * innerTxt.length() : txtSize * innerTxt.length();
        int height = bitmapHeight + txtSize;
        Bitmap bm = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas canvas = new Canvas(bm);
        Paint bitmapPaint = new Paint();
        canvas.drawBitmap(source, (float)(width - bitmapWidth) / 2.0f, 0.0f, bitmapPaint);
        Paint paint = new Paint();
        paint.setColor(textColor);
        paint.setTextSize((float)txtSize);
        paint.setAntiAlias(true);
        int posX = (width - txtSize * innerTxt.length()) / 2;
        int posY = height / 2;
        int textX = posX + txtSize * innerTxt.length() / 4;
        Paint paint1 = new Paint();
        paint1.setColor(textBackgroundColor);
        paint1.setStrokeWidth(3.0f);
        paint1.setStyle(Paint.Style.FILL_AND_STROKE);
        RectF r1 = new RectF();
        r1.left = posX;
        r1.right = (float)posX + (float)txtSize * (float)innerTxt.length();
        r1.top = posY;
        r1.bottom = (float)posY + (float)txtSize;
        canvas.drawRoundRect(r1, 10.0f, 10.0f, paint1);
        canvas.drawText(innerTxt, (float)textX, (float)(posY + txtSize) - 2.0f, paint);
        Intrinsics.checkNotNullExpressionValue((Object)bm, (String)"bm");
        return bm;
    }

    @JvmStatic
    @NotNull
    public static final int[] getScreenResolution(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int[] scrennResolution = new int[2];
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        DisplayMetrics dm = new DisplayMetrics();
        Display display = wm.getDefaultDisplay();
        display.getMetrics(dm);
        scrennResolution[0] = dm.widthPixels;
        scrennResolution[1] = dm.heightPixels;
        return scrennResolution;
    }

    @JvmStatic
    public static final float getDensity(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        DisplayMetrics dm = new DisplayMetrics();
        Display display = wm.getDefaultDisplay();
        display.getMetrics(dm);
        return dm.density;
    }

    @JvmStatic
    @NotNull
    public static final Bitmap scaleImage(@Nullable Resources resources, int resId, int maxSize) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)resources, (int)resId, (BitmapFactory.Options)options);
        options.inSampleSize = INSTANCE.calculateInSampleSize2(options, maxSize, maxSize);
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)resources, (int)resId, (BitmapFactory.Options)options);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"decodeResource(resources, resId, options)");
        return bitmap;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap scale(@NotNull Bitmap src, int newWidth, int newHeight) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return RxImageTool.scale$default(src, newWidth, newHeight, false, 8, null);
    }

    @JvmOverloads
    @Nullable
    public final Bitmap scale(@NotNull Bitmap src, float scaleWidth, float scaleHeight) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return RxImageTool.scale$default(this, src, scaleWidth, scaleHeight, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap clip(@NotNull Bitmap src, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return RxImageTool.clip$default(src, x, y, width, height, false, 32, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap toRound(@NotNull Bitmap src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return RxImageTool.toRound$default(src, false, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap toRoundCorner(@Nullable Bitmap src, float radius) {
        return RxImageTool.toRoundCorner$default(src, radius, false, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap addReflection(@NotNull Bitmap src, int reflectionHeight) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return RxImageTool.addReflection$default(src, reflectionHeight, false, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap addTextWatermark(@NotNull Bitmap src, @Nullable String content, int textSize, int color, int alpha, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return RxImageTool.addTextWatermark$default(src, content, textSize, color, alpha, x, y, false, 128, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap addImageWatermark(@NotNull Bitmap src, @Nullable Bitmap watermark, int x, int y, int alpha) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return RxImageTool.addImageWatermark$default(src, watermark, x, y, alpha, false, 32, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap toGray(@NotNull Bitmap src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return RxImageTool.toGray$default(src, false, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean save(@NotNull Bitmap src, @Nullable File file, @Nullable Bitmap.CompressFormat format) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return RxImageTool.save$default(src, file, format, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap compressByQuality(@NotNull Bitmap src, int quality) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return RxImageTool.compressByQuality$default(src, quality, false, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap compressByQuality(@NotNull Bitmap src, long maxByteSize) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return RxImageTool.compressByQuality$default(src, maxByteSize, false, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap compressBySampleSize(@NotNull Bitmap src, int sampleSize) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return RxImageTool.compressBySampleSize$default(src, sampleSize, false, 4, null);
    }
}

