/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Window;
import android.view.WindowManager;
import com.readystatesoftware.systembartint.SystemBarTintManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0007J\u001a\u0010\f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0007J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u000fH\u0007J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010 \u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\bH\u0007J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006#"}, d2={"Lcom/tamsiree/rxkit/RxBarTool;", "", "()V", "FLAG_FULLSCREEN", "", "activity", "Landroid/app/Activity;", "FlymeSetStatusBarLightMode", "", "window", "Landroid/view/Window;", "dark", "MIUISetStatusBarLightMode", "StatusBarDarkMode", "type", "", "StatusBarLightMode", "getActionBarHeight", "getStatusBarHeight", "context", "Landroid/content/Context;", "hideNotificationBar", "hideStatusBar", "invokePanels", "methodName", "", "isStatusBarExists", "noTitle", "setNoTitle", "setStatusBarColor", "colorId", "setTransparentStatusBar", "showNotificationBar", "isSettingPanel", "transparencyBar", "RxKit_release"})
public final class RxBarTool {
    @NotNull
    public static final RxBarTool INSTANCE = new RxBarTool();

    private RxBarTool() {
    }

    @JvmStatic
    public static final void hideStatusBar(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        RxBarTool.noTitle(activity);
        RxBarTool.FLAG_FULLSCREEN(activity);
    }

    @JvmStatic
    public static final void setTransparentStatusBar(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 19) {
            activity.getWindow().addFlags(0x4000000);
            activity.getWindow().addFlags(0x8000000);
        }
    }

    @JvmStatic
    public static final void setNoTitle(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        activity.requestWindowFeature(1);
    }

    @JvmStatic
    public static final void noTitle(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        RxBarTool.setNoTitle(activity);
    }

    @JvmStatic
    public static final void FLAG_FULLSCREEN(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        activity.getWindow().setFlags(1024, 1024);
    }

    @JvmStatic
    public static final int getStatusBarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    @JvmStatic
    public static final boolean isStatusBarExists(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        WindowManager.LayoutParams params = activity.getWindow().getAttributes();
        return (params.flags & 0x400) != 1024;
    }

    @JvmStatic
    public static final int getActionBarHeight(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        TypedValue tv = new TypedValue();
        return activity.getTheme().resolveAttribute(16843499, tv, true) ? TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)activity.getResources().getDisplayMetrics()) : 0;
    }

    @JvmStatic
    public static final void showNotificationBar(@NotNull Context context, boolean isSettingPanel) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String methodName = Build.VERSION.SDK_INT <= 16 ? "expand" : (isSettingPanel ? "expandSettingsPanel" : "expandNotificationsPanel");
        INSTANCE.invokePanels(context, methodName);
    }

    @JvmStatic
    public static final void hideNotificationBar(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String methodName = Build.VERSION.SDK_INT <= 16 ? "collapse" : "collapsePanels";
        INSTANCE.invokePanels(context, methodName);
    }

    private final void invokePanels(Context context, String methodName) {
        try {
            Object service = context.getSystemService("statusbar");
            Class<?> clazz = Class.forName("android.app.StatusBarManager");
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(\"android.app.StatusBarManager\")");
            Class<?> statusBarManager = clazz;
            Method method = statusBarManager.getMethod(methodName, new Class[0]);
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"statusBarManager.getMethod(methodName)");
            Method expand = method;
            expand.invoke(service, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JvmStatic
    public static final void transparencyBar(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.clearFlags(0xC000000);
            window.getDecorView().setSystemUiVisibility(1792);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0);
            window.setNavigationBarColor(0);
        } else if (Build.VERSION.SDK_INT >= 19) {
            Window window = activity.getWindow();
            window.setFlags(0x4000000, 0x4000000);
        }
    }

    @JvmStatic
    public static final void setStatusBarColor(@NotNull Activity activity, int colorId) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.setStatusBarColor(activity.getResources().getColor(colorId));
        } else if (Build.VERSION.SDK_INT >= 19) {
            RxBarTool.transparencyBar(activity);
            SystemBarTintManager tintManager = new SystemBarTintManager(activity);
            tintManager.setStatusBarTintEnabled(true);
            tintManager.setStatusBarTintResource(colorId);
        }
    }

    @JvmStatic
    public static final int StatusBarLightMode(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        int result = 0;
        if (Build.VERSION.SDK_INT >= 19) {
            if (RxBarTool.MIUISetStatusBarLightMode(activity.getWindow(), true)) {
                result = 1;
            } else if (RxBarTool.FlymeSetStatusBarLightMode(activity.getWindow(), true)) {
                result = 2;
            } else if (Build.VERSION.SDK_INT >= 23) {
                activity.getWindow().getDecorView().setSystemUiVisibility(9216);
                result = 3;
            }
        }
        return result;
    }

    @JvmStatic
    public static final void StatusBarLightMode(@NotNull Activity activity, int type) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        switch (type) {
            case 1: {
                RxBarTool.MIUISetStatusBarLightMode(activity.getWindow(), true);
                break;
            }
            case 2: {
                RxBarTool.FlymeSetStatusBarLightMode(activity.getWindow(), true);
                break;
            }
            case 3: {
                activity.getWindow().getDecorView().setSystemUiVisibility(9216);
            }
        }
    }

    @JvmStatic
    public static final void StatusBarDarkMode(@NotNull Activity activity, int type) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        switch (type) {
            case 1: {
                RxBarTool.MIUISetStatusBarLightMode(activity.getWindow(), false);
                break;
            }
            case 2: {
                RxBarTool.FlymeSetStatusBarLightMode(activity.getWindow(), false);
                break;
            }
            case 3: {
                activity.getWindow().getDecorView().setSystemUiVisibility(0);
            }
        }
    }

    @JvmStatic
    public static final boolean FlymeSetStatusBarLightMode(@Nullable Window window, boolean dark) {
        boolean result = false;
        if (window != null) {
            try {
                WindowManager.LayoutParams lp = window.getAttributes();
                Field field = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                Intrinsics.checkNotNullExpressionValue((Object)field, (String)"WindowManager.LayoutParams::class.java\n                        .getDeclaredField(\"MEIZU_FLAG_DARK_STATUS_BAR_ICON\")");
                Field darkFlag = field;
                Field field2 = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
                Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"WindowManager.LayoutParams::class.java\n                        .getDeclaredField(\"meizuFlags\")");
                Field meizuFlags = field2;
                darkFlag.setAccessible(true);
                meizuFlags.setAccessible(true);
                int bit = darkFlag.getInt(null);
                int value = meizuFlags.getInt(lp);
                value = dark ? value | bit : value & ~bit;
                meizuFlags.setInt(lp, value);
                window.setAttributes(lp);
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @JvmStatic
    public static final boolean MIUISetStatusBarLightMode(@Nullable Window window, boolean dark) {
        boolean result = false;
        if (window != null) {
            Class<?> clazz = window.getClass();
            try {
                int darkModeFlag = 0;
                Class<?> clazz2 = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                Intrinsics.checkNotNullExpressionValue(clazz2, (String)"forName(\"android.view.MiuiWindowManager\\$LayoutParams\")");
                Class<?> layoutParams = clazz2;
                Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
                Intrinsics.checkNotNullExpressionValue((Object)field, (String)"layoutParams.getField(\"EXTRA_FLAG_STATUS_BAR_DARK_MODE\")");
                Field field2 = field;
                darkModeFlag = field2.getInt(layoutParams);
                Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE};
                Object[] objectArray = clazz.getMethod("setExtraFlags", classArray);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"clazz.getMethod(\"setExtraFlags\", Int::class.javaPrimitiveType, Int::class.javaPrimitiveType)");
                Object[] extraFlagField = objectArray;
                if (dark) {
                    objectArray = new Object[]{darkModeFlag, darkModeFlag};
                    extraFlagField.invoke((Object)window, objectArray);
                } else {
                    objectArray = new Object[]{0, darkModeFlag};
                    extraFlagField.invoke((Object)window, objectArray);
                }
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }
}

