/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.util.Pair;
import android.view.View;
import androidx.core.app.ActivityCompat;
import androidx.core.app.ActivityOptionsCompat;
import com.tamsiree.rxkit.RxIntentTool;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0007J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0007J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\rH\u0007J\u001a\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\r2\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010\u0013\u001a\u00020\u000b2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0017H\u0007J\u0012\u0010\u0013\u001a\u00020\u000b2\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007J\b\u0010\u0018\u001a\u00020\u000bH\u0007J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001aH\u0007J$\u0010\u001c\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001aH\u0007J0\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 H\u0007J\u0012\u0010!\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0007J8\u0010\"\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0010\u0010#\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u00172\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2\b\b\u0002\u0010$\u001a\u00020\u0015H\u0007JB\u0010%\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0010\u0010#\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u00172\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2\b\b\u0002\u0010$\u001a\u00020\u00152\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007J6\u0010%\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0010\u0010#\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u00172\b\b\u0002\u0010$\u001a\u00020\u00152\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007J8\u0010&\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0010\u0010#\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u00172\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2\b\b\u0002\u0010$\u001a\u00020\u0015H\u0007J6\u0010'\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0010\u0010#\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u00172\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010(\u001a\u00020)H\u0007Je\u0010*\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0010\u0010#\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u00172\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2.\u0010+\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u001a\u0018\u00010-0,\"\u0010\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u001a\u0018\u00010-H\u0007\u00a2\u0006\u0002\u0010/JB\u00100\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\r2\u0010\u0010#\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u00172\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u00101\u001a\u0004\u0018\u00010.2\b\u00102\u001a\u0004\u0018\u00010\u001aH\u0007R$\u0010\u0003\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u00063"}, d2={"Lcom/tamsiree/rxkit/RxActivityTool;", "", "()V", "activityStack", "Ljava/util/Stack;", "Landroid/app/Activity;", "getActivityStack", "()Ljava/util/Stack;", "setActivityStack", "(Ljava/util/Stack;)V", "AppExit", "", "context", "Landroid/content/Context;", "addActivity", "activity", "currentActivity", "fadeTransition", "mContext", "finishActivity", "isTransition", "", "cls", "Ljava/lang/Class;", "finishAllActivity", "getLauncherActivity", "", "packageName", "isExistActivity", "className", "launchActivity", "bundle", "Landroid/os/Bundle;", "removeActivity", "skipActivity", "goal", "isFade", "skipActivityAndFinish", "skipActivityAndFinishAll", "skipActivityForResult", "requestCode", "", "skipActivityOnTransitions", "pairs", "", "Landroid/util/Pair;", "Landroid/view/View;", "(Landroid/content/Context;Ljava/lang/Class;Landroid/os/Bundle;[Landroid/util/Pair;)V", "skipActivityTransition", "view", "elementName", "RxKit_release"})
public final class RxActivityTool {
    @NotNull
    public static final RxActivityTool INSTANCE = new RxActivityTool();
    @Nullable
    private static Stack<Activity> activityStack;

    private RxActivityTool() {
    }

    @Nullable
    public final Stack<Activity> getActivityStack() {
        return activityStack;
    }

    public final void setActivityStack(@Nullable Stack<Activity> stack) {
        activityStack = stack;
    }

    @JvmStatic
    public static final void addActivity(@Nullable Activity activity) {
        Stack<Activity> stack;
        if (activityStack == null) {
            activityStack = new Stack();
        }
        if ((stack = activityStack) != null) {
            stack.add(activity);
        }
    }

    @JvmStatic
    public static final void removeActivity(@Nullable Activity activity) {
        if (activity != null) {
            Stack<Activity> stack = activityStack;
            Intrinsics.checkNotNull(stack);
            if (stack.contains(activity)) {
                stack = activityStack;
                if (stack != null) {
                    stack.remove(activity);
                }
            }
        }
    }

    @JvmStatic
    @Nullable
    public static final Activity currentActivity() {
        Stack<Activity> stack = activityStack;
        return stack == null ? null : (Activity)stack.lastElement();
    }

    @JvmStatic
    @JvmOverloads
    public static final void finishActivity(boolean isTransition) {
        Activity activity;
        Activity activity2 = activityStack;
        Activity activity3 = activity = activity2 == null ? null : (Activity)activity2.lastElement();
        if (isTransition) {
            activity2 = activity;
            if (activity2 != null) {
                activity2.onBackPressed();
            }
        } else {
            activity2 = activity;
            if (activity2 != null) {
                activity2.finish();
            }
        }
    }

    public static /* synthetic */ void finishActivity$default(boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        RxActivityTool.finishActivity(bl);
    }

    @JvmStatic
    public static final void finishActivity(@NotNull Class<? extends Activity> cls) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        Stack<Activity> stack = activityStack;
        Intrinsics.checkNotNull(stack);
        for (Activity activity : stack) {
            Intrinsics.checkNotNull((Object)activity);
            if (!Intrinsics.areEqual(activity.getClass(), cls)) continue;
            RxActivityTool.finishActivity$default((Context)activity, false, 2, null);
        }
    }

    @JvmStatic
    public static final void finishAllActivity() {
        Stack<Activity> stack = activityStack;
        Intrinsics.checkNotNull(stack);
        int size = stack.size();
        int n = 0;
        if (n < size) {
            do {
                int i = n++;
                Activity activity = activityStack;
                Intrinsics.checkNotNull(activity);
                if (activity.get(i) == null) continue;
                Stack<Activity> stack2 = activityStack;
                Intrinsics.checkNotNull(stack2);
                activity = (Activity)stack2.get(i);
                Intrinsics.checkNotNull((Object)activity);
                activity.finish();
            } while (n < size);
        }
        Stack<Activity> stack3 = activityStack;
        Intrinsics.checkNotNull(stack3);
        stack3.clear();
    }

    @JvmStatic
    public static final void AppExit(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            INSTANCE.finishAllActivity();
            Object object = context.getSystemService("activity");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.ActivityManager");
            }
            ActivityManager activityManager = (ActivityManager)object;
            activityManager.restartPackage(context.getPackageName());
            int n = 0;
            boolean bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @JvmStatic
    public static final boolean isExistActivity(@NotNull Context context, @Nullable String packageName, @Nullable String className) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent intent = new Intent();
        Intrinsics.checkNotNull((Object)packageName);
        Intrinsics.checkNotNull((Object)className);
        intent.setClassName(packageName, className);
        return context.getPackageManager().resolveActivity(intent, 0) != null && intent.resolveActivity(context.getPackageManager()) != null && context.getPackageManager().queryIntentActivities(intent, 0).size() != 0;
    }

    @JvmStatic
    public static final void launchActivity(@NotNull Context context, @Nullable String packageName, @Nullable String className, @Nullable Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.startActivity(RxIntentTool.getComponentNameIntent(packageName, className, bundle));
    }

    public static /* synthetic */ void launchActivity$default(Context context, String string, String string2, Bundle bundle, int n, Object object) {
        if ((n & 8) != 0) {
            bundle = null;
        }
        RxActivityTool.launchActivity(context, string, string2, bundle);
    }

    @JvmStatic
    @JvmOverloads
    public static final void skipActivityAndFinishAll(@NotNull Context context, @Nullable Class<? extends Activity> goal, @Nullable Bundle bundle, boolean isFade) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent intent = new Intent(context, goal);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        intent.setFlags(0x10008000);
        context.startActivity(intent);
        RxActivityTool.finishActivity(context, false);
        if (isFade) {
            RxActivityTool.fadeTransition(context);
        }
    }

    public static /* synthetic */ void skipActivityAndFinishAll$default(Context context, Class clazz, Bundle bundle, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bundle = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        RxActivityTool.skipActivityAndFinishAll(context, clazz, bundle, bl);
    }

    @JvmStatic
    public static final void skipActivityAndFinish(@NotNull Context context, @Nullable Class<? extends Activity> goal, boolean isFade, boolean isTransition) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RxActivityTool.skipActivity(context, goal, null, isFade);
        RxActivityTool.finishActivity(context, isTransition);
    }

    public static /* synthetic */ void skipActivityAndFinish$default(Context context, Class clazz, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        RxActivityTool.skipActivityAndFinish(context, (Class<? extends Activity>)clazz, bl, bl2);
    }

    @JvmStatic
    @JvmOverloads
    public static final void skipActivityAndFinish(@NotNull Context context, @Nullable Class<? extends Activity> goal, @Nullable Bundle bundle, boolean isFade, boolean isTransition) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RxActivityTool.skipActivity(context, goal, bundle, isFade);
        RxActivityTool.finishActivity(context, isTransition);
    }

    public static /* synthetic */ void skipActivityAndFinish$default(Context context, Class clazz, Bundle bundle, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bundle = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        RxActivityTool.skipActivityAndFinish(context, clazz, bundle, bl, bl2);
    }

    @JvmStatic
    @JvmOverloads
    public static final void skipActivity(@NotNull Context context, @Nullable Class<? extends Activity> goal, @Nullable Bundle bundle, boolean isFade) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent intent = new Intent(context, goal);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        context.startActivity(intent);
        if (isFade) {
            RxActivityTool.fadeTransition(context);
        }
    }

    public static /* synthetic */ void skipActivity$default(Context context, Class clazz, Bundle bundle, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bundle = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        RxActivityTool.skipActivity(context, clazz, bundle, bl);
    }

    @JvmStatic
    @JvmOverloads
    public static final void skipActivityForResult(@NotNull Activity context, @Nullable Class<? extends Activity> goal, @Nullable Bundle bundle, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent intent = new Intent((Context)context, goal);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        context.startActivityForResult(intent, requestCode);
    }

    public static /* synthetic */ void skipActivityForResult$default(Activity activity, Class clazz, Bundle bundle, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bundle = null;
        }
        RxActivityTool.skipActivityForResult(activity, clazz, bundle, n);
    }

    @JvmStatic
    @JvmOverloads
    public static final void skipActivityOnTransitions(@Nullable Context mContext, @Nullable Class<? extends Activity> goal, @Nullable Bundle bundle, Pair<View, String> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        Intent intent = new Intent(mContext, goal);
        Bundle bundle1 = ActivityOptions.makeSceneTransitionAnimation((Activity)((Activity)mContext), Arrays.copyOf(pairs, pairs.length)).toBundle();
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        Intrinsics.checkNotNull((Object)mContext);
        ActivityCompat.startActivity((Context)mContext, (Intent)intent, (Bundle)bundle1);
    }

    public static /* synthetic */ void skipActivityOnTransitions$default(Context context, Class clazz, Bundle bundle, Pair[] pairArray, int n, Object object) {
        if ((n & 4) != 0) {
            bundle = null;
        }
        RxActivityTool.skipActivityOnTransitions(context, (Class<? extends Activity>)clazz, bundle, pairArray);
    }

    @JvmStatic
    @JvmOverloads
    public static final void skipActivityTransition(@NotNull Context mContext, @Nullable Class<? extends Activity> goal, @Nullable Bundle bundle, @Nullable View view, @Nullable String elementName) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        Intent intent = new Intent(mContext, goal);
        Activity activity = (Activity)mContext;
        Intrinsics.checkNotNull((Object)view);
        Intrinsics.checkNotNull((Object)elementName);
        Bundle bundle1 = ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)activity, (View)view, (String)elementName).toBundle();
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        mContext.startActivity(intent, bundle1);
    }

    public static /* synthetic */ void skipActivityTransition$default(Context context, Class clazz, Bundle bundle, View view, String string, int n, Object object) {
        if ((n & 4) != 0) {
            bundle = null;
        }
        RxActivityTool.skipActivityTransition(context, clazz, bundle, view, string);
    }

    @JvmStatic
    @NotNull
    public static final String getLauncherActivity(@NotNull Context context, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.addCategory("android.intent.category.LAUNCHER");
        PackageManager pm = context.getPackageManager();
        List infos = pm.queryIntentActivities(intent, 0);
        for (ResolveInfo info : infos) {
            if (!Intrinsics.areEqual((Object)info.activityInfo.packageName, (Object)packageName)) continue;
            String string = info.activityInfo.name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"info.activityInfo.name");
            return string;
        }
        return Intrinsics.stringPlus((String)"no ", (Object)packageName);
    }

    @JvmStatic
    @JvmOverloads
    public static final void finishActivity(@NotNull Context mContext, boolean isTransition) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        RxActivityTool.removeActivity((Activity)mContext);
        if (isTransition) {
            ((Activity)mContext).onBackPressed();
        } else {
            ((Activity)mContext).finish();
        }
    }

    public static /* synthetic */ void finishActivity$default(Context context, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        RxActivityTool.finishActivity(context, bl);
    }

    @JvmStatic
    public static final void fadeTransition(@NotNull Context mContext) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        ((Activity)mContext).overridePendingTransition(0x10A0000, 0x10A0001);
    }

    @JvmStatic
    @JvmOverloads
    public static final void finishActivity() {
        RxActivityTool.finishActivity$default(false, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void skipActivityAndFinishAll(@NotNull Context context, @Nullable Class<? extends Activity> goal, @Nullable Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RxActivityTool.skipActivityAndFinishAll$default(context, goal, bundle, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void skipActivityAndFinishAll(@NotNull Context context, @Nullable Class<? extends Activity> goal) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RxActivityTool.skipActivityAndFinishAll$default(context, goal, null, false, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void skipActivityAndFinish(@NotNull Context context, @Nullable Class<? extends Activity> goal, @Nullable Bundle bundle, boolean isFade) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RxActivityTool.skipActivityAndFinish$default(context, goal, bundle, isFade, false, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void skipActivityAndFinish(@NotNull Context context, @Nullable Class<? extends Activity> goal, @Nullable Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RxActivityTool.skipActivityAndFinish$default(context, goal, bundle, false, false, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void skipActivityAndFinish(@NotNull Context context, @Nullable Class<? extends Activity> goal) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RxActivityTool.skipActivityAndFinish$default(context, goal, null, false, false, 28, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void skipActivity(@NotNull Context context, @Nullable Class<? extends Activity> goal, @Nullable Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RxActivityTool.skipActivity$default(context, goal, bundle, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void skipActivity(@NotNull Context context, @Nullable Class<? extends Activity> goal) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RxActivityTool.skipActivity$default(context, goal, null, false, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void skipActivityForResult(@NotNull Activity context, @Nullable Class<? extends Activity> goal, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RxActivityTool.skipActivityForResult$default(context, goal, null, requestCode, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void skipActivityOnTransitions(@Nullable Context mContext, @Nullable Class<? extends Activity> goal, Pair<View, String> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        RxActivityTool.skipActivityOnTransitions$default(mContext, goal, null, pairs, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void skipActivityTransition(@NotNull Context mContext, @Nullable Class<? extends Activity> goal, @Nullable View view, @Nullable String elementName) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        RxActivityTool.skipActivityTransition$default(mContext, goal, null, view, elementName, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void finishActivity(@NotNull Context mContext) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        RxActivityTool.finishActivity$default(mContext, false, 2, null);
    }
}

