/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/tamsiree/rxkit/RxServiceTool;", "", "()V", "isRunningService", "", "context", "Landroid/content/Context;", "className", "", "RxKit_release"})
public final class RxServiceTool {
    public static final RxServiceTool INSTANCE;

    @JvmStatic
    public static final boolean isRunningService(@NotNull Context context, @NotNull String className) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager activityManager = (ActivityManager)object;
        List runningServices = activityManager.getRunningServices(1000);
        for (ActivityManager.RunningServiceInfo runningServiceInfo : runningServices) {
            ComponentName service;
            ComponentName componentName = service = runningServiceInfo.service;
            Intrinsics.checkExpressionValueIsNotNull((Object)componentName, (String)"service");
            if (!Intrinsics.areEqual((Object)className, (Object)componentName.getClassName())) continue;
            return true;
        }
        return false;
    }

    private RxServiceTool() {
    }

    static {
        RxServiceTool rxServiceTool;
        INSTANCE = rxServiceTool = new RxServiceTool();
    }
}

