/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.util.Pair;
import android.view.View;
import androidx.core.app.ActivityCompat;
import androidx.core.app.ActivityOptionsCompat;
import com.tamsiree.rxkit.RxIntentTool;
import java.util.List;
import java.util.Stack;

public class RxActivityTool {
    private static Stack<Activity> activityStack;

    public static void addActivity(Activity activity) {
        if (activityStack == null) {
            activityStack = new Stack();
        }
        activityStack.add(activity);
    }

    public static Activity currentActivity() {
        return (Activity)activityStack.lastElement();
    }

    public static void finishActivity() {
        Activity activity = (Activity)activityStack.lastElement();
        activity.finish();
    }

    public static void finishActivity(Activity activity) {
        if (activity != null) {
            activityStack.remove(activity);
            activity.finish();
            activity = null;
        }
    }

    public static void finishActivity(Class<?> cls) {
        for (Activity activity : activityStack) {
            if (!activity.getClass().equals(cls)) continue;
            RxActivityTool.finishActivity(activity);
        }
    }

    public static void finishAllActivity() {
        int size = activityStack.size();
        for (int i = 0; i < size; ++i) {
            if (null == activityStack.get(i)) continue;
            ((Activity)activityStack.get(i)).finish();
        }
        activityStack.clear();
    }

    public static void AppExit(Context context) {
        try {
            RxActivityTool.finishAllActivity();
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            activityManager.restartPackage(context.getPackageName());
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Stack<Activity> getActivityStack() {
        return activityStack;
    }

    public static boolean isExistActivity(Context context, String packageName, String className) {
        Intent intent = new Intent();
        intent.setClassName(packageName, className);
        return context.getPackageManager().resolveActivity(intent, 0) != null && intent.resolveActivity(context.getPackageManager()) != null && context.getPackageManager().queryIntentActivities(intent, 0).size() != 0;
    }

    public static void launchActivity(Context context, String packageName, String className) {
        RxActivityTool.launchActivity(context, packageName, className, null);
    }

    public static void launchActivity(Context context, String packageName, String className, Bundle bundle) {
        context.startActivity(RxIntentTool.getComponentNameIntent(packageName, className, bundle));
    }

    public static void skipActivityAndFinishAll(Context context, Class<?> goal, Bundle bundle, boolean isFade) {
        Intent intent = new Intent(context, goal);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        intent.setFlags(0x10008000);
        context.startActivity(intent);
        RxActivityTool.finishActivity(context, false);
        if (isFade) {
            RxActivityTool.fadeTransition(context);
        }
    }

    public static void skipActivityAndFinishAll(Context context, Class<?> goal, boolean isFade) {
        RxActivityTool.skipActivityAndFinishAll(context, goal, null, isFade);
    }

    public static void skipActivityAndFinishAll(Context context, Class<?> goal) {
        RxActivityTool.skipActivityAndFinishAll(context, goal, null, false);
    }

    public static void skipActivityAndFinish(Context context, Class<?> goal, Bundle bundle, boolean isFade, boolean isTransition) {
        RxActivityTool.skipActivity(context, goal, bundle, isFade);
        RxActivityTool.finishActivity(context, isTransition);
    }

    public static void skipActivityAndFinish(Context context, Class<?> goal, Bundle bundle) {
        RxActivityTool.skipActivity(context, goal, bundle, false);
        RxActivityTool.finishActivity(context, false);
    }

    public static void skipActivityAndFinish(Context context, Class<?> goal) {
        RxActivityTool.skipActivity(context, goal, null, false);
        RxActivityTool.finishActivity(context, false);
    }

    public static void skipActivityAndFinish(Context context, Class<?> goal, boolean isFade, boolean isTransition) {
        RxActivityTool.skipActivity(context, goal, isFade);
        RxActivityTool.finishActivity(context, isTransition);
    }

    public static void skipActivity(Context context, Class<?> goal) {
        RxActivityTool.skipActivity(context, goal, null, false);
    }

    public static void skipActivity(Context context, Class<?> goal, boolean isFade) {
        RxActivityTool.skipActivity(context, goal, null, isFade);
    }

    public static void skipActivity(Context context, Class<?> goal, Bundle bundle, boolean isFade) {
        Intent intent = new Intent(context, goal);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        context.startActivity(intent);
        if (isFade) {
            RxActivityTool.fadeTransition(context);
        }
    }

    public static void skipActivityForResult(Activity context, Class<?> goal, int requestCode) {
        RxActivityTool.skipActivityForResult(context, goal, null, requestCode);
    }

    public static void skipActivityForResult(Activity context, Class<?> goal, Bundle bundle, int requestCode) {
        Intent intent = new Intent((Context)context, goal);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        context.startActivityForResult(intent, requestCode);
    }

    public static void skipActivityOnTransitions(Context mContext, Class<?> goal, Bundle bundle, Pair<View, String> ... pairs) {
        Intent intent = new Intent(mContext, goal);
        Bundle bundle1 = ActivityOptions.makeSceneTransitionAnimation((Activity)((Activity)mContext), pairs).toBundle();
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        ActivityCompat.startActivity((Context)mContext, (Intent)intent, (Bundle)bundle1);
    }

    public static void skipActivityTransition(Context mContext, Class<?> goal, Bundle bundle, View view, String elementName) {
        Intent intent = new Intent(mContext, goal);
        Bundle bundle1 = ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)((Activity)mContext), (View)view, (String)elementName).toBundle();
        intent.putExtras(bundle);
        mContext.startActivity(intent, bundle1);
    }

    public static String getLauncherActivity(Context context, String packageName) {
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.addCategory("android.intent.category.LAUNCHER");
        PackageManager pm = context.getPackageManager();
        List infos = pm.queryIntentActivities(intent, 0);
        for (ResolveInfo info : infos) {
            if (!info.activityInfo.packageName.equals(packageName)) continue;
            return info.activityInfo.name;
        }
        return "no " + packageName;
    }

    public static void finishActivity(Context mContext, boolean isTransition) {
        if (isTransition) {
            ((Activity)mContext).onBackPressed();
        } else {
            ((Activity)mContext).finish();
        }
    }

    public static void fadeTransition(Context mContext) {
        ((Activity)mContext).overridePendingTransition(0x10A0000, 0x10A0001);
    }
}

