/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RxThreadPoolTool {
    private ExecutorService exec;
    private ScheduledExecutorService scheduleExec;

    public RxThreadPoolTool(Type type, int corePoolSize) {
        this.scheduleExec = Executors.newScheduledThreadPool(corePoolSize);
        switch (type) {
            case FixedThread: {
                this.exec = Executors.newFixedThreadPool(corePoolSize);
                break;
            }
            case SingleThread: {
                this.exec = Executors.newSingleThreadExecutor();
                break;
            }
            case CachedThread: {
                this.exec = Executors.newCachedThreadPool();
                break;
            }
            default: {
                this.exec = this.scheduleExec;
            }
        }
    }

    public void execute(Runnable command) {
        this.exec.execute(command);
    }

    public void execute(List<Runnable> commands) {
        for (Runnable command : commands) {
            this.exec.execute(command);
        }
    }

    public void shutDown() {
        this.exec.shutdown();
    }

    public List<Runnable> shutDownNow() {
        return this.exec.shutdownNow();
    }

    public boolean isShutDown() {
        return this.exec.isShutdown();
    }

    public boolean isTerminated() {
        return this.exec.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.exec.awaitTermination(timeout, unit);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.exec.submit(task);
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return this.exec.submit(task, result);
    }

    public Future<?> submit(Runnable task) {
        return this.exec.submit(task);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.exec.invokeAll(tasks);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.exec.invokeAll(tasks, timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.exec.invokeAny(tasks);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.exec.invokeAny(tasks, timeout, unit);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.scheduleExec.schedule(command, delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.scheduleExec.schedule(callable, delay, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduleExec.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduleExec.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public static enum Type {
        FixedThread,
        CachedThread,
        SingleThread;

    }
}

