/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.content.Context;
import android.os.Environment;
import android.util.Log;
import com.tamsiree.rxkit.RxFileTool;
import com.tamsiree.rxkit.RxTimeTool;
import com.tamsiree.rxkit.RxTool;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class RxLogTool {
    private static final SimpleDateFormat LOG_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat FILE_SUFFIX = new SimpleDateFormat("yyyy-MM-dd");
    private static Boolean LOG_SWITCH = true;
    private static Boolean LOG_TO_FILE = false;
    private static String LOG_TAG = "TAG";
    private static char LOG_TYPE = (char)118;
    private static int LOG_SAVE_DAYS = 7;
    private static String LOG_FILE_PATH;
    private static String LOG_FILE_NAME;

    public static void init(Context context) {
        LOG_FILE_PATH = Environment.getExternalStorageDirectory().getPath() + File.separator + context.getPackageName();
        LOG_FILE_NAME = "Log";
    }

    public static void w(Object msg) {
        RxLogTool.w(LOG_TAG, msg);
    }

    public static void w(String tag, Object msg) {
        RxLogTool.w(tag, msg, null);
    }

    public static void w(String tag, Object msg, Throwable tr) {
        RxLogTool.log(tag, msg.toString(), tr, 'w');
    }

    public static void e(Object msg) {
        RxLogTool.e(LOG_TAG, msg);
    }

    public static void e(String tag, Object msg) {
        RxLogTool.e(tag, msg, null);
    }

    public static void e(String tag, Object msg, Throwable tr) {
        RxLogTool.log(tag, msg.toString(), tr, 'e');
    }

    public static void d(Object msg) {
        RxLogTool.d(LOG_TAG, msg);
    }

    public static void d(String tag, Object msg) {
        RxLogTool.d(tag, msg, null);
    }

    public static void d(String tag, Object msg, Throwable tr) {
        RxLogTool.log(tag, msg.toString(), tr, 'd');
    }

    public static void i(Object msg) {
        RxLogTool.i(LOG_TAG, msg);
    }

    public static void i(String tag, Object msg) {
        RxLogTool.i(tag, msg, null);
    }

    public static void i(String tag, Object msg, Throwable tr) {
        RxLogTool.log(tag, msg.toString(), tr, 'i');
    }

    public static void v(Object msg) {
        RxLogTool.v(LOG_TAG, msg);
    }

    public static void v(String tag, Object msg) {
        RxLogTool.v(tag, msg, null);
    }

    public static void v(String tag, Object msg, Throwable tr) {
        RxLogTool.log(tag, msg.toString(), tr, 'v');
    }

    private static void log(String tag, String msg, Throwable tr, char level) {
        if (LOG_SWITCH.booleanValue()) {
            if ('e' == level && ('e' == LOG_TYPE || 'v' == LOG_TYPE)) {
                Log.e((String)tag, (String)msg, (Throwable)tr);
            } else if ('w' == level && ('w' == LOG_TYPE || 'v' == LOG_TYPE)) {
                Log.w((String)tag, (String)msg, (Throwable)tr);
            } else if ('d' == level && ('d' == LOG_TYPE || 'v' == LOG_TYPE)) {
                Log.d((String)tag, (String)msg, (Throwable)tr);
            } else if ('i' == level && ('d' == LOG_TYPE || 'v' == LOG_TYPE)) {
                Log.i((String)tag, (String)msg, (Throwable)tr);
            } else {
                Log.v((String)tag, (String)msg, (Throwable)tr);
            }
            if (LOG_TO_FILE.booleanValue()) {
                RxLogTool.log2File(String.valueOf(level), tag, msg + tr == null ? "" : "\n" + Log.getStackTraceString((Throwable)tr));
            }
        }
    }

    private static synchronized void log2File(String mylogtype, String tag, String text) {
        Date nowtime = new Date();
        String date = FILE_SUFFIX.format(nowtime);
        String dateLogContent = LOG_FORMAT.format(nowtime) + ":" + mylogtype + ":" + tag + ":" + text;
        File destDir = new File(LOG_FILE_PATH);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        File file = new File(LOG_FILE_PATH, LOG_FILE_NAME + date);
        try {
            FileWriter filerWriter = new FileWriter(file, true);
            BufferedWriter bufWriter = new BufferedWriter(filerWriter);
            bufWriter.write(dateLogContent);
            bufWriter.newLine();
            bufWriter.close();
            filerWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void delFile() {
        String needDelFiel = FILE_SUFFIX.format(RxLogTool.getDateBefore());
        File file = new File(LOG_FILE_PATH, needDelFiel + LOG_FILE_NAME);
        if (file.exists()) {
            file.delete();
        }
    }

    private static Date getDateBefore() {
        Date nowtime = new Date();
        Calendar now = Calendar.getInstance();
        now.setTime(nowtime);
        now.set(5, now.get(5) - LOG_SAVE_DAYS);
        return now.getTime();
    }

    public static void saveLogFile(String message) {
        File fileDir = new File(RxFileTool.getRootPath() + File.separator + RxTool.getContext().getPackageName());
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        File file = new File(fileDir, RxTimeTool.getCurrentDateTime("yyyyMMdd") + ".txt");
        try {
            if (file.exists()) {
                PrintStream ps = new PrintStream(new FileOutputStream(file, true));
                ps.append(RxTimeTool.getCurrentDateTime("\n\n\nyyyy-MM-dd HH:mm:ss") + "\n" + message);
            } else {
                PrintStream ps = new PrintStream(new FileOutputStream(file));
                file.createNewFile();
                ps.println(RxTimeTool.getCurrentDateTime("yyyy-MM-dd HH:mm:ss") + "\n" + message);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

