/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnticipateOvershootInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import android.view.animation.ScaleAnimation;
import com.tamsiree.rxkit.interfaces.OnDoIntListener;

public class RxAnimationTool {
    public static void start(Animator animator) {
        if (animator != null && !animator.isStarted()) {
            animator.start();
        }
    }

    public static void stop(Animator animator) {
        if (animator != null && !animator.isRunning()) {
            animator.end();
        }
    }

    public static boolean isRunning(ValueAnimator animator) {
        return animator != null && animator.isRunning();
    }

    public static boolean isStarted(ValueAnimator animator) {
        return animator != null && animator.isStarted();
    }

    public static void animationColorGradient(int beforeColor, int afterColor, final OnDoIntListener listener) {
        ValueAnimator valueAnimator = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{beforeColor, afterColor}).setDuration(3000L);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                listener.doSomething((Integer)animation.getAnimatedValue());
            }
        });
        valueAnimator.start();
    }

    public static void cardFilpAnimation(final View beforeView, final View afterView) {
        AccelerateInterpolator accelerator = new AccelerateInterpolator();
        DecelerateInterpolator decelerator = new DecelerateInterpolator();
        ObjectAnimator invisToVis = null;
        ObjectAnimator visToInvis = null;
        if (beforeView.getVisibility() == 8) {
            invisToVis = ObjectAnimator.ofFloat((Object)beforeView, (String)"rotationY", (float[])new float[]{-90.0f, 0.0f});
            visToInvis = ObjectAnimator.ofFloat((Object)afterView, (String)"rotationY", (float[])new float[]{0.0f, 90.0f});
        } else if (afterView.getVisibility() == 8) {
            invisToVis = ObjectAnimator.ofFloat((Object)afterView, (String)"rotationY", (float[])new float[]{-90.0f, 0.0f});
            visToInvis = ObjectAnimator.ofFloat((Object)beforeView, (String)"rotationY", (float[])new float[]{0.0f, 90.0f});
        }
        visToInvis.setDuration(250L);
        visToInvis.setInterpolator((TimeInterpolator)accelerator);
        invisToVis.setDuration(250L);
        invisToVis.setInterpolator((TimeInterpolator)decelerator);
        final ObjectAnimator finalInvisToVis = invisToVis;
        final ObjectAnimator finalVisToInvis = visToInvis;
        visToInvis.addListener(new Animator.AnimatorListener(){

            public void onAnimationEnd(Animator arg0) {
                if (beforeView.getVisibility() == 8) {
                    afterView.setVisibility(8);
                    finalInvisToVis.start();
                    beforeView.setVisibility(0);
                } else {
                    afterView.setVisibility(8);
                    finalVisToInvis.start();
                    beforeView.setVisibility(0);
                }
            }

            public void onAnimationCancel(Animator arg0) {
            }

            public void onAnimationRepeat(Animator arg0) {
            }

            public void onAnimationStart(Animator arg0) {
            }
        });
        visToInvis.start();
    }

    public static void zoomIn(View view, float scale, float dist) {
        view.setPivotY((float)view.getHeight());
        view.setPivotX((float)(view.getWidth() / 2));
        AnimatorSet mAnimatorSet = new AnimatorSet();
        ObjectAnimator mAnimatorScaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{1.0f, scale});
        ObjectAnimator mAnimatorScaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{1.0f, scale});
        ObjectAnimator mAnimatorTranslateY = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{0.0f, -dist});
        mAnimatorSet.play((Animator)mAnimatorTranslateY).with((Animator)mAnimatorScaleX);
        mAnimatorSet.play((Animator)mAnimatorScaleX).with((Animator)mAnimatorScaleY);
        mAnimatorSet.setDuration(300L);
        mAnimatorSet.start();
    }

    public static void zoomOut(View view, float scale) {
        view.setPivotY((float)view.getHeight());
        view.setPivotX((float)(view.getWidth() / 2));
        AnimatorSet mAnimatorSet = new AnimatorSet();
        ObjectAnimator mAnimatorScaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{scale, 1.0f});
        ObjectAnimator mAnimatorScaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{scale, 1.0f});
        ObjectAnimator mAnimatorTranslateY = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{view.getTranslationY(), 0.0f});
        mAnimatorSet.play((Animator)mAnimatorTranslateY).with((Animator)mAnimatorScaleX);
        mAnimatorSet.play((Animator)mAnimatorScaleX).with((Animator)mAnimatorScaleY);
        mAnimatorSet.setDuration(300L);
        mAnimatorSet.start();
    }

    public static void ScaleUpDowm(View view) {
        ScaleAnimation animation = new ScaleAnimation(1.0f, 1.0f, 0.0f, 1.0f);
        animation.setRepeatCount(-1);
        animation.setRepeatMode(1);
        animation.setInterpolator((Interpolator)new LinearInterpolator());
        animation.setDuration(1200L);
        view.startAnimation((Animation)animation);
    }

    public static void animateHeight(int start, int end, final View view) {
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{start, end});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int value = (Integer)animation.getAnimatedValue();
                ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                layoutParams.height = value;
                view.setLayoutParams(layoutParams);
            }
        });
        valueAnimator.start();
    }

    public static ObjectAnimator popup(View view, long duration) {
        view.setAlpha(0.0f);
        view.setVisibility(0);
        ObjectAnimator popup = ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f, 1.0f}), PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{0.0f, 1.0f}), PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{0.0f, 1.0f})});
        popup.setDuration(duration);
        popup.setInterpolator((TimeInterpolator)new OvershootInterpolator());
        return popup;
    }

    public static ObjectAnimator popout(final View view, long duration, final AnimatorListenerAdapter animatorListenerAdapter) {
        ObjectAnimator popout = ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{1.0f, 0.0f}), PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{1.0f, 0.0f}), PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{1.0f, 0.0f})});
        popout.setDuration(duration);
        popout.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                view.setVisibility(8);
                if (animatorListenerAdapter != null) {
                    animatorListenerAdapter.onAnimationEnd(animation);
                }
            }
        });
        popout.setInterpolator((TimeInterpolator)new AnticipateOvershootInterpolator());
        return popout;
    }
}

