/*
 * Decompiled with CFR 0.152.
 */
package com.vondear.rxtool;

import android.annotation.SuppressLint;
import android.util.Log;
import com.vondear.rxtool.RxConstTool;
import com.vondear.rxtool.RxDataTool;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class RxTimeTool {
    public static final SimpleDateFormat DEFAULT_SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());

    public static String milliseconds2String(long milliseconds) {
        return RxTimeTool.milliseconds2String(milliseconds, DEFAULT_SDF);
    }

    public static String milliseconds2String(long milliseconds, SimpleDateFormat format) {
        return format.format(new Date(milliseconds));
    }

    public static long string2Milliseconds(String time) {
        return RxTimeTool.string2Milliseconds(time, DEFAULT_SDF);
    }

    public static long string2Milliseconds(String time, SimpleDateFormat format) {
        try {
            return format.parse(time).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public static Date string2Date(String time) {
        return RxTimeTool.string2Date(time, DEFAULT_SDF);
    }

    public static Date string2Date(String time, SimpleDateFormat format) {
        return new Date(RxTimeTool.string2Milliseconds(time, format));
    }

    public static String date2String(Date time) {
        return RxTimeTool.date2String(time, DEFAULT_SDF);
    }

    public static String date2String(Date time, SimpleDateFormat format) {
        return format.format(time);
    }

    public static long date2Milliseconds(Date time) {
        return time.getTime();
    }

    public static Date milliseconds2Date(long milliseconds) {
        return new Date(milliseconds);
    }

    public static long milliseconds2Unit(long milliseconds, RxConstTool.TimeUnit unit) {
        switch (unit) {
            case MSEC: {
                return milliseconds / 1L;
            }
            case SEC: {
                return milliseconds / 1000L;
            }
            case MIN: {
                return milliseconds / 60000L;
            }
            case HOUR: {
                return milliseconds / 3600000L;
            }
            case DAY: {
                return milliseconds / 86400000L;
            }
        }
        return -1L;
    }

    public static long getIntervalTime(String time0, String time1, RxConstTool.TimeUnit unit) {
        return RxTimeTool.getIntervalTime(time0, time1, unit, DEFAULT_SDF);
    }

    public static long getIntervalTime(String time0, String time1, RxConstTool.TimeUnit unit, SimpleDateFormat format) {
        return Math.abs(RxTimeTool.milliseconds2Unit(RxTimeTool.string2Milliseconds(time0, format) - RxTimeTool.string2Milliseconds(time1, format), unit));
    }

    public static long getIntervalTime(Date time1, Date time2, RxConstTool.TimeUnit unit) {
        return Math.abs(RxTimeTool.milliseconds2Unit(RxTimeTool.date2Milliseconds(time2) - RxTimeTool.date2Milliseconds(time1), unit));
    }

    public static long getCurTimeMills() {
        return System.currentTimeMillis();
    }

    public static String getCurTimeString() {
        return RxTimeTool.date2String(new Date());
    }

    public static String getCurTimeString(SimpleDateFormat format) {
        return RxTimeTool.date2String(new Date(), format);
    }

    public static Date getCurTimeDate() {
        return new Date();
    }

    public static long getIntervalByNow(String time, RxConstTool.TimeUnit unit) {
        return RxTimeTool.getIntervalByNow(time, unit, DEFAULT_SDF);
    }

    public static long getIntervalByNow(String time, RxConstTool.TimeUnit unit, SimpleDateFormat format) {
        return RxTimeTool.getIntervalTime(RxTimeTool.getCurTimeString(), time, unit, format);
    }

    public static long getIntervalByNow(Date time, RxConstTool.TimeUnit unit) {
        return RxTimeTool.getIntervalTime(RxTimeTool.getCurTimeDate(), time, unit);
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static String simpleDateFormat(String format, Date date) {
        if (RxDataTool.isNullString(format)) {
            format = "yyyy-MM-dd HH:mm:ss SSS";
        }
        String content = new SimpleDateFormat(format).format(date);
        return content;
    }

    public static String Date2Timestamp(Date mDate) {
        return String.valueOf(mDate.getTime()).substring(0, 10);
    }

    public static Date string2Date(String format, String datess) {
        SimpleDateFormat sdr = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = sdr.parse(datess);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String string2Timestamp(String format, String datess) {
        Date date = RxTimeTool.string2Date(format, datess);
        return RxTimeTool.Date2Timestamp(date);
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static String getCurrentDateTime(String format) {
        return RxTimeTool.simpleDateFormat(format, new Date());
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static String getDate(String times, String format) {
        return RxTimeTool.simpleDateFormat(format, new Date((long)RxDataTool.stringToInt(times) * 1000L));
    }

    public static String getYestoryDate(String format) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        return RxTimeTool.simpleDateFormat(format, calendar.getTime());
    }

    public static String formatTime(long milliseconds) {
        String format = "mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        String video_time = sdf.format(milliseconds);
        return video_time;
    }

    public static long formatSeconds(String time) {
        String format = "mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        long times = 0L;
        try {
            long l;
            Date date = sdf.parse(time);
            times = l = date.getTime();
            Log.d((String)"\u65f6\u95f4\u6233", (String)(times + ""));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return times;
    }

    public static int getDaysByYearMonth(int year, int month) {
        Calendar a = Calendar.getInstance();
        a.set(1, year);
        a.set(2, month - 1);
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }

    public static int stringForWeek(String strDate) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.setTime(format.parse(strDate));
        if (c.get(7) == 1) {
            return 7;
        }
        return c.get(7) - 1;
    }

    public static int stringForWeek(String strDate, SimpleDateFormat simpleDateFormat) throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTime(simpleDateFormat.parse(strDate));
        if (c.get(7) == 1) {
            return 7;
        }
        return c.get(7) - 1;
    }
}

