/*
 * Decompiled with CFR 0.152.
 */
package com.vondear.rxtool;

import android.location.Location;
import android.media.ExifInterface;
import com.orhanobut.logger.Logger;
import java.io.File;

public class RxExifTool {
    public static void writeLatLonIntoJpeg(String picPath, double dLat, double dLon) {
        File file = new File(picPath);
        if (file.exists()) {
            try {
                ExifInterface exif = new ExifInterface(picPath);
                String tagLat = exif.getAttribute("GPSLatitude");
                String tagLon = exif.getAttribute("GPSLongitude");
                if (tagLat == null && tagLon == null) {
                    exif.setAttribute("GPSLatitude", RxExifTool.gpsInfoConvert(dLat));
                    exif.setAttribute("GPSLatitudeRef", dLat > 0.0 ? "N" : "S");
                    exif.setAttribute("GPSLongitude", RxExifTool.gpsInfoConvert(dLon));
                    exif.setAttribute("GPSLongitudeRef", dLon > 0.0 ? "E" : "W");
                    exif.saveAttributes();
                }
                exif.saveAttributes();
                Logger.d((Object)(exif.getAttribute("GPSLatitude") + "\n" + exif.getAttribute("GPSLongitude") + "\n" + exif.getAttribute("GPSProcessingMethod") + "\n" + exif.getAttribute("ImageLength") + "\n" + exif.getAttribute("ImageWidth")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String gpsInfoConvert(double gpsInfo) {
        String dms = Location.convert((double)(gpsInfo = Math.abs(gpsInfo)), (int)2);
        String[] splits = dms.split(":");
        String[] secnds = splits[2].split("\\.");
        String seconds = secnds.length == 0 ? splits[2] : secnds[0];
        return splits[0] + "/1," + splits[1] + "/1," + seconds + "/1";
    }
}

