/*
 * Decompiled with CFR 0.152.
 */
package com.vondear.rxtool;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import com.vondear.rxtool.RxIntentTool;
import java.util.List;
import java.util.Stack;

public class RxActivityTool {
    private static Stack<Activity> activityStack;

    public static void addActivity(Activity activity) {
        if (activityStack == null) {
            activityStack = new Stack();
        }
        activityStack.add(activity);
    }

    public static Activity currentActivity() {
        Activity activity = (Activity)activityStack.lastElement();
        return activity;
    }

    public static void finishActivity() {
        Activity activity = (Activity)activityStack.lastElement();
    }

    public static void finishActivity(Activity activity) {
        if (activity != null) {
            activityStack.remove(activity);
            activity.finish();
            activity = null;
        }
    }

    public static void finishActivity(Class<?> cls) {
        for (Activity activity : activityStack) {
            if (!activity.getClass().equals(cls)) continue;
            RxActivityTool.finishActivity(activity);
        }
    }

    public static void finishAllActivity() {
        int size = activityStack.size();
        for (int i = 0; i < size; ++i) {
            if (null == activityStack.get(i)) continue;
            ((Activity)activityStack.get(i)).finish();
        }
        activityStack.clear();
    }

    public static void AppExit(Context context) {
        try {
            RxActivityTool.finishAllActivity();
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            activityManager.restartPackage(context.getPackageName());
            System.exit(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Stack<Activity> getActivityStack() {
        return activityStack;
    }

    public static boolean isExistActivity(Context context, String packageName, String className) {
        Intent intent = new Intent();
        intent.setClassName(packageName, className);
        return context.getPackageManager().resolveActivity(intent, 0) != null && intent.resolveActivity(context.getPackageManager()) != null && context.getPackageManager().queryIntentActivities(intent, 0).size() != 0;
    }

    public static void launchActivity(Context context, String packageName, String className) {
        RxActivityTool.launchActivity(context, packageName, className, null);
    }

    public static void launchActivity(Context context, String packageName, String className, Bundle bundle) {
        context.startActivity(RxIntentTool.getComponentNameIntent(packageName, className, bundle));
    }

    public static void skipActivityAndFinishAll(Context context, Class<?> goal, Bundle bundle) {
        Intent intent = new Intent(context, goal);
        intent.putExtras(bundle);
        intent.setFlags(0x10008000);
        context.startActivity(intent);
        ((Activity)context).finish();
    }

    public static void skipActivityAndFinishAll(Context context, Class<?> goal) {
        Intent intent = new Intent(context, goal);
        intent.setFlags(0x10008000);
        context.startActivity(intent);
        ((Activity)context).finish();
    }

    public static void skipActivityAndFinish(Context context, Class<?> goal, Bundle bundle) {
        Intent intent = new Intent(context, goal);
        intent.putExtras(bundle);
        context.startActivity(intent);
        ((Activity)context).finish();
    }

    public static void skipActivityAndFinish(Context context, Class<?> goal) {
        Intent intent = new Intent(context, goal);
        context.startActivity(intent);
        ((Activity)context).finish();
    }

    public static void skipActivity(Context context, Class<?> goal) {
        Intent intent = new Intent(context, goal);
        context.startActivity(intent);
    }

    public static void skipActivity(Context context, Class<?> goal, Bundle bundle) {
        Intent intent = new Intent(context, goal);
        intent.putExtras(bundle);
        context.startActivity(intent);
    }

    public static void skipActivityForResult(Activity context, Class<?> goal, int requestCode) {
        Intent intent = new Intent((Context)context, goal);
        context.startActivityForResult(intent, requestCode);
    }

    public static void skipActivityForResult(Activity context, Class<?> goal, Bundle bundle, int requestCode) {
        Intent intent = new Intent((Context)context, goal);
        intent.putExtras(bundle);
        context.startActivityForResult(intent, requestCode);
    }

    public static String getLauncherActivity(Context context, String packageName) {
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.addCategory("android.intent.category.LAUNCHER");
        PackageManager pm = context.getPackageManager();
        List infos = pm.queryIntentActivities(intent, 0);
        for (ResolveInfo info : infos) {
            if (!info.activityInfo.packageName.equals(packageName)) continue;
            return info.activityInfo.name;
        }
        return "no " + packageName;
    }
}

