/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit.demodata.bank;

import com.tamsiree.rxkit.demodata.kit.LuhnUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/tamsiree/rxkit/demodata/bank/BankCardNumberValidator;", "", "()V", "validate", "", "cardNo", "", "RxKit_release"})
public final class BankCardNumberValidator {
    @NotNull
    public static final BankCardNumberValidator INSTANCE = new BankCardNumberValidator();

    private BankCardNumberValidator() {
    }

    public final boolean validate(@NotNull String cardNo) {
        Intrinsics.checkNotNullParameter((Object)cardNo, (String)"cardNo");
        if (StringUtils.isEmpty((CharSequence)cardNo)) {
            return false;
        }
        if (!NumberUtils.isDigits((String)cardNo)) {
            return false;
        }
        if (cardNo.length() > 19 || cardNo.length() < 16) {
            return false;
        }
        String string2 = cardNo;
        int n = 0;
        int n2 = cardNo.length() - 1;
        boolean bl = false;
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String $this$trim$iv = string3;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl2 = false;
            boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        $this$trim$iv = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        n = 0;
        String string4 = $this$trim$iv;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string4.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        int luhnSum = LuhnUtils.getLuhnSum(cArray);
        char checkCode = luhnSum % 10 == 0 ? (char)'0' : (char)(10 - luhnSum % 10 + 48);
        String string5 = cardNo;
        int n3 = cardNo.length() - 1;
        bl = false;
        String string6 = string5.substring(n3);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
        return string6.charAt(0) == checkCode;
    }
}

