/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.tamsiree.rxkit.RxDataTool;
import com.tamsiree.rxkit.RxFileTool;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.progress.ProgressMonitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000267B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\bH\u0002J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0007J\u001a\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00182\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u001a\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u0007J\u0018\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0018\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u0007J\u001a\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00182\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u001a\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u0007J\u001a\u0010\u001c\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\bH\u0007J\u001c\u0010\u001f\u001a\u00020\u000e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010 \u001a\u0004\u0018\u00010\u0006H\u0007J\u001c\u0010\u001f\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\b2\b\u0010!\u001a\u0004\u0018\u00010\bH\u0007J.\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00182\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010 \u001a\u0004\u0018\u00010\u00062\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0007J.\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\b2\b\u0010!\u001a\u0004\u0018\u00010\b2\b\u0010#\u001a\u0004\u0018\u00010\bH\u0007J$\u0010$\u001a\u00020\u000e2\u0010\u0010%\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010&2\b\u0010 \u001a\u0004\u0018\u00010\u0006H\u0007J$\u0010$\u001a\u00020\u000e2\u0010\u0010%\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010&2\b\u0010!\u001a\u0004\u0018\u00010\bH\u0007J,\u0010'\u001a\u0004\u0018\u00010\b2\b\u0010(\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\bH\u0007J4\u0010*\u001a\u0004\u0018\u00010\b2\b\u0010(\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010+\u001a\u00020,H\u0007J*\u0010\u0005\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\bH\u0002J(\u0010\u0005\u001a\u00020\u000e2\b\u0010-\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u00101\u001a\u0004\u0018\u00010\bH\u0007J(\u0010\u0005\u001a\u00020\u000e2\b\u00102\u001a\u0004\u0018\u00010\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\b2\n\b\u0002\u00101\u001a\u0004\u0018\u00010\bH\u0007J.\u0010%\u001a\u00020\u000e2\u000e\u00103\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010&2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u00101\u001a\u0004\u0018\u00010\bH\u0007J.\u0010%\u001a\u00020\u000e2\u000e\u00103\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010&2\b\u0010\u0015\u001a\u0004\u0018\u00010\b2\n\b\u0002\u00101\u001a\u0004\u0018\u00010\bH\u0007J\u0012\u00104\u001a\u0002052\b\u0010\u0005\u001a\u0004\u0018\u00010\bH\u0007\u00a8\u00068"}, d2={"Lcom/tamsiree/rxkit/RxZipTool;", "", "()V", "Unzip", "", "zipFile", "Ljava/io/File;", "dest", "", "passwd", "charset", "handler", "Landroid/os/Handler;", "isDeleteZipFile", "", "buildDestinationZipFilePath", "srcFile", "destParam", "createDestDirectoryIfNecessary", "fileToZip", "sourceFilePath", "zipFilePath", "fileName", "getComments", "", "getEntries", "Ljava/util/Enumeration;", "getFilesPath", "removeDirFromZipArchive", "file", "removeDir", "unzipFile", "destDir", "destDirPath", "unzipFileByKeyword", "keyword", "unzipFiles", "zipFiles", "", "zipEncrypt", "src", "isCreateDir", "zipEncryptRargo", "unit", "", "resFile", "rootPath", "zos", "Ljava/util/zip/ZipOutputStream;", "comment", "resFilePath", "resFiles", "zipInfo", "", "CompressKeys", "CompressStatus", "RxKit_release"})
public final class RxZipTool {
    @NotNull
    public static final RxZipTool INSTANCE = new RxZipTool();

    private RxZipTool() {
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean zipFiles(@Nullable Collection<? extends File> resFiles, @Nullable String zipFilePath, @Nullable String comment) throws IOException {
        return RxZipTool.zipFiles(resFiles, RxFileTool.Companion.getFileByPath(zipFilePath), comment);
    }

    public static /* synthetic */ boolean zipFiles$default(Collection collection, String string, String string2, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return RxZipTool.zipFiles((Collection<? extends File>)collection, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @JvmOverloads
    public static final boolean zipFiles(@Nullable Collection<? extends File> resFiles, @Nullable File zipFile, @Nullable String comment) throws IOException {
        boolean closeableArray;
        if (resFiles == null || zipFile == null) {
            return false;
        }
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(zipFile));
            for (File closeableArray2 : resFiles) {
                if (INSTANCE.zipFile(closeableArray2, "", zos, comment)) continue;
                closeableArray = false;
            }
        }
        catch (Throwable throwable) {
            if (zos != null) {
                zos.finish();
                Closeable[] closeableArray3 = new Closeable[]{zos};
                RxFileTool.Companion.closeIO(closeableArray3);
            }
            throw throwable;
        }
        {
            zos.finish();
            Closeable[] closeableArray4 = new Closeable[]{zos};
            RxFileTool.Companion.closeIO(closeableArray4);
            return closeableArray;
        }
        boolean bl2 = true;
        zos.finish();
        Closeable[] throwable = new Closeable[]{zos};
        RxFileTool.Companion.closeIO(throwable);
        return bl2;
    }

    public static /* synthetic */ boolean zipFiles$default(Collection collection, File file, String string, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            string = null;
        }
        return RxZipTool.zipFiles((Collection<? extends File>)collection, file, string);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean zipFile(@Nullable String resFilePath, @Nullable String zipFilePath, @Nullable String comment) throws IOException {
        return RxZipTool.zipFile(RxFileTool.Companion.getFileByPath(resFilePath), RxFileTool.Companion.getFileByPath(zipFilePath), comment);
    }

    public static /* synthetic */ boolean zipFile$default(String string, String string2, String string3, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return RxZipTool.zipFile(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @JvmOverloads
    public static final boolean zipFile(@Nullable File resFile, @Nullable File zipFile, @Nullable String comment) throws IOException {
        boolean bl;
        if (resFile == null || zipFile == null) {
            return false;
        }
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(zipFile));
            bl = INSTANCE.zipFile(resFile, "", zos, comment);
        }
        catch (Throwable throwable) {
            if (zos != null) {
                zos.finish();
                Closeable[] closeableArray = new Closeable[]{zos};
                RxFileTool.Companion.closeIO(closeableArray);
            }
            throw throwable;
        }
        zos.finish();
        Closeable[] closeableArray = new Closeable[]{zos};
        RxFileTool.Companion.closeIO(closeableArray);
        return bl;
    }

    public static /* synthetic */ boolean zipFile$default(File file, File file2, String string, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            string = null;
        }
        return RxZipTool.zipFile(file, file2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean zipFile(File resFile, String rootPath, ZipOutputStream zos, String comment) throws IOException {
        String rootPath2 = rootPath;
        rootPath2 = rootPath2 + (RxDataTool.Companion.isNullString(rootPath2) ? "" : File.separator) + resFile.getName();
        if (resFile.isDirectory()) {
            File file;
            File[] fileList = resFile.listFiles();
            if (fileList.length <= 0) {
                ZipEntry entry = new ZipEntry(Intrinsics.stringPlus((String)rootPath2, (Object)"/"));
                if (!RxDataTool.Companion.isNullString(comment)) {
                    entry.setComment(comment);
                }
                zos.putNextEntry(entry);
                zos.closeEntry();
                return true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)fileList, (String)"fileList");
            File[] entry = fileList;
            int n = 0;
            int n2 = entry.length;
            do {
                if (n >= n2) return true;
                file = entry[n];
                ++n;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
            } while (this.zipFile(file, rootPath2, zos, comment));
            return false;
        }
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(resFile));
            ZipEntry entry = new ZipEntry(rootPath2);
            if (!RxDataTool.Companion.isNullString(comment)) {
                entry.setComment(comment);
            }
            zos.putNextEntry(entry);
            byte[] buffer = new byte[1024];
            int len = 0;
            while (true) {
                int n = ((BufferedInputStream)is).read(buffer, 0, 1024);
                boolean bl = false;
                boolean bl2 = false;
                int it = n;
                boolean bl3 = false;
                len = it;
                if (n == -1) break;
                zos.write(buffer, 0, len);
            }
            zos.closeEntry();
        }
        catch (Throwable throwable) {
            Closeable[] closeableArray = new Closeable[]{is};
            RxFileTool.Companion.closeIO(closeableArray);
            throw throwable;
        }
        Closeable[] closeableArray = new Closeable[]{is};
        RxFileTool.Companion.closeIO(closeableArray);
        return true;
    }

    @JvmStatic
    public static final boolean unzipFiles(@Nullable Collection<? extends File> zipFiles, @Nullable String destDirPath) {
        return RxZipTool.unzipFiles(zipFiles, RxFileTool.Companion.getFileByPath(destDirPath));
    }

    @JvmStatic
    public static final boolean unzipFiles(@Nullable Collection<? extends File> zipFiles, @Nullable File destDir) {
        if (zipFiles == null || destDir == null) {
            return false;
        }
        for (File file : zipFiles) {
            if (RxZipTool.unzipFile(file, destDir)) continue;
            return false;
        }
        return true;
    }

    @JvmStatic
    public static final boolean unzipFile(@Nullable String zipFilePath, @Nullable String destDirPath) {
        return RxZipTool.unzipFile(RxFileTool.Companion.getFileByPath(zipFilePath), RxFileTool.Companion.getFileByPath(destDirPath));
    }

    @JvmStatic
    public static final boolean unzipFile(@Nullable File zipFile, @Nullable File destDir) {
        return RxZipTool.unzipFileByKeyword(zipFile, destDir, null) != null;
    }

    @JvmStatic
    @Nullable
    public static final List<File> unzipFileByKeyword(@Nullable String zipFilePath, @Nullable String destDirPath, @Nullable String keyword) {
        return RxZipTool.unzipFileByKeyword(RxFileTool.Companion.getFileByPath(zipFilePath), RxFileTool.Companion.getFileByPath(destDirPath), keyword);
    }

    @JvmStatic
    @Nullable
    public static final List<File> unzipFileByKeyword(@Nullable File zipFile, @Nullable File destDir, @Nullable String passwd) {
        List list;
        try {
            if (zipFile == null) {
                throw new ZipException("\u538b\u7f29\u6587\u4ef6\u4e0d\u5b58\u5728.");
            }
            if (destDir == null) {
                throw new ZipException("\u89e3\u538b\u7f29\u8def\u5f84\u4e0d\u5b58\u5728.");
            }
            if (destDir.isDirectory() && !destDir.exists()) {
                destDir.mkdir();
            }
            ZipFile zFile = new ZipFile(zipFile);
            zFile.setFileNameCharset("UTF-8");
            if (!zFile.isValidZipFile()) {
                throw new ZipException("\u538b\u7f29\u6587\u4ef6\u4e0d\u5408\u6cd5,\u53ef\u80fd\u88ab\u635f\u574f.");
            }
            if (zFile.isEncrypted()) {
                Intrinsics.checkNotNull((Object)passwd);
                String string = passwd;
                boolean bl = false;
                char[] cArray = string.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                zFile.setPassword(cArray);
            }
            zFile.extractAll(destDir.getAbsolutePath());
            List list2 = zFile.getFileHeaders();
            if (list2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<net.lingala.zip4j.model.FileHeader?>");
            }
            List headerList = TypeIntrinsics.asMutableList((Object)list2);
            List extractedFileList = new ArrayList();
            for (FileHeader fileHeader : headerList) {
                Intrinsics.checkNotNull((Object)fileHeader);
                if (fileHeader.isDirectory()) continue;
                extractedFileList.add(new File(destDir, fileHeader.getFileName()));
            }
            list = extractedFileList;
        }
        catch (ZipException e) {
            e.printStackTrace();
            list = null;
        }
        return list;
    }

    @JvmStatic
    @Nullable
    public static final List<String> getFilesPath(@Nullable String zipFilePath) throws IOException {
        return RxZipTool.getFilesPath(RxFileTool.Companion.getFileByPath(zipFilePath));
    }

    @JvmStatic
    @Nullable
    public static final List<String> getFilesPath(@Nullable File zipFile) throws IOException {
        if (zipFile == null) {
            return null;
        }
        List paths = new ArrayList();
        Enumeration<?> entries = RxZipTool.getEntries(zipFile);
        while (true) {
            Intrinsics.checkNotNull(entries);
            if (!entries.hasMoreElements()) break;
            Object obj = entries.nextElement();
            if (obj == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.util.zip.ZipEntry");
            }
            String string = ((ZipEntry)obj).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entries.nextElement() as ZipEntry).name");
            paths.add(string);
        }
        return paths;
    }

    @JvmStatic
    @Nullable
    public static final List<String> getComments(@Nullable String zipFilePath) throws IOException {
        return RxZipTool.getComments(RxFileTool.Companion.getFileByPath(zipFilePath));
    }

    @JvmStatic
    @Nullable
    public static final List<String> getComments(@Nullable File zipFile) throws IOException {
        if (zipFile == null) {
            return null;
        }
        List comments = new ArrayList();
        Enumeration<?> entries = RxZipTool.getEntries(zipFile);
        while (true) {
            Intrinsics.checkNotNull(entries);
            if (!entries.hasMoreElements()) break;
            Object object = entries.nextElement();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.util.zip.ZipEntry");
            }
            ZipEntry entry = (ZipEntry)object;
            object = entry.getComment();
            Intrinsics.checkNotNullExpressionValue(object, (String)"entry.comment");
            comments.add(object);
        }
        return comments;
    }

    @JvmStatic
    @Nullable
    public static final Enumeration<?> getEntries(@Nullable String zipFilePath) throws IOException {
        return RxZipTool.getEntries(RxFileTool.Companion.getFileByPath(zipFilePath));
    }

    @JvmStatic
    @Nullable
    public static final Enumeration<?> getEntries(@Nullable File zipFile) throws IOException {
        return zipFile == null ? (Enumeration<? extends ZipEntry>)null : new java.util.zip.ZipFile(zipFile).entries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final boolean fileToZip(@NotNull String sourceFilePath, @NotNull String zipFilePath, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)sourceFilePath, (String)"sourceFilePath");
        Intrinsics.checkNotNullParameter((Object)zipFilePath, (String)"zipFilePath");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        boolean flag = false;
        File sourceFile = new File(sourceFilePath);
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        if (sourceFile.exists()) {
            try {
                File zipFile = new File(zipFilePath + '/' + fileName + ".zip");
                if (zipFile.exists()) {
                    String string = zipFilePath + "\u76ee\u5f55\u4e0b\u5b58\u5728\u540d\u5b57\u4e3a:" + fileName + ".zip\u6253\u5305\u6587\u4ef6.";
                    boolean bl = false;
                    System.out.println((Object)string);
                }
                File[] sourceFiles = sourceFile.listFiles();
                if (sourceFiles == null || sourceFiles.length < 1) {
                    String string = "\u5f85\u538b\u7f29\u7684\u6587\u4ef6\u76ee\u5f55\uff1a" + sourceFilePath + "\u91cc\u9762\u4e0d\u5b58\u5728\u6587\u4ef6\uff0c\u65e0\u9700\u538b\u7f29.";
                    boolean bl = false;
                    System.out.println((Object)string);
                }
                fos = new FileOutputStream(zipFile);
                zos = new ZipOutputStream(new BufferedOutputStream(fos));
                byte[] bufs = new byte[10240];
                int n = 0;
                int n2 = sourceFiles.length + -1;
                if (n <= n2) {
                    block9: do {
                        int i = n++;
                        ZipEntry zipEntry = new ZipEntry(sourceFiles[i].getName());
                        fis = new FileInputStream(sourceFiles[i]);
                        bis = new BufferedInputStream(fis, 10240);
                        int read = 0;
                        while (true) {
                            int n3 = bis.read(bufs, 0, 10240);
                            boolean bl = false;
                            boolean bl2 = false;
                            int it = n3;
                            boolean bl3 = false;
                            read = it;
                            if (n3 == -1) continue block9;
                            zos.write(bufs, 0, read);
                        }
                    } while (n <= n2);
                }
                flag = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            finally {
                try {
                    BufferedInputStream sourceFiles = bis;
                    if (sourceFiles != null) {
                        sourceFiles.close();
                    }
                    sourceFiles = zos;
                    if (sourceFiles != null) {
                        ((ZipOutputStream)((Object)sourceFiles)).close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        } else {
            String string = "\u5f85\u538b\u7f29\u7684\u6587\u4ef6\u76ee\u5f55\uff1a" + sourceFilePath + "\u4e0d\u5b58\u5728.";
            boolean bl = false;
            System.out.println((Object)string);
        }
        return flag;
    }

    @JvmStatic
    @Nullable
    public static final String zipEncrypt(@Nullable String src, @NotNull String dest, boolean isCreateDir, @NotNull String passwd) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)passwd, (String)"passwd");
        String dest2 = dest;
        File srcFile = new File(src);
        dest2 = INSTANCE.buildDestinationZipFilePath(srcFile, dest2);
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(8);
        parameters.setCompressionLevel(5);
        if (!RxDataTool.Companion.isNullString(passwd)) {
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(0);
            String string = passwd;
            boolean bl = false;
            char[] cArray = string.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            parameters.setPassword(cArray);
        }
        try {
            ZipFile zipFile = new ZipFile(dest2);
            if (srcFile.isDirectory()) {
                if (!isCreateDir) {
                    File[] subFiles = srcFile.listFiles();
                    ArrayList temp = new ArrayList();
                    Collections.addAll(temp, Arrays.copyOf(subFiles, subFiles.length));
                    zipFile.addFiles(temp, parameters);
                    return dest2;
                }
                zipFile.addFolder(srcFile, parameters);
            } else {
                zipFile.addFile(srcFile, parameters);
            }
            return dest2;
        }
        catch (ZipException e) {
            e.printStackTrace();
            return null;
        }
    }

    private final String buildDestinationZipFilePath(File srcFile, String destParam) {
        String destParam2 = destParam;
        if (RxDataTool.Companion.isNullString(destParam2)) {
            String string;
            if (srcFile.isDirectory()) {
                string = srcFile.getParent() + File.separator + srcFile.getName() + ".zip";
            } else {
                String string2 = srcFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"srcFile.name");
                int n = 0;
                String string3 = srcFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"srcFile.name");
                int n2 = StringsKt.lastIndexOf$default((CharSequence)string3, (String)".", (int)0, (boolean)false, (int)6, null);
                boolean bl = false;
                String string4 = string2.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String fileName = string4;
                string = srcFile.getParent() + File.separator + fileName + ".zip";
            }
            destParam2 = string;
        } else {
            this.createDestDirectoryIfNecessary(destParam2);
            String fileName = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)fileName, (String)"separator");
            if (StringsKt.endsWith$default((String)destParam2, (String)fileName, (boolean)false, (int)2, null)) {
                String string;
                String string5;
                fileName = "";
                if (srcFile.isDirectory()) {
                    string5 = srcFile.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"{\n                    srcFile.name\n                }");
                    string = string5;
                } else {
                    string5 = srcFile.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"srcFile.name");
                    int n = 0;
                    String string6 = srcFile.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"srcFile.name");
                    int n3 = StringsKt.lastIndexOf$default((CharSequence)string6, (String)".", (int)0, (boolean)false, (int)6, null);
                    boolean bl = false;
                    String string7 = string5.substring(n, n3);
                    string = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                }
                fileName = string;
                destParam2 = destParam2 + fileName + ".zip";
            }
        }
        return destParam2;
    }

    private final void createDestDirectoryIfNecessary(String destParam) {
        File file;
        File destDir = null;
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        if (StringsKt.endsWith$default((String)destParam, (String)string, (boolean)false, (int)2, null)) {
            file = new File(destParam);
        } else {
            string = destParam;
            int n = 0;
            CharSequence charSequence = destParam;
            String string2 = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
            int n2 = StringsKt.lastIndexOf$default((CharSequence)charSequence, (String)string2, (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            String string3 = string;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            file = destDir = new File(string4);
        }
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
    }

    @JvmStatic
    @Nullable
    public static final String zipEncryptRargo(@Nullable String src, @NotNull String dest, boolean isCreateDir, @NotNull String passwd, int unit) {
        String string;
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)passwd, (String)"passwd");
        String dest2 = dest;
        File srcFile = new File(src);
        dest2 = INSTANCE.buildDestinationZipFilePath(srcFile, dest2);
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(8);
        parameters.setCompressionLevel(5);
        if (!RxDataTool.Companion.isNullString(passwd)) {
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(0);
            string = passwd;
            boolean bl = false;
            char[] cArray = string.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            parameters.setPassword(cArray);
        }
        try {
            ZipFile zipFile = new ZipFile(dest2);
            if (srcFile.isDirectory()) {
                if (!isCreateDir) {
                    File[] subFiles = srcFile.listFiles();
                    ArrayList temp = new ArrayList();
                    Collections.addAll(temp, Arrays.copyOf(subFiles, subFiles.length));
                    zipFile.createZipFile(temp, parameters, true, (long)unit * 1000L);
                    return dest2;
                }
                zipFile.createZipFileFromFolder(srcFile, parameters, true, (long)unit * 1000L);
                int partsize = (int)RxZipTool.zipInfo(dest2) / unit;
                String string2 = "\u5206\u5272\u6210\u529f\uff01\u603b\u5171\u5206\u5272\u6210\u4e86" + (partsize + 1) + "\u4e2a\u6587\u4ef6\uff01";
                boolean bl = false;
                System.out.println((Object)string2);
            } else {
                zipFile.createZipFile(srcFile, parameters, true, (long)unit * 1000L);
            }
            string = dest2;
        }
        catch (ZipException var9) {
            var9.printStackTrace();
            string = null;
        }
        return string;
    }

    @JvmStatic
    public static final double zipInfo(@Nullable String zipFile) throws ZipException {
        ZipFile zip = new ZipFile(zipFile);
        zip.setFileNameCharset("GBK");
        List list = zip.getFileHeaders();
        if (list == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<net.lingala.zip4j.model.FileHeader?>");
        }
        List list2 = TypeIntrinsics.asMutableList((Object)list);
        long zipCompressedSize = 0L;
        for (FileHeader head : list2) {
            Intrinsics.checkNotNull((Object)head);
            zipCompressedSize += head.getCompressedSize();
        }
        return (double)zipCompressedSize / 1.0 / (double)1024;
    }

    @JvmStatic
    public static final boolean removeDirFromZipArchive(@Nullable String file, @NotNull String removeDir) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)removeDir, (String)"removeDir");
        String removeDir2 = removeDir;
        try {
            FileHeader fileHeader;
            ZipFile zipFile = new ZipFile(file);
            zipFile.setFileNameCharset("GBK");
            String string = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
            if (!StringsKt.endsWith$default((String)removeDir2, (String)string, (boolean)false, (int)2, null)) {
                removeDir2 = Intrinsics.stringPlus((String)removeDir2, (Object)File.separator);
            }
            if ((fileHeader = zipFile.getFileHeader(removeDir2)) == null) {
                return false;
            }
            FileHeader dirHeader = fileHeader;
            List headersList = zipFile.getFileHeaders();
            List removeHeaderNames = new ArrayList();
            int i = 0;
            int len = headersList.size();
            while (i < len) {
                Object object = headersList.get(i);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type net.lingala.zip4j.model.FileHeader");
                }
                FileHeader subHeader = (FileHeader)object;
                object = subHeader.getFileName();
                Intrinsics.checkNotNullExpressionValue(object, (String)"subHeader.fileName");
                Object object2 = object;
                object = dirHeader.getFileName();
                Intrinsics.checkNotNullExpressionValue(object, (String)"dirHeader.fileName");
                if (StringsKt.startsWith$default(object2, object, (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)subHeader.getFileName(), (Object)dirHeader.getFileName())) {
                    object = subHeader.getFileName();
                    Intrinsics.checkNotNullExpressionValue(object, (String)"subHeader.fileName");
                    removeHeaderNames.add(object);
                }
                int n = i;
                i = n + 1;
            }
            for (String headerNameString : removeHeaderNames) {
                zipFile.removeFile(headerNameString);
            }
            zipFile.removeFile(dirHeader);
            bl = true;
        }
        catch (ZipException e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final void Unzip(@NotNull File zipFile, @Nullable String dest, @NotNull String passwd, @Nullable String charset, @Nullable Handler handler, boolean isDeleteZipFile) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter((Object)passwd, (String)"passwd");
        String charset2 = charset;
        try {
            ZipFile zFile = new ZipFile(zipFile);
            if (TextUtils.isEmpty((CharSequence)charset2)) {
                charset2 = "UTF-8";
            }
            zFile.setFileNameCharset(charset2);
            if (!zFile.isValidZipFile()) {
                throw new ZipException("Compressed files are not illegal, may be damaged.");
            }
            File destDir = new File(dest);
            if (destDir.isDirectory() && !destDir.exists()) {
                destDir.mkdir();
            }
            if (zFile.isEncrypted()) {
                String string = passwd;
                boolean bl = false;
                char[] cArray = string.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                zFile.setPassword(cArray);
            }
            ProgressMonitor progressMonitor = zFile.getProgressMonitor();
            Thread progressThread = new Thread(() -> RxZipTool.Unzip$lambda-2(handler, progressMonitor, isDeleteZipFile, zipFile));
            progressThread.start();
            zFile.setRunInThread(true);
            zFile.extractAll(dest);
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean zipFiles(@Nullable Collection<? extends File> resFiles, @Nullable String zipFilePath) throws IOException {
        return RxZipTool.zipFiles$default(resFiles, zipFilePath, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean zipFiles(@Nullable Collection<? extends File> resFiles, @Nullable File zipFile) throws IOException {
        return RxZipTool.zipFiles$default(resFiles, zipFile, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean zipFile(@Nullable String resFilePath, @Nullable String zipFilePath) throws IOException {
        return RxZipTool.zipFile$default(resFilePath, zipFilePath, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean zipFile(@Nullable File resFile, @Nullable File zipFile) throws IOException {
        return RxZipTool.zipFile$default(resFile, zipFile, null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void Unzip$lambda-2(Handler $handler, ProgressMonitor $progressMonitor, boolean $isDeleteZipFile, File $zipFile) {
        Intrinsics.checkNotNullParameter((Object)$zipFile, (String)"$zipFile");
        Bundle bundle = null;
        Message msg = null;
        try {
            int percentDone = 0;
            if ($handler == null) {
                return;
            }
            $handler.sendEmptyMessage(0);
            do {
                Thread.sleep(1000L);
                percentDone = $progressMonitor.getPercentDone();
                bundle = new Bundle();
                bundle.putInt("PERCENT", percentDone);
                msg = new Message();
                msg.what = 1;
                msg.setData(bundle);
                $handler.sendMessage(msg);
            } while (percentDone < 100);
            $handler.sendEmptyMessage(2);
        }
        catch (InterruptedException e) {
            bundle = new Bundle();
            bundle.putString("ERROR", e.getMessage());
            msg = new Message();
            msg.what = 3;
            msg.setData(bundle);
            Intrinsics.checkNotNull((Object)$handler);
            $handler.sendMessage(msg);
            e.printStackTrace();
        }
        finally {
            if ($isDeleteZipFile) {
                $zipFile.deleteOnExit();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/tamsiree/rxkit/RxZipTool$CompressStatus;", "", "()V", "COMPLETED", "", "ERROR", "HANDLING", "START", "RxKit_release"})
    public static final class CompressStatus {
        @NotNull
        public static final CompressStatus INSTANCE = new CompressStatus();
        public static final int START = 0;
        public static final int HANDLING = 1;
        public static final int COMPLETED = 2;
        public static final int ERROR = 3;

        private CompressStatus() {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/tamsiree/rxkit/RxZipTool$CompressKeys;", "", "()V", "ERROR", "", "PERCENT", "RxKit_release"})
    public static final class CompressKeys {
        @NotNull
        public static final CompressKeys INSTANCE = new CompressKeys();
        @NotNull
        public static final String PERCENT = "PERCENT";
        @NotNull
        public static final String ERROR = "ERROR";

        private CompressKeys() {
        }
    }
}

